/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.content.Context;
import android.os.Handler;
import android.support.v4.content.Loader;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.Request;
import com.facebook.Response;
import com.facebook.internal.CacheableRequestBatch;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.widget.SimpleGraphObjectCursor;

class GraphObjectPagingLoader<T extends GraphObject>
extends Loader<SimpleGraphObjectCursor<T>> {
    private final Class<T> graphObjectClass;
    private boolean skipRoundtripIfCached;
    private Request originalRequest;
    private Request currentRequest;
    private Request nextRequest;
    private OnErrorListener onErrorListener;
    private SimpleGraphObjectCursor<T> cursor;
    private boolean appendResults = false;
    private boolean loading = false;

    public GraphObjectPagingLoader(Context context, Class<T> graphObjectClass) {
        super(context);
        this.graphObjectClass = graphObjectClass;
    }

    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public void setOnErrorListener(OnErrorListener listener) {
        this.onErrorListener = listener;
    }

    public SimpleGraphObjectCursor<T> getCursor() {
        return this.cursor;
    }

    public void clearResults() {
        this.nextRequest = null;
        this.originalRequest = null;
        this.currentRequest = null;
        this.deliverResult(null);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void startLoading(Request request, boolean skipRoundtripIfCached) {
        this.originalRequest = request;
        this.startLoading(request, skipRoundtripIfCached, 0L);
    }

    public void refreshOriginalRequest(long afterDelay) {
        if (this.originalRequest == null) {
            throw new FacebookException("refreshOriginalRequest may not be called until after startLoading has been called.");
        }
        this.startLoading(this.originalRequest, false, afterDelay);
    }

    public void followNextLink() {
        if (this.nextRequest != null) {
            this.appendResults = true;
            this.currentRequest = this.nextRequest;
            this.currentRequest.setCallback(new Request.Callback(){

                @Override
                public void onCompleted(Response response) {
                    GraphObjectPagingLoader.this.requestCompleted(response);
                }
            });
            this.loading = true;
            CacheableRequestBatch batch = this.putRequestIntoBatch(this.currentRequest, this.skipRoundtripIfCached);
            Request.executeBatchAsync(batch);
        }
    }

    public void deliverResult(SimpleGraphObjectCursor<T> cursor) {
        SimpleGraphObjectCursor<T> oldCursor = this.cursor;
        this.cursor = cursor;
        if (this.isStarted()) {
            super.deliverResult(cursor);
            if (oldCursor != null && oldCursor != cursor && !oldCursor.isClosed()) {
                oldCursor.close();
            }
        }
    }

    protected void onStartLoading() {
        super.onStartLoading();
        if (this.cursor != null) {
            this.deliverResult(this.cursor);
        }
    }

    private void startLoading(Request request, boolean skipRoundtripIfCached, long afterDelay) {
        this.skipRoundtripIfCached = skipRoundtripIfCached;
        this.appendResults = false;
        this.nextRequest = null;
        this.currentRequest = request;
        this.currentRequest.setCallback(new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                GraphObjectPagingLoader.this.requestCompleted(response);
            }
        });
        this.loading = true;
        final CacheableRequestBatch batch = this.putRequestIntoBatch(request, skipRoundtripIfCached);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Request.executeBatchAsync(batch);
            }
        };
        if (afterDelay == 0L) {
            r.run();
        } else {
            Handler handler = new Handler();
            handler.postDelayed(r, afterDelay);
        }
    }

    private CacheableRequestBatch putRequestIntoBatch(Request request, boolean skipRoundtripIfCached) {
        CacheableRequestBatch batch = new CacheableRequestBatch(request);
        batch.setForceRoundTrip(!skipRoundtripIfCached);
        return batch;
    }

    private void requestCompleted(Response response) {
        FacebookException exception;
        Request request = response.getRequest();
        if (request != this.currentRequest) {
            return;
        }
        this.loading = false;
        this.currentRequest = null;
        FacebookRequestError requestError = response.getError();
        FacebookException facebookException = exception = requestError == null ? null : requestError.getException();
        if (response.getGraphObject() == null && exception == null) {
            exception = new FacebookException("GraphObjectPagingLoader received neither a result nor an error.");
        }
        if (exception != null) {
            this.nextRequest = null;
            if (this.onErrorListener != null) {
                this.onErrorListener.onError(exception, this);
            }
        } else {
            this.addResults(response);
        }
    }

    private void addResults(Response response) {
        boolean haveData;
        SimpleGraphObjectCursor<T> cursorToModify = this.cursor == null || !this.appendResults ? new SimpleGraphObjectCursor<T>() : new SimpleGraphObjectCursor<T>(this.cursor);
        PagedResults result = response.getGraphObjectAs(PagedResults.class);
        boolean fromCache = response.getIsFromCache();
        GraphObjectList<T> data = result.getData().castToListOf(this.graphObjectClass);
        boolean bl = haveData = data.size() > 0;
        if (haveData) {
            this.nextRequest = response.getRequestForPagedResults(Response.PagingDirection.NEXT);
            cursorToModify.addGraphObjects(data, fromCache);
            if (this.nextRequest != null) {
                cursorToModify.setMoreObjectsAvailable(true);
            } else {
                cursorToModify.setMoreObjectsAvailable(false);
            }
        }
        if (!haveData) {
            cursorToModify.setMoreObjectsAvailable(false);
            cursorToModify.setFromCache(fromCache);
            this.nextRequest = null;
        }
        if (!fromCache) {
            this.skipRoundtripIfCached = false;
        }
        this.deliverResult(cursorToModify);
    }

    public static interface OnErrorListener {
        public void onError(FacebookException var1, GraphObjectPagingLoader<?> var2);
    }

    static interface PagedResults
    extends GraphObject {
        public GraphObjectList<GraphObject> getData();
    }
}

