/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookException;
import com.facebook.FacebookGraphObjectException;
import com.facebook.NativeAppCallAttachmentStore;
import com.facebook.NativeAppCallContentProvider;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.OpenGraphAction;
import com.facebook.model.OpenGraphObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FacebookDialog {
    public static final String COMPLETION_GESTURE_CANCEL = "cancel";
    private static final String EXTRA_DIALOG_COMPLETE_KEY = "com.facebook.platform.extra.DID_COMPLETE";
    private static final String EXTRA_DIALOG_COMPLETION_GESTURE_KEY = "com.facebook.platform.extra.COMPLETION_GESTURE";
    private static final String EXTRA_DIALOG_COMPLETION_ID_KEY = "com.facebook.platform.extra.POST_ID";
    private static NativeAppCallAttachmentStore attachmentStore;
    private Activity activity;
    private Fragment fragment;
    private PendingCall appCall;
    private OnPresentCallback onPresentCallback;

    public static boolean getNativeDialogDidComplete(Bundle result) {
        return result.getBoolean(EXTRA_DIALOG_COMPLETE_KEY, false);
    }

    public static String getNativeDialogCompletionGesture(Bundle result) {
        return result.getString(EXTRA_DIALOG_COMPLETION_GESTURE_KEY);
    }

    public static String getNativeDialogPostId(Bundle result) {
        return result.getString(EXTRA_DIALOG_COMPLETION_ID_KEY);
    }

    private FacebookDialog(Activity activity, Fragment fragment, PendingCall appCall, OnPresentCallback onPresentCallback) {
        this.activity = activity;
        this.fragment = fragment;
        this.appCall = appCall;
        this.onPresentCallback = onPresentCallback;
    }

    public PendingCall present() {
        FacebookDialog.logDialogActivity(this.activity, this.fragment, FacebookDialog.getEventName(this.appCall.getRequestIntent()), "Completed");
        if (this.onPresentCallback != null) {
            try {
                this.onPresentCallback.onPresent((Context)this.activity);
            }
            catch (Exception e) {
                throw new FacebookException(e);
            }
        }
        if (this.fragment != null) {
            this.fragment.startActivityForResult(this.appCall.getRequestIntent(), this.appCall.getRequestCode());
        } else {
            this.activity.startActivityForResult(this.appCall.getRequestIntent(), this.appCall.getRequestCode());
        }
        return this.appCall;
    }

    public static boolean handleActivityResult(Context context, PendingCall appCall, int requestCode, Intent data, Callback callback) {
        if (requestCode != appCall.getRequestCode()) {
            return false;
        }
        if (attachmentStore != null) {
            attachmentStore.cleanupAttachmentsForCall(context, appCall.getCallId());
        }
        if (callback != null) {
            if (NativeProtocol.isErrorResult(data)) {
                Exception error = NativeProtocol.getErrorFromResult(data);
                callback.onError(appCall, error, data.getExtras());
            } else {
                callback.onComplete(appCall, NativeProtocol.getSuccessResultsFromIntent(data));
            }
        }
        return true;
    }

    public static boolean canPresentShareDialog(Context context, ShareDialogFeature ... features) {
        return FacebookDialog.handleCanPresent(context, EnumSet.of(ShareDialogFeature.SHARE_DIALOG, features));
    }

    public static boolean canPresentMessageDialog(Context context, MessageDialogFeature ... features) {
        return FacebookDialog.handleCanPresent(context, EnumSet.of(MessageDialogFeature.MESSAGE_DIALOG, features));
    }

    public static boolean canPresentOpenGraphActionDialog(Context context, OpenGraphActionDialogFeature ... features) {
        return FacebookDialog.handleCanPresent(context, EnumSet.of(OpenGraphActionDialogFeature.OG_ACTION_DIALOG, features));
    }

    public static boolean canPresentOpenGraphMessageDialog(Context context, OpenGraphMessageDialogFeature ... features) {
        return FacebookDialog.handleCanPresent(context, EnumSet.of(OpenGraphMessageDialogFeature.OG_MESSAGE_DIALOG, features));
    }

    private static boolean handleCanPresent(Context context, Iterable<? extends DialogFeature> features) {
        return FacebookDialog.getProtocolVersionForNativeDialog(context, FacebookDialog.getActionForFeatures(features), FacebookDialog.getMinVersionForFeatures(features)) != -1;
    }

    private static int getProtocolVersionForNativeDialog(Context context, String action, int requiredVersion) {
        return NativeProtocol.getLatestAvailableProtocolVersionForAction(context, action, requiredVersion);
    }

    private static NativeAppCallAttachmentStore getAttachmentStore() {
        if (attachmentStore == null) {
            attachmentStore = new NativeAppCallAttachmentStore();
        }
        return attachmentStore;
    }

    private static int getMinVersionForFeatures(Iterable<? extends DialogFeature> features) {
        int minVersion = Integer.MIN_VALUE;
        for (DialogFeature dialogFeature : features) {
            minVersion = Math.max(minVersion, dialogFeature.getMinVersion());
        }
        return minVersion;
    }

    private static String getActionForFeatures(Iterable<? extends DialogFeature> features) {
        String action = null;
        Iterator<? extends DialogFeature> iterator = features.iterator();
        if (iterator.hasNext()) {
            DialogFeature feature = iterator.next();
            action = feature.getAction();
        }
        return action;
    }

    private static void logDialogActivity(Activity activity, Fragment fragment, String eventName, String outcome) {
        AppEventsLogger logger = AppEventsLogger.newLogger((Context)(fragment != null ? fragment.getActivity() : activity));
        Bundle parameters = new Bundle();
        parameters.putString("fb_dialog_outcome", outcome);
        logger.logSdkEvent(eventName, null, parameters);
    }

    private static String getEventName(Intent intent) {
        String action = intent.getStringExtra("com.facebook.platform.protocol.PROTOCOL_ACTION");
        boolean hasPhotos = intent.hasExtra("com.facebook.platform.extra.PHOTOS");
        return FacebookDialog.getEventName(action, hasPhotos);
    }

    private static String getEventName(String action, boolean hasPhotos) {
        String eventName;
        if (action.equals("com.facebook.platform.action.request.FEED_DIALOG")) {
            eventName = hasPhotos ? "fb_dialogs_present_share_photo" : "fb_dialogs_present_share";
        } else if (action.equals("com.facebook.platform.action.request.MESSAGE_DIALOG")) {
            eventName = hasPhotos ? "fb_dialogs_present_message_photo" : "fb_dialogs_present_message";
        } else if (action.equals("com.facebook.platform.action.request.OGACTIONPUBLISH_DIALOG")) {
            eventName = "fb_dialogs_present_share_og";
        } else if (action.equals("com.facebook.platform.action.request.OGMESSAGEPUBLISH_DIALOG")) {
            eventName = "fb_dialogs_present_message_og";
        } else {
            throw new FacebookException("An unspecified action was presented");
        }
        return eventName;
    }

    /* synthetic */ FacebookDialog(Activity activity, Fragment fragment, PendingCall pendingCall, OnPresentCallback onPresentCallback, FacebookDialog facebookDialog) {
        this(activity, fragment, pendingCall, onPresentCallback);
    }

    public static abstract class Builder<CONCRETE extends Builder<?>> {
        protected final Activity activity;
        protected final String applicationId;
        protected final PendingCall appCall;
        protected Fragment fragment;
        protected String applicationName;
        protected HashMap<String, Bitmap> imageAttachments = new HashMap();
        protected HashMap<String, File> imageAttachmentFiles = new HashMap();

        public Builder(Activity activity) {
            Validate.notNull(activity, "activity");
            this.activity = activity;
            this.applicationId = Utility.getMetadataApplicationId((Context)activity);
            this.appCall = new PendingCall(64207);
        }

        public CONCRETE setRequestCode(int requestCode) {
            this.appCall.setRequestCode(requestCode);
            Builder result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            Builder result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setFragment(Fragment fragment) {
            this.fragment = fragment;
            Builder result = this;
            return (CONCRETE)result;
        }

        public FacebookDialog build() {
            this.validate();
            String action = FacebookDialog.getActionForFeatures(this.getDialogFeatures());
            int protocolVersion = FacebookDialog.getProtocolVersionForNativeDialog((Context)this.activity, action, FacebookDialog.getMinVersionForFeatures(this.getDialogFeatures()));
            Bundle extras = null;
            extras = NativeProtocol.isVersionCompatibleWithBucketedIntent(protocolVersion) ? this.getMethodArguments() : this.setBundleExtras(new Bundle());
            Intent intent = NativeProtocol.createPlatformActivityIntent((Context)this.activity, this.appCall.getCallId().toString(), action, protocolVersion, this.applicationName, extras);
            if (intent == null) {
                FacebookDialog.logDialogActivity(this.activity, this.fragment, FacebookDialog.getEventName(action, extras.containsKey("com.facebook.platform.extra.PHOTOS")), "Failed");
                throw new FacebookException("Unable to create Intent; this likely means the Facebook app is not installed.");
            }
            this.appCall.setRequestIntent(intent);
            return new FacebookDialog(this.activity, this.fragment, this.appCall, this.getOnPresentCallback(), null);
        }

        public boolean canPresent() {
            return FacebookDialog.handleCanPresent((Context)this.activity, this.getDialogFeatures());
        }

        void validate() {
        }

        OnPresentCallback getOnPresentCallback() {
            return new OnPresentCallback(){

                @Override
                public void onPresent(Context context) throws Exception {
                    if (Builder.this.imageAttachments != null && Builder.this.imageAttachments.size() > 0) {
                        FacebookDialog.getAttachmentStore().addAttachmentsForCall(context, Builder.this.appCall.getCallId(), Builder.this.imageAttachments);
                    }
                    if (Builder.this.imageAttachmentFiles != null && Builder.this.imageAttachmentFiles.size() > 0) {
                        FacebookDialog.getAttachmentStore().addAttachmentFilesForCall(context, Builder.this.appCall.getCallId(), Builder.this.imageAttachmentFiles);
                    }
                }
            };
        }

        protected List<String> addImageAttachments(Collection<Bitmap> bitmaps) {
            ArrayList<String> attachmentUrls = new ArrayList<String>();
            for (Bitmap bitmap : bitmaps) {
                String attachmentName = UUID.randomUUID().toString();
                this.addImageAttachment(attachmentName, bitmap);
                String url = NativeAppCallContentProvider.getAttachmentUrl(this.applicationId, this.appCall.getCallId(), attachmentName);
                attachmentUrls.add(url);
            }
            return attachmentUrls;
        }

        protected List<String> addImageAttachmentFiles(Collection<File> bitmapFiles) {
            ArrayList<String> attachmentUrls = new ArrayList<String>();
            for (File bitmapFile : bitmapFiles) {
                String attachmentName = UUID.randomUUID().toString();
                this.addImageAttachment(attachmentName, bitmapFile);
                String url = NativeAppCallContentProvider.getAttachmentUrl(this.applicationId, this.appCall.getCallId(), attachmentName);
                attachmentUrls.add(url);
            }
            return attachmentUrls;
        }

        List<String> getImageAttachmentNames() {
            return new ArrayList<String>(this.imageAttachments.keySet());
        }

        protected abstract Bundle setBundleExtras(Bundle var1);

        protected abstract Bundle getMethodArguments();

        protected void putExtra(Bundle extras, String key, String value) {
            if (value != null) {
                extras.putString(key, value);
            }
        }

        abstract EnumSet<? extends DialogFeature> getDialogFeatures();

        protected CONCRETE addImageAttachment(String imageName, Bitmap bitmap) {
            this.imageAttachments.put(imageName, bitmap);
            Builder result = this;
            return (CONCRETE)result;
        }

        protected CONCRETE addImageAttachment(String imageName, File attachment) {
            this.imageAttachmentFiles.put(imageName, attachment);
            Builder result = this;
            return (CONCRETE)result;
        }
    }

    public static interface Callback {
        public void onComplete(PendingCall var1, Bundle var2);

        public void onError(PendingCall var1, Exception var2, Bundle var3);
    }

    private static interface DialogFeature {
        public String getAction();

        public int getMinVersion();
    }

    public static class MessageDialogBuilder
    extends ShareDialogBuilderBase<MessageDialogBuilder> {
        public MessageDialogBuilder(Activity activity) {
            super(activity);
        }

        @Override
        EnumSet<? extends DialogFeature> getDialogFeatures() {
            return EnumSet.of(MessageDialogFeature.MESSAGE_DIALOG);
        }
    }

    public static enum MessageDialogFeature implements DialogFeature
    {
        MESSAGE_DIALOG(20140204),
        PHOTOS(20140324);

        private int minVersion;

        private MessageDialogFeature(int minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public String getAction() {
            return "com.facebook.platform.action.request.MESSAGE_DIALOG";
        }

        @Override
        public int getMinVersion() {
            return this.minVersion;
        }
    }

    static interface OnPresentCallback {
        public void onPresent(Context var1) throws Exception;
    }

    public static class OpenGraphActionDialogBuilder
    extends OpenGraphDialogBuilderBase<OpenGraphActionDialogBuilder> {
        @Deprecated
        public OpenGraphActionDialogBuilder(Activity activity, OpenGraphAction action, String actionType, String previewPropertyName) {
            super(activity, action, actionType, previewPropertyName);
        }

        public OpenGraphActionDialogBuilder(Activity activity, OpenGraphAction action, String previewPropertyName) {
            super(activity, action, previewPropertyName);
        }

        @Override
        EnumSet<? extends DialogFeature> getDialogFeatures() {
            return EnumSet.of(OpenGraphActionDialogFeature.OG_ACTION_DIALOG);
        }
    }

    public static enum OpenGraphActionDialogFeature implements DialogFeature
    {
        OG_ACTION_DIALOG(20130618);

        private int minVersion;

        private OpenGraphActionDialogFeature(int minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public String getAction() {
            return "com.facebook.platform.action.request.OGACTIONPUBLISH_DIALOG";
        }

        @Override
        public int getMinVersion() {
            return this.minVersion;
        }
    }

    private static abstract class OpenGraphDialogBuilderBase<CONCRETE extends OpenGraphDialogBuilderBase<?>>
    extends Builder<CONCRETE> {
        private String previewPropertyName;
        private OpenGraphAction action;
        private String actionType;
        private boolean dataErrorsFatal;

        @Deprecated
        public OpenGraphDialogBuilderBase(Activity activity, OpenGraphAction action, String actionType, String previewPropertyName) {
            super(activity);
            Validate.notNull(action, "action");
            Validate.notNullOrEmpty(actionType, "actionType");
            Validate.notNullOrEmpty(previewPropertyName, "previewPropertyName");
            if (action.getProperty(previewPropertyName) == null) {
                throw new IllegalArgumentException("A property named \"" + previewPropertyName + "\" was not found on the action.  The name of " + "the preview property must match the name of an action property.");
            }
            String typeOnAction = action.getType();
            if (!Utility.isNullOrEmpty(typeOnAction) && !typeOnAction.equals(actionType)) {
                throw new IllegalArgumentException("'actionType' must match the type of 'action' if it is specified. Consider using OpenGraphDialogBuilderBase(Activity activity, OpenGraphAction action, String previewPropertyName) instead.");
            }
            this.action = action;
            this.actionType = actionType;
            this.previewPropertyName = previewPropertyName;
        }

        public OpenGraphDialogBuilderBase(Activity activity, OpenGraphAction action, String previewPropertyName) {
            super(activity);
            Validate.notNull(action, "action");
            Validate.notNullOrEmpty(action.getType(), "action.getType()");
            Validate.notNullOrEmpty(previewPropertyName, "previewPropertyName");
            if (action.getProperty(previewPropertyName) == null) {
                throw new IllegalArgumentException("A property named \"" + previewPropertyName + "\" was not found on the action.  The name of " + "the preview property must match the name of an action property.");
            }
            this.action = action;
            this.actionType = action.getType();
            this.previewPropertyName = previewPropertyName;
        }

        public CONCRETE setDataErrorsFatal(boolean dataErrorsFatal) {
            this.dataErrorsFatal = dataErrorsFatal;
            OpenGraphDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setImageAttachmentsForAction(List<Bitmap> bitmaps) {
            return this.setImageAttachmentsForAction(bitmaps, false);
        }

        public CONCRETE setImageAttachmentsForAction(List<Bitmap> bitmaps, boolean isUserGenerated) {
            Validate.containsNoNulls(bitmaps, "bitmaps");
            if (this.action == null) {
                throw new FacebookException("Can not set attachments prior to setting action.");
            }
            List<String> attachmentUrls = this.addImageAttachments(bitmaps);
            this.updateActionAttachmentUrls(attachmentUrls, isUserGenerated);
            OpenGraphDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setImageAttachmentFilesForAction(List<File> bitmapFiles) {
            return this.setImageAttachmentFilesForAction(bitmapFiles, false);
        }

        public CONCRETE setImageAttachmentFilesForAction(List<File> bitmapFiles, boolean isUserGenerated) {
            Validate.containsNoNulls(bitmapFiles, "bitmapFiles");
            if (this.action == null) {
                throw new FacebookException("Can not set attachments prior to setting action.");
            }
            List<String> attachmentUrls = this.addImageAttachmentFiles(bitmapFiles);
            this.updateActionAttachmentUrls(attachmentUrls, isUserGenerated);
            OpenGraphDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        private void updateActionAttachmentUrls(List<String> attachmentUrls, boolean isUserGenerated) {
            List<JSONObject> attachments = this.action.getImage();
            if (attachments == null) {
                attachments = new ArrayList<JSONObject>(attachmentUrls.size());
            }
            for (String url : attachmentUrls) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("url", (Object)url);
                    if (isUserGenerated) {
                        jsonObject.put("user_generated", true);
                    }
                }
                catch (JSONException e) {
                    throw new FacebookException("Unable to attach images", e);
                }
                attachments.add(jsonObject);
            }
            this.action.setImage(attachments);
        }

        public CONCRETE setImageAttachmentsForObject(String objectProperty, List<Bitmap> bitmaps) {
            return this.setImageAttachmentsForObject(objectProperty, bitmaps, false);
        }

        public CONCRETE setImageAttachmentsForObject(String objectProperty, List<Bitmap> bitmaps, boolean isUserGenerated) {
            Validate.notNull(objectProperty, "objectProperty");
            Validate.containsNoNulls(bitmaps, "bitmaps");
            if (this.action == null) {
                throw new FacebookException("Can not set attachments prior to setting action.");
            }
            List<String> attachmentUrls = this.addImageAttachments(bitmaps);
            this.updateObjectAttachmentUrls(objectProperty, attachmentUrls, isUserGenerated);
            OpenGraphDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setImageAttachmentFilesForObject(String objectProperty, List<File> bitmapFiles) {
            return this.setImageAttachmentFilesForObject(objectProperty, bitmapFiles, false);
        }

        public CONCRETE setImageAttachmentFilesForObject(String objectProperty, List<File> bitmapFiles, boolean isUserGenerated) {
            Validate.notNull(objectProperty, "objectProperty");
            Validate.containsNoNulls(bitmapFiles, "bitmapFiles");
            if (this.action == null) {
                throw new FacebookException("Can not set attachments prior to setting action.");
            }
            List<String> attachmentUrls = this.addImageAttachmentFiles(bitmapFiles);
            this.updateObjectAttachmentUrls(objectProperty, attachmentUrls, isUserGenerated);
            OpenGraphDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        void updateObjectAttachmentUrls(String objectProperty, List<String> attachmentUrls, boolean isUserGenerated) {
            OpenGraphObject object;
            try {
                object = this.action.getPropertyAs(objectProperty, OpenGraphObject.class);
                if (object == null) {
                    throw new IllegalArgumentException("Action does not contain a property '" + objectProperty + "'");
                }
            }
            catch (FacebookGraphObjectException exception) {
                throw new IllegalArgumentException("Property '" + objectProperty + "' is not a graph object");
            }
            if (!object.getCreateObject()) {
                throw new IllegalArgumentException("The Open Graph object in '" + objectProperty + "' is not marked for creation");
            }
            GraphObjectList<GraphObject> attachments = object.getImage();
            if (attachments == null) {
                attachments = GraphObject.Factory.createList(GraphObject.class);
            }
            for (String url : attachmentUrls) {
                GraphObject graphObject = GraphObject.Factory.create();
                graphObject.setProperty("url", url);
                if (isUserGenerated) {
                    graphObject.setProperty("user_generated", true);
                }
                attachments.add(graphObject);
            }
            object.setImage(attachments);
        }

        @Override
        protected Bundle setBundleExtras(Bundle extras) {
            this.putExtra(extras, "com.facebook.platform.extra.PREVIEW_PROPERTY_NAME", this.previewPropertyName);
            this.putExtra(extras, "com.facebook.platform.extra.ACTION_TYPE", this.actionType);
            extras.putBoolean("com.facebook.platform.extra.DATA_FAILURES_FATAL", this.dataErrorsFatal);
            JSONObject jsonAction = this.action.getInnerJSONObject();
            jsonAction = this.flattenChildrenOfGraphObject(jsonAction);
            String jsonString = jsonAction.toString();
            this.putExtra(extras, "com.facebook.platform.extra.ACTION", jsonString);
            return extras;
        }

        @Override
        protected Bundle getMethodArguments() {
            Bundle methodArgs = new Bundle();
            this.putExtra(methodArgs, "PREVIEW_PROPERTY_NAME", this.previewPropertyName);
            this.putExtra(methodArgs, "ACTION_TYPE", this.actionType);
            methodArgs.putBoolean("DATA_FAILURES_FATAL", this.dataErrorsFatal);
            JSONObject jsonAction = this.action.getInnerJSONObject();
            jsonAction = this.flattenChildrenOfGraphObject(jsonAction);
            String jsonString = jsonAction.toString();
            this.putExtra(methodArgs, "ACTION", jsonString);
            return methodArgs;
        }

        private JSONObject flattenChildrenOfGraphObject(JSONObject graphObject) {
            try {
                graphObject = new JSONObject(graphObject.toString());
                Iterator keys = graphObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (key.equalsIgnoreCase("image")) continue;
                    Object object = graphObject.get(key);
                    object = this.flattenObject(object);
                    graphObject.put(key, object);
                }
                return graphObject;
            }
            catch (JSONException e) {
                throw new FacebookException(e);
            }
        }

        private Object flattenObject(Object object) throws JSONException {
            if (object == null) {
                return null;
            }
            if (object instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)object;
                if (jsonObject.optBoolean("fbsdk:create_object")) {
                    return object;
                }
                if (jsonObject.has("id")) {
                    return jsonObject.getString("id");
                }
                if (jsonObject.has("url")) {
                    return jsonObject.getString("url");
                }
            } else if (object instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)object;
                JSONArray newArray = new JSONArray();
                int length = jsonArray.length();
                int i = 0;
                while (i < length) {
                    newArray.put(this.flattenObject(jsonArray.get(i)));
                    ++i;
                }
                return newArray;
            }
            return object;
        }
    }

    public static class OpenGraphMessageDialogBuilder
    extends OpenGraphDialogBuilderBase<OpenGraphMessageDialogBuilder> {
        public OpenGraphMessageDialogBuilder(Activity activity, OpenGraphAction action, String previewPropertyName) {
            super(activity, action, previewPropertyName);
        }

        @Override
        EnumSet<? extends DialogFeature> getDialogFeatures() {
            return EnumSet.of(OpenGraphMessageDialogFeature.OG_MESSAGE_DIALOG);
        }
    }

    public static enum OpenGraphMessageDialogFeature implements DialogFeature
    {
        OG_MESSAGE_DIALOG(20140204);

        private int minVersion;

        private OpenGraphMessageDialogFeature(int minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public String getAction() {
            return "com.facebook.platform.action.request.OGMESSAGEPUBLISH_DIALOG";
        }

        @Override
        public int getMinVersion() {
            return this.minVersion;
        }
    }

    public static class PendingCall
    implements Parcelable {
        private UUID callId;
        private Intent requestIntent;
        private int requestCode;
        public static final Parcelable.Creator<PendingCall> CREATOR = new Parcelable.Creator<PendingCall>(){

            public PendingCall createFromParcel(Parcel in) {
                return new PendingCall(in);
            }

            public PendingCall[] newArray(int size) {
                return new PendingCall[size];
            }
        };

        public PendingCall(int requestCode) {
            this.callId = UUID.randomUUID();
            this.requestCode = requestCode;
        }

        private PendingCall(Parcel in) {
            this.callId = UUID.fromString(in.readString());
            this.requestIntent = (Intent)in.readParcelable(null);
            this.requestCode = in.readInt();
        }

        private void setRequestIntent(Intent requestIntent) {
            this.requestIntent = requestIntent;
        }

        public Intent getRequestIntent() {
            return this.requestIntent;
        }

        public UUID getCallId() {
            return this.callId;
        }

        private void setRequestCode(int requestCode) {
            this.requestCode = requestCode;
        }

        public int getRequestCode() {
            return this.requestCode;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeString(this.callId.toString());
            parcel.writeParcelable((Parcelable)this.requestIntent, 0);
            parcel.writeInt(this.requestCode);
        }
    }

    private static abstract class PhotoDialogBuilderBase<CONCRETE extends PhotoDialogBuilderBase<?>>
    extends Builder<CONCRETE> {
        static int MAXIMUM_PHOTO_COUNT = 6;
        private String place;
        private ArrayList<String> friends;
        private ArrayList<String> imageAttachmentUrls = new ArrayList();

        public PhotoDialogBuilderBase(Activity activity) {
            super(activity);
        }

        public CONCRETE setPlace(String place) {
            this.place = place;
            PhotoDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setFriends(List<String> friends) {
            this.friends = new ArrayList<String>(friends);
            PhotoDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE addPhotos(Collection<Bitmap> photos) {
            this.imageAttachmentUrls.addAll(this.addImageAttachments(photos));
            PhotoDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE addPhotoFiles(Collection<File> photos) {
            this.imageAttachmentUrls.addAll(this.addImageAttachmentFiles(photos));
            PhotoDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        abstract int getMaximumNumberOfPhotos();

        @Override
        void validate() {
            super.validate();
            if (this.imageAttachmentUrls.isEmpty()) {
                throw new FacebookException("Must specify at least one photo.");
            }
            if (this.imageAttachmentUrls.size() > this.getMaximumNumberOfPhotos()) {
                throw new FacebookException(String.format("Cannot add more than %d photos.", this.getMaximumNumberOfPhotos()));
            }
        }

        @Override
        protected Bundle setBundleExtras(Bundle extras) {
            this.putExtra(extras, "com.facebook.platform.extra.APPLICATION_ID", this.applicationId);
            this.putExtra(extras, "com.facebook.platform.extra.APPLICATION_NAME", this.applicationName);
            this.putExtra(extras, "com.facebook.platform.extra.PLACE", this.place);
            extras.putStringArrayList("com.facebook.platform.extra.PHOTOS", this.imageAttachmentUrls);
            if (!Utility.isNullOrEmpty(this.friends)) {
                extras.putStringArrayList("com.facebook.platform.extra.FRIENDS", this.friends);
            }
            return extras;
        }

        @Override
        protected Bundle getMethodArguments() {
            Bundle methodArgs = new Bundle();
            this.putExtra(methodArgs, "PLACE", this.place);
            methodArgs.putStringArrayList("PHOTOS", this.imageAttachmentUrls);
            if (!Utility.isNullOrEmpty(this.friends)) {
                methodArgs.putStringArrayList("FRIENDS", this.friends);
            }
            return methodArgs;
        }
    }

    public static class PhotoMessageDialogBuilder
    extends PhotoDialogBuilderBase<PhotoMessageDialogBuilder> {
        public PhotoMessageDialogBuilder(Activity activity) {
            super(activity);
        }

        @Override
        EnumSet<? extends DialogFeature> getDialogFeatures() {
            return EnumSet.of(MessageDialogFeature.MESSAGE_DIALOG, MessageDialogFeature.PHOTOS);
        }

        @Override
        int getMaximumNumberOfPhotos() {
            return MAXIMUM_PHOTO_COUNT;
        }
    }

    public static class PhotoShareDialogBuilder
    extends PhotoDialogBuilderBase<PhotoShareDialogBuilder> {
        public PhotoShareDialogBuilder(Activity activity) {
            super(activity);
        }

        @Override
        EnumSet<? extends DialogFeature> getDialogFeatures() {
            return EnumSet.of(ShareDialogFeature.SHARE_DIALOG, ShareDialogFeature.PHOTOS);
        }

        @Override
        int getMaximumNumberOfPhotos() {
            return MAXIMUM_PHOTO_COUNT;
        }
    }

    public static class ShareDialogBuilder
    extends ShareDialogBuilderBase<ShareDialogBuilder> {
        public ShareDialogBuilder(Activity activity) {
            super(activity);
        }

        @Override
        EnumSet<? extends DialogFeature> getDialogFeatures() {
            return EnumSet.of(ShareDialogFeature.SHARE_DIALOG);
        }
    }

    private static abstract class ShareDialogBuilderBase<CONCRETE extends ShareDialogBuilderBase<?>>
    extends Builder<CONCRETE> {
        private String name;
        private String caption;
        private String description;
        protected String link;
        private String picture;
        private String place;
        private ArrayList<String> friends;
        private String ref;
        private boolean dataErrorsFatal;

        public ShareDialogBuilderBase(Activity activity) {
            super(activity);
        }

        public CONCRETE setName(String name) {
            this.name = name;
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setCaption(String caption) {
            this.caption = caption;
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setDescription(String description) {
            this.description = description;
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setLink(String link) {
            this.link = link;
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setPicture(String picture) {
            this.picture = picture;
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setPlace(String place) {
            this.place = place;
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setFriends(List<String> friends) {
            this.friends = new ArrayList<String>(friends);
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setRef(String ref) {
            this.ref = ref;
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        public CONCRETE setDataErrorsFatal(boolean dataErrorsFatal) {
            this.dataErrorsFatal = dataErrorsFatal;
            ShareDialogBuilderBase result = this;
            return (CONCRETE)result;
        }

        @Override
        protected Bundle setBundleExtras(Bundle extras) {
            this.putExtra(extras, "com.facebook.platform.extra.APPLICATION_ID", this.applicationId);
            this.putExtra(extras, "com.facebook.platform.extra.APPLICATION_NAME", this.applicationName);
            this.putExtra(extras, "com.facebook.platform.extra.TITLE", this.name);
            this.putExtra(extras, "com.facebook.platform.extra.SUBTITLE", this.caption);
            this.putExtra(extras, "com.facebook.platform.extra.DESCRIPTION", this.description);
            this.putExtra(extras, "com.facebook.platform.extra.LINK", this.link);
            this.putExtra(extras, "com.facebook.platform.extra.IMAGE", this.picture);
            this.putExtra(extras, "com.facebook.platform.extra.PLACE", this.place);
            this.putExtra(extras, "com.facebook.platform.extra.TITLE", this.name);
            this.putExtra(extras, "com.facebook.platform.extra.REF", this.ref);
            extras.putBoolean("com.facebook.platform.extra.DATA_FAILURES_FATAL", this.dataErrorsFatal);
            if (!Utility.isNullOrEmpty(this.friends)) {
                extras.putStringArrayList("com.facebook.platform.extra.FRIENDS", this.friends);
            }
            return extras;
        }

        @Override
        protected Bundle getMethodArguments() {
            Bundle methodArguments = new Bundle();
            this.putExtra(methodArguments, "TITLE", this.name);
            this.putExtra(methodArguments, "SUBTITLE", this.caption);
            this.putExtra(methodArguments, "DESCRIPTION", this.description);
            this.putExtra(methodArguments, "LINK", this.link);
            this.putExtra(methodArguments, "IMAGE", this.picture);
            this.putExtra(methodArguments, "PLACE", this.place);
            this.putExtra(methodArguments, "TITLE", this.name);
            this.putExtra(methodArguments, "REF", this.ref);
            methodArguments.putBoolean("DATA_FAILURES_FATAL", this.dataErrorsFatal);
            if (!Utility.isNullOrEmpty(this.friends)) {
                methodArguments.putStringArrayList("FRIENDS", this.friends);
            }
            return methodArguments;
        }
    }

    public static enum ShareDialogFeature implements DialogFeature
    {
        SHARE_DIALOG(20130618),
        PHOTOS(20140204);

        private int minVersion;

        private ShareDialogFeature(int minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public String getAction() {
            return "com.facebook.platform.action.request.FEED_DIALOG";
        }

        @Override
        public int getMinVersion() {
            return this.minVersion;
        }
    }
}

