/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;

class UrlRedirectCache {
    static final String TAG = UrlRedirectCache.class.getSimpleName();
    private static final String REDIRECT_CONTENT_TAG = String.valueOf(TAG) + "_Redirect";
    private static volatile FileLruCache urlRedirectCache;

    UrlRedirectCache() {
    }

    static synchronized FileLruCache getCache(Context context) throws IOException {
        if (urlRedirectCache == null) {
            urlRedirectCache = new FileLruCache(context.getApplicationContext(), TAG, new FileLruCache.Limits());
        }
        return urlRedirectCache;
    }

    /*
     * Loose catch block
     */
    static URI getRedirectedUri(Context context, URI uri) {
        block10: {
            InputStreamReader reader;
            block9: {
                URI uRI;
                if (uri == null) {
                    return null;
                }
                String uriString = uri.toString();
                reader = null;
                try {
                    InputStream stream;
                    FileLruCache cache = UrlRedirectCache.getCache(context);
                    boolean redirectExists = false;
                    while ((stream = cache.get(uriString, REDIRECT_CONTENT_TAG)) != null) {
                        int bufferLength;
                        redirectExists = true;
                        reader = new InputStreamReader(stream);
                        char[] buffer = new char[128];
                        StringBuilder urlBuilder = new StringBuilder();
                        while ((bufferLength = reader.read(buffer, 0, buffer.length)) > 0) {
                            urlBuilder.append(buffer, 0, bufferLength);
                        }
                        Utility.closeQuietly(reader);
                        uriString = urlBuilder.toString();
                    }
                    if (!redirectExists) break block9;
                    uRI = new URI(uriString);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Utility.closeQuietly(reader);
                    break block10;
                }
                catch (IOException iOException) {
                    Utility.closeQuietly(reader);
                    break block10;
                    {
                        catch (Throwable throwable) {
                            Utility.closeQuietly(reader);
                            throw throwable;
                        }
                    }
                }
                Utility.closeQuietly(reader);
                return uRI;
            }
            Utility.closeQuietly(reader);
        }
        return null;
    }

    static void cacheUriRedirect(Context context, URI fromUri, URI toUri) {
        block6: {
            if (fromUri == null || toUri == null) {
                return;
            }
            OutputStream redirectStream = null;
            try {
                try {
                    FileLruCache cache = UrlRedirectCache.getCache(context);
                    redirectStream = cache.openPutStream(fromUri.toString(), REDIRECT_CONTENT_TAG);
                    redirectStream.write(toUri.toString().getBytes());
                }
                catch (IOException iOException) {
                    Utility.closeQuietly(redirectStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Utility.closeQuietly(redirectStream);
                throw throwable;
            }
            Utility.closeQuietly(redirectStream);
        }
    }

    static void clearCache(Context context) {
        try {
            UrlRedirectCache.getCache(context).clearCache();
        }
        catch (IOException e) {
            Logger.log(LoggingBehavior.CACHE, 5, TAG, "clearCache failed " + e.getMessage());
        }
    }
}

