/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.SparseArray;
import android.view.MotionEvent;
import com.nibiru.lib.BTUtil;
import com.nibiru.lib.controller.GlobalLog;
import com.nibiru.lib.controller.SupportMotionEvent;

public class StickEvent
implements Parcelable {
    private int[] eo = new int[6];
    private long time;
    private long bc;
    private int action;
    private int playerOrder;
    private boolean ep = false;
    private boolean eq = false;
    private boolean er = false;
    public static final int TRANS_X_MASK = 256;
    public static final int TRANS_Y_MASK = 512;
    public static final int TRANS_Z_MASK = 1024;
    public static final int TRANS_RZ_MASK = 2048;
    public static final int TRANS_HAT_MASK = 4096;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    public static final int AXIS_RZ = 3;
    public static final int AXIS_HAT_X = 4;
    public static final int AXIS_HAT_Y = 5;
    public static final int ACTION_MOVE = 0;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new StickEvent(parcel);
        }
    };

    public int[] getAxisValue() {
        return this.eo;
    }

    public long getEventTime() {
        return this.bc;
    }

    public void setEventTime(long l2) {
        this.bc = l2;
    }

    public boolean isHatValue() {
        return this.ep;
    }

    public void setAxisValue(int[] nArray) {
        if (nArray == null) {
            return;
        }
        this.eo = nArray;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int n) {
        this.action = n;
    }

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public void setPlayerOrder(int n) {
        this.playerOrder = n;
    }

    public float getAxisValue(int n) {
        if (this.eo == null) {
            return 0.0f;
        }
        float f2 = 0.0f;
        switch (n) {
            case 0: {
                f2 = ((float)this.eo[0] - 128.0f) / 128.0f;
                break;
            }
            case 1: {
                f2 = (128.0f - (float)this.eo[1]) / 128.0f;
                break;
            }
            case 2: {
                f2 = ((float)this.eo[2] - 128.0f) / 128.0f;
                break;
            }
            case 3: {
                f2 = (128.0f - (float)this.eo[3]) / 128.0f;
                break;
            }
            case 4: {
                return this.eo[4];
            }
            case 5: {
                return this.eo[5];
            }
        }
        if ((double)f2 < 0.08 && (double)f2 > -0.08) {
            f2 = 0.0f;
        }
        return f2;
    }

    public int getRawLX() {
        if (this.eo == null) {
            return 0;
        }
        return this.eo[0] - 128;
    }

    public int getRawLY() {
        if (this.eo == null) {
            return 0;
        }
        return 128 - this.eo[1];
    }

    public int getRawRX() {
        if (this.eo == null) {
            return 0;
        }
        return this.eo[2] - 128;
    }

    public int getRawRY() {
        if (this.eo == null) {
            return 0;
        }
        return 128 - this.eo[3];
    }

    public boolean isEquals(StickEvent object) {
        object = ((StickEvent)object).getAxisValue();
        int n = 0;
        while (n < 4) {
            if (Math.abs((int)(object[n] - this.eo[n])) >= 7) {
                GlobalLog.e("stick event return false");
                return false;
            }
            ++n;
        }
        if (object[4] != this.eo[4] || object[5] != this.eo[5]) {
            GlobalLog.e("stick event return false1");
            return false;
        }
        GlobalLog.e("stick event return true");
        return true;
    }

    public StickEvent() {
    }

    public StickEvent(Parcel parcel) {
        this.playerOrder = parcel.readInt();
        this.action = parcel.readInt();
        this.ep = parcel.readInt() > 0;
        this.time = parcel.readLong();
        if (this.eo == null) {
            this.eo = new int[6];
        }
        this.eo[0] = parcel.readInt();
        this.eo[1] = parcel.readInt();
        this.eo[2] = parcel.readInt();
        this.eo[3] = parcel.readInt();
        this.eo[4] = parcel.readInt();
        this.eo[5] = parcel.readInt();
        this.eq = parcel.readInt() == 1;
        this.er = parcel.readInt() == 1;
    }

    public static StickEvent getDefaultStickEvent(int n) {
        return new StickEvent(-128, -128, -128, -128, 0, 0, n, false);
    }

    public StickEvent(byte by, byte by2, byte by3, byte by4, int n, int n2, int n3, boolean bl) {
        this.a(by, by2, by3, by4, n, n2, n3, bl);
    }

    private void a(byte by, byte by2, byte by3, byte by4, int n, int n2, int n3, boolean bl) {
        if (this.eo == null) {
            this.eo = new int[4];
        }
        this.eo[0] = by & 0xFF;
        this.eo[1] = by2 & 0xFF;
        this.eo[2] = by3 & 0xFF;
        this.eo[3] = by4 & 0xFF;
        this.eo[4] = n;
        this.eo[5] = n2;
        by = 0;
        while (by < 4) {
            if (this.eo[by] > 115 && this.eo[by] < 140) {
                this.eo[by] = 128;
            }
            by = (byte)(by + 1);
        }
        this.playerOrder = n3;
        this.action = 0;
        this.ep = bl;
        this.time = SystemClock.uptimeMillis();
    }

    public StickEvent(MotionEvent motionEvent, int n, int n2) {
        if (BTUtil.getAndroidVersion() < 12) {
            return;
        }
        float f2 = StickEvent.a(motionEvent.getAxisValue(0));
        float f3 = StickEvent.a(motionEvent.getAxisValue(1));
        float f4 = StickEvent.a(motionEvent.getAxisValue(11));
        float f5 = StickEvent.a(motionEvent.getAxisValue(14));
        float f6 = StickEvent.a(motionEvent.getAxisValue(15));
        float f7 = StickEvent.a(motionEvent.getAxisValue(16));
        this.eo[0] = this.a(f2, 0, n2);
        this.eo[1] = this.a(f3, 1, n2);
        this.eo[2] = this.a(f4, 2, n2);
        this.eo[3] = this.a(f5, 3, n2);
        this.eo[4] = this.a(f6, 4, n2);
        this.eo[5] = this.a(f7, 5, n2);
        if (((double)Math.abs(f6) > 0.01 || (double)Math.abs(f7) > 0.01) && (n2 & 0x1000) > 0) {
            this.eo[0] = this.a(f6, 0, n2);
            this.eo[1] = this.a(f7, 1, n2);
            this.eo[4] = 128;
            this.eo[5] = 128;
        }
        this.playerOrder = n;
        this.action = 0;
        this.time = SystemClock.uptimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int a(float f2, int n, int n2) {
        int n3;
        boolean bl = false;
        switch (n) {
            case 0: {
                n = n2 & 0x100;
                bl = true;
                break;
            }
            case 1: {
                n = n2 & 0x200;
                break;
            }
            case 2: {
                n = n2 & 0x400;
                bl = true;
                break;
            }
            case 3: {
                n = n2 & 0x800;
                break;
            }
            case 4: 
            case 5: {
                int n4 = (int)(f2 * 128.0f);
                return StickEvent.d(n4);
            }
            default: {
                return 128;
            }
        }
        if (n == 0) {
            if (!bl) {
                n3 = (int)((1.0f - f2) * 128.0f);
                return StickEvent.d(n3);
            }
        } else if (bl) {
            n3 = (int)((1.0f - f2) * 128.0f);
            return StickEvent.d(n3);
        }
        n3 = (int)((f2 + 1.0f) * 128.0f);
        return StickEvent.d(n3);
    }

    private static int d(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 256) {
            n = 256;
        }
        return n;
    }

    private static float a(float f2) {
        if ((double)Math.abs(f2) < 0.02) {
            return 0.0f;
        }
        return f2;
    }

    public StickEvent(StickEvent stickEvent) {
        int n = 0;
        while (n < this.eo.length) {
            this.eo[n] = stickEvent.eo[n];
            ++n;
        }
        this.time = stickEvent.time;
        this.ep = stickEvent.ep;
        this.playerOrder = stickEvent.playerOrder;
        this.action = stickEvent.action;
        this.eq = stickEvent.eq;
        this.er = stickEvent.er;
    }

    public StickEvent(int n, int n2, boolean bl) {
        if (n == 21) {
            if (bl) {
                this.a((byte)-128, (byte)-128, (byte)0, (byte)-128, 0, 0, n2, false);
                return;
            }
            this.a((byte)0, (byte)-128, (byte)-128, (byte)-128, 0, 0, n2, false);
            return;
        }
        if (n == 22) {
            if (bl) {
                this.a((byte)-128, (byte)-128, (byte)-1, (byte)-128, 0, 0, n2, false);
                return;
            }
            this.a((byte)-1, (byte)-128, (byte)-128, (byte)-128, 0, 0, n2, false);
            return;
        }
        if (n == 20) {
            if (bl) {
                this.a((byte)-128, (byte)-128, (byte)-128, (byte)0, 0, 0, n2, false);
                return;
            }
            this.a((byte)-128, (byte)0, (byte)-128, (byte)-128, 0, 0, n2, false);
            return;
        }
        if (n == 19) {
            if (bl) {
                this.a((byte)-128, (byte)-128, (byte)-128, (byte)-1, 0, 0, n2, false);
                return;
            }
            this.a((byte)-128, (byte)-1, (byte)-128, (byte)-128, 0, 0, n2, false);
        }
    }

    public static synchronized SupportMotionEvent translateTouch(int n, int n2, int n3, int n4) {
        return new SupportMotionEvent(n, n2, n3, n4);
    }

    public static synchronized SupportMotionEvent translateTouch(float f2, float f3, int n, int n2, int n3, int n4, int n5) {
        return new SupportMotionEvent(f2, f3, n, n2, n3, n4, n5);
    }

    public static MotionEvent translateTouch2(int n, int n2, int n3, int n4) {
        long l2 = SystemClock.uptimeMillis();
        if (BTUtil.getAndroidVersion() < 12) {
            MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)n3, (float)n, (float)n2, (float)0.6f, (float)0.3f, (int)0, (float)0.0f, (float)0.0f, (int)65535, (int)0);
            return motionEvent;
        }
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerCoords[] pointerCoordsArray2 = pointerCoordsArray;
        pointerCoordsArray[0] = pointerCoords;
        pointerCoordsArray2[0].x = n;
        pointerCoordsArray2[0].y = n2;
        pointerCoordsArray2[0].pressure = 0.68f;
        pointerCoordsArray2[0].size = 0.6f;
        pointerCoordsArray2[0].setAxisValue(0, (float)n);
        pointerCoordsArray2[0].setAxisValue(1, (float)n2);
        int[] nArray = new int[1];
        Object[] objectArray = nArray;
        nArray[0] = n4;
        if (BTUtil.getAndroidVersion() >= 14) {
            MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[1];
            objectArray = pointerPropertiesArray;
            pointerPropertiesArray[0] = new MotionEvent.PointerProperties();
            objectArray[0].clear();
            objectArray[0].id = n4;
            objectArray[0].toolType = 1;
            return MotionEvent.obtain((long)l2, (long)(l2 + 20L), (int)n3, (int)1, (MotionEvent.PointerProperties[])objectArray, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)65535, (int)0, (int)4098, (int)0);
        }
        return MotionEvent.obtain((long)l2, (long)(l2 + 20L), (int)n3, (int)1, (int[])objectArray, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (float)0.0f, (float)0.0f, (int)65535, (int)0, (int)4098, (int)0);
    }

    public static String getInputStr(MotionEvent motionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = motionEvent.getAction();
        stringBuilder.append(String.valueOf(n) + " ");
        int n2 = motionEvent.getPointerCount();
        stringBuilder.append(String.valueOf(n2) + " ");
        int n3 = 0;
        if (n2 > 1) {
            n3 = n >> 8;
        }
        stringBuilder.append(n3);
        n = 0;
        while (n < n2) {
            stringBuilder.append(" ");
            MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
            motionEvent.getPointerCoords(n, pointerCoords);
            MotionEvent.PointerProperties pointerProperties = new MotionEvent.PointerProperties();
            motionEvent.getPointerProperties(n, pointerProperties);
            stringBuilder.append(String.valueOf(pointerProperties.id) + " " + pointerCoords.x + " " + pointerCoords.y);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static synchronized SupportMotionEvent translateTouch(SparseArray sparseArray, int n, int n2) {
        return new SupportMotionEvent(sparseArray, n, n2);
    }

    public MotionEvent getMotionEvent() {
        if (BTUtil.getAndroidVersion() < 12) {
            MotionEvent motionEvent = MotionEvent.obtain((long)this.time, (long)this.time, (int)this.action, (float)this.getAxisValue(0), (float)this.getAxisValue(1), (float)0.6f, (float)0.3f, (int)0, (float)0.0f, (float)0.0f, (int)65535, (int)0);
            return motionEvent;
        }
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerCoords();
        pointerPropertiesArray.setAxisValue(0, this.getAxisValue(0));
        pointerPropertiesArray.setAxisValue(1, this.getAxisValue(1));
        pointerPropertiesArray.setAxisValue(11, this.getAxisValue(2));
        pointerPropertiesArray.setAxisValue(14, this.getAxisValue(3));
        pointerPropertiesArray.setAxisValue(15, this.getAxisValue(4));
        pointerPropertiesArray.setAxisValue(16, this.getAxisValue(5));
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerCoords[] pointerCoordsArray2 = pointerCoordsArray;
        pointerCoordsArray[0] = pointerPropertiesArray;
        if (BTUtil.getAndroidVersion() < 14) {
            int[] nArray = new int[1];
            pointerPropertiesArray = (MotionEvent.PointerProperties[])nArray;
            nArray[0] = 0;
            return MotionEvent.obtain((long)this.time, (long)this.time, (int)2, (int)1, (int[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (float)0.0f, (float)0.0f, (int)(65530 + this.playerOrder), (int)0, (int)0x1000010, (int)0);
        }
        MotionEvent.PointerProperties[] pointerPropertiesArray2 = new MotionEvent.PointerProperties[1];
        pointerPropertiesArray = pointerPropertiesArray2;
        pointerPropertiesArray2[0] = new MotionEvent.PointerProperties();
        pointerPropertiesArray[0].clear();
        pointerPropertiesArray[0].id = 0;
        return MotionEvent.obtain((long)this.time, (long)this.time, (int)2, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)(65530 + this.playerOrder), (int)0, (int)0x1000010, (int)0);
    }

    public int describeContents() {
        return 1033;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.playerOrder);
        parcel.writeInt(this.action);
        parcel.writeInt(this.ep ? 1 : 0);
        parcel.writeLong(this.time);
        if (this.eo == null) {
            this.eo = new int[6];
        }
        parcel.writeInt(this.eo[0]);
        parcel.writeInt(this.eo[1]);
        parcel.writeInt(this.eo[2]);
        parcel.writeInt(this.eo[3]);
        parcel.writeInt(this.eo[4]);
        parcel.writeInt(this.eo[5]);
        parcel.writeInt(this.eq ? 1 : 0);
        parcel.writeInt(this.er ? 1 : 0);
    }

    public String toString() {
        return "StickEvent [axisValue= X:" + this.getAxisValue(0) + " Y: " + this.getAxisValue(1) + " Z: " + this.getAxisValue(2) + " RZ: " + this.getAxisValue(3) + " HAT_X: " + this.getAxisValue(4) + " HAT_Y: " + this.getAxisValue(5) + ", time=" + this.time + ", eventTime: " + this.bc + ", delay: " + (this.bc - this.time) + "ms, action=" + this.action + ", playerOrder=" + this.playerOrder + ", isLeftChanged=" + this.eq + ", isRightChanged=" + this.er + "]";
    }

    public boolean isHatStickEvent() {
        int[] nArray = this.eo;
        return (double)this.eo[4] < -1.0E-6 && (double)nArray[4] > 1.0E-6 || (double)nArray[5] < -1.0E-6 && (double)nArray[5] > 1.0E-6;
    }

    public boolean isOriginPos() {
        int n = 0;
        while (n < this.eo.length) {
            if (this.eo[n] != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void setLeftStickState(boolean bl) {
        this.eq = bl;
    }

    public void setRightStickState(boolean bl) {
        this.er = bl;
    }

    public boolean hasLeftStickChanged() {
        return this.eq;
    }

    public boolean hasRightStickChanged() {
        return this.er;
    }

    public void processData(boolean[] blArray) {
        int n = 0;
        while (n < 4) {
            int n2 = this.eo[n];
            if (n2 > 210) {
                if (blArray[n] || n2 >= 250) {
                    this.eo[n] = 256;
                } else {
                    blArray[n] = true;
                }
            } else if (n2 < 135) {
                blArray[n] = false;
            }
            ++n;
        }
    }

    public void transXYMode() {
        this.eo[0] = this.eo[4];
        this.eo[1] = this.eo[5];
        this.eo[4] = 128;
        this.eo[5] = 128;
    }
}

