/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import java.math.BigDecimal;

public class GyroEvent
implements Parcelable {
    private long time;
    private int playerOrder;
    private int dE;
    private int dF;
    private int dG;
    public static final int MAX_VALUE = 65536;
    public static final int GYRO_AXIS_X = 0;
    public static final int GYRO_AXIS_Y = 1;
    public static final int GYRO_AXIS_Z = 2;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new GyroEvent(parcel);
        }
    };

    public GyroEvent() {
    }

    public GyroEvent(GyroEvent gyroEvent) {
        this.time = gyroEvent.time;
        this.playerOrder = gyroEvent.playerOrder;
        this.dE = gyroEvent.dE;
        this.dF = gyroEvent.dF;
        this.dG = gyroEvent.dG;
    }

    public GyroEvent(Parcel parcel) {
        this.time = parcel.readLong();
        this.playerOrder = parcel.readInt();
        this.dE = parcel.readInt();
        this.dF = parcel.readInt();
        this.dG = parcel.readInt();
    }

    public void setAxisValue(int[] nArray) {
        if (nArray == null || nArray.length < 3) {
            return;
        }
        this.dE = nArray[0];
        this.dF = nArray[1];
        this.dG = nArray[2];
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    public void setPlayerOrder(int n) {
        this.playerOrder = n;
    }

    public static GyroEvent getDefaultGyroEvent(int n) {
        GyroEvent gyroEvent = new GyroEvent();
        new GyroEvent().dE = 32768;
        gyroEvent.dF = 32768;
        gyroEvent.dG = 32768;
        gyroEvent.playerOrder = n;
        gyroEvent.time = SystemClock.uptimeMillis();
        return gyroEvent;
    }

    public GyroEvent(byte[] byArray, int n) {
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        int n4 = byArray[2] & 0xFF;
        int n5 = byArray[3] & 0xFF;
        int n6 = byArray[4] & 0xFF;
        int n7 = byArray[5] & 0xFF;
        this.dE = (n2 << 8) + n3;
        this.dF = (n4 << 8) + n5;
        this.dG = (n6 << 8) + n7;
        if (this.dE >= 32768) {
            this.dE -= 65536;
        }
        if (this.dF >= 32768) {
            this.dF -= 65536;
        }
        if (this.dG >= 32768) {
            this.dG -= 65536;
        }
        this.playerOrder = n;
        this.time = SystemClock.uptimeMillis();
    }

    public boolean isEquals(GyroEvent gyroEvent) {
        if (this.playerOrder != gyroEvent.getPlayerOrder()) {
            return false;
        }
        return Math.abs(this.dE - gyroEvent.dE) < 655 && Math.abs(this.dF - gyroEvent.dF) < 655 && Math.abs(this.dG - gyroEvent.dG) < 655;
    }

    public long getTime() {
        return this.time;
    }

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public static double getFormatData(double d2) {
        double d3;
        d2 = new BigDecimal(d2).setScale(3, 4).doubleValue();
        if (Math.abs(d3) < 0.02) {
            d2 = 0.0;
        }
        return d2;
    }

    public double getGyroValue(int n) {
        switch (n) {
            case 0: {
                return GyroEvent.getFormatData((float)this.dE / 32768.0f);
            }
            case 1: {
                return GyroEvent.getFormatData((float)this.dF / 32768.0f);
            }
            case 2: {
                return GyroEvent.getFormatData((float)this.dG / 32768.0f);
            }
        }
        return 0.0;
    }

    public String toString() {
        return "GyroEvent [time=" + this.time + ", playerOrder=" + this.playerOrder + ", gyroX=" + this.getGyroValue(0) + ", gyroY=" + this.getGyroValue(1) + ", gyroZ=" + this.getGyroValue(2) + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.time);
        parcel.writeInt(this.playerOrder);
        parcel.writeInt(this.dE);
        parcel.writeInt(this.dF);
        parcel.writeInt(this.dG);
    }
}

