/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.KeyEvent;

public class ControllerKeyEvent
implements Parcelable {
    public static final int KEYCODE_UP = 19;
    public static final int KEYCODE_DOWN = 20;
    public static final int KEYCODE_LEFT = 21;
    public static final int KEYCODE_RIGHT = 22;
    public static final int KEYCODE_UP_LEFT = 125;
    public static final int KEYCODE_UP_RIGHT = 126;
    public static final int KEYCODE_DOWN_LEFT = 127;
    public static final int KEYCODE_DOWN_RIGHT = 128;
    public static final int KEYCODE_BUTTON_Y = 96;
    public static final int KEYCODE_BUTTON_B = 97;
    public static final int KEYCODE_BUTTON_X = 98;
    public static final int KEYCODE_BUTTON_A = 99;
    public static final int KEYCODE_BUTTON_L1 = 102;
    public static final int KEYCODE_BUTTON_R1 = 103;
    public static final int KEYCODE_BUTTON_L2 = 104;
    public static final int KEYCODE_BUTTON_R2 = 105;
    public static final int KEYCODE_BUTTON_THUMBL = 106;
    public static final int KEYCODE_BUTTON_THUMBR = 107;
    public static final int KEYCODE_BUTTON_START = 108;
    public static final int KEYCODE_BUTTON_SELECT = 109;
    public static final int KEYCODE_BUTTON_HOME = 3;
    public static final int KEYCODE_BUTTON_VOL_DOWN = 25;
    public static final int KEYCODE_BUTTON_VOL_UP = 24;
    public static final int KEYCODE_BUTTON_ENTER = 23;
    public static final int KEYCODE_BUTTON_BACK = 4;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int STATE_CONNING = 0;
    public static final int STATE_CONN = 1;
    public static final int STATE_DISCONNING = 2;
    public static final int STATE_DISCONN = 3;
    public static int[] SystemKeys = new int[]{3, 23, 4, 25, 24};
    public static int[] GameKeys = new int[]{99, 97, 102, 105, 103, 104, 109, 108, 98, 96, 20, 21, 22, 19};
    private int action;
    private int keycode;
    private int playerOrder;
    private long time;
    private long bc;
    private boolean isExternal = false;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new ControllerKeyEvent(parcel);
        }
    };

    public ControllerKeyEvent() {
    }

    public ControllerKeyEvent(int n, int n2, int n3) {
        this.action = n;
        this.keycode = n2;
        this.playerOrder = n3;
        this.time = SystemClock.uptimeMillis();
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int n) {
        this.action = n;
    }

    public int getKeyCode() {
        return this.keycode;
    }

    public void setKeyCode(int n) {
        this.keycode = n;
    }

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public void setPlayerOrder(int n) {
        this.playerOrder = n;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    public KeyEvent getKeyEvent() {
        return new KeyEvent(this.time, SystemClock.uptimeMillis(), this.action, this.keycode, 0, 0, 65535, 0, 2);
    }

    public KeyEvent getKeyEvent(int n, int n2, int n3) {
        return new KeyEvent(this.time, SystemClock.uptimeMillis(), this.action, this.keycode, 0, n, n2, n3, 2);
    }

    public KeyEvent getJoystickKeyEvent(int n, int n2) {
        if (n <= 0) {
            n = this.keycode;
        }
        return new KeyEvent(this.time, this.time, this.action, n, 0, 0, 65535, n2, 8);
    }

    public KeyEvent getKeyEvent(int n, int n2) {
        if (n <= 0 || n > 255) {
            n = this.keycode;
        }
        return new KeyEvent(this.time, SystemClock.uptimeMillis(), this.action, n, 0, 0, 65535, n2, 2);
    }

    public static String getInputStr(KeyEvent keyEvent) {
        return String.valueOf(keyEvent.getAction()) + " " + keyEvent.getKeyCode();
    }

    public static KeyEvent getKeyEvent2(int n, int n2) {
        if (n2 < 0 || n2 > 255) {
            return null;
        }
        long l2 = SystemClock.uptimeMillis();
        return new KeyEvent(l2, SystemClock.uptimeMillis(), n, n2, 0, 0, 65535, 0, 8);
    }

    public void setExternal(boolean bl) {
        this.isExternal = bl;
    }

    public ControllerKeyEvent(Parcel parcel) {
        this.action = parcel.readInt();
        this.keycode = parcel.readInt();
        this.playerOrder = parcel.readInt();
        this.time = parcel.readLong();
        this.isExternal = parcel.readInt() == 1;
    }

    public ControllerKeyEvent(ControllerKeyEvent controllerKeyEvent) {
        this.keycode = controllerKeyEvent.keycode;
        this.action = controllerKeyEvent.action;
        this.playerOrder = controllerKeyEvent.playerOrder;
        this.time = controllerKeyEvent.time;
        this.isExternal = controllerKeyEvent.isExternal;
    }

    public ControllerKeyEvent(int n, KeyEvent keyEvent, int n2) {
        this.action = keyEvent.getAction();
        this.keycode = n2 > 0 ? n2 : keyEvent.getKeyCode();
        this.playerOrder = n;
        this.time = keyEvent.getDownTime();
    }

    public long getEventTime() {
        return this.bc;
    }

    public void setEventTime(long l2) {
        this.bc = l2;
    }

    public int describeContents() {
        return 1032;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.action);
        parcel.writeInt(this.keycode);
        parcel.writeInt(this.playerOrder);
        parcel.writeLong(this.time);
        parcel.writeInt(this.isExternal ? 1 : 0);
    }

    public String toString() {
        return "ControllerKeyEvent [" + this.descriptionKey() + " action=" + this.action + ", keycode=" + this.keycode + ", playerOrder=" + this.playerOrder + ", time=" + this.time + ", evenTime=" + this.bc + ", delay: " + (this.bc - this.time) + "ms ]";
    }

    public String descriptionKey() {
        return ControllerKeyEvent.descriptionKey(this.keycode);
    }

    public boolean isValidKeyEvent(ControllerKeyEvent controllerKeyEvent) {
        if (controllerKeyEvent.getAction() != this.action) {
            return true;
        }
        if (this.keycode != controllerKeyEvent.getKeyCode()) {
            return true;
        }
        return Math.abs(this.time - controllerKeyEvent.getTime()) > 300L;
    }

    public int hashCode() {
        int n = 31 + this.action;
        n = n * 31 + this.keycode;
        n = n * 31 + this.playerOrder;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (ControllerKeyEvent)object;
        if (this.action != ((ControllerKeyEvent)object).action) {
            return false;
        }
        if (this.keycode != ((ControllerKeyEvent)object).keycode) {
            return false;
        }
        return this.playerOrder == ((ControllerKeyEvent)object).playerOrder;
    }

    public static boolean isControllerSupportKeyCode(int n) {
        switch (n) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemKeyCode(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 82: 
            case 111: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemExKeyCode(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 24: 
            case 25: 
            case 26: 
            case 111: 
            case 164: 
            case 187: {
                return true;
            }
        }
        return false;
    }

    public static String descriptionKey(int n) {
        switch (n) {
            case 99: {
                return "KEYCODE_BUTTON_A";
            }
            case 97: {
                return "KEYCODE_BUTTON_B";
            }
            case 98: {
                return "KEYCODE_BUTTON_X";
            }
            case 96: {
                return "KEYCODE_BUTTON_Y";
            }
            case 102: {
                return "KEYCODE_BUTTON_L1";
            }
            case 104: {
                return "KEYCODE_BUTTON_L2";
            }
            case 103: {
                return "KEYCODE_BUTTON_R1";
            }
            case 105: {
                return "KEYCODE_BUTTON_R2";
            }
            case 21: {
                return "KEYCODE_LEFT";
            }
            case 22: {
                return "KEYCODE_RIGHT";
            }
            case 19: {
                return "KEYCODE_UP";
            }
            case 20: {
                return "KEYCODE_DOWN";
            }
            case 125: {
                return "KEYCODE_UP_LEFT";
            }
            case 126: {
                return "KEYCODE_UP_RIGHT";
            }
            case 127: {
                return "KEYCODE_DOWN_LEFT";
            }
            case 128: {
                return "KEYCODE_DOWN_RIGHT";
            }
            case 109: {
                return "KEYCODE_BUTTON_SELECT";
            }
            case 108: {
                return "KEYCODE_BUTTON_START";
            }
            case 3: {
                return "KEYCODE_BUTTON_HOME";
            }
            case 23: {
                return "KEYCODE_BUTTON_ENTER";
            }
            case 4: {
                return "KEYCODE_BUTTON_BACK";
            }
        }
        return "UNKNOWN BUTTON";
    }

    public boolean isArrow() {
        return this.keycode >= 19 && this.keycode <= 22;
    }
}

