/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import com.nibiru.lib.BTDevice;

public class ControllerDevice
implements Parcelable {
    private int playerOrder;
    private int state;
    private int ba;
    private boolean isExternal;
    private int deviceId;
    private int features;
    private String bb = "0:0:0:0:0";
    private String deviceName = "NO DEVICE";
    private boolean isSupportAcc = false;
    private boolean isSupportGyro = false;
    public static final int STATE_CONNING = 0;
    public static final int STATE_CONN = 1;
    public static final int STATE_DISCONNING = 2;
    public static final int STATE_DISCONN = 3;
    public static final int POS_LEFT = 0;
    public static final int POS_RIGHT = 1;
    public static final int DUR_INFINITE = 0;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new ControllerDevice(parcel);
        }
    };

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public void setPlayerOrder(int n) {
        this.playerOrder = n;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public boolean isConnected() {
        return this.state == 1;
    }

    public int getDriverType() {
        return this.ba;
    }

    public void setDriverType(int n) {
        this.ba = n;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean bl) {
        this.isExternal = bl;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int n) {
        this.deviceId = n;
    }

    public String getAddress() {
        return this.bb;
    }

    public void setAddress(String string) {
        this.bb = string;
    }

    public int getFeatures() {
        return this.features;
    }

    public void setFeatures(int n) {
        this.features = n;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public boolean isSupportAcc() {
        return this.isSupportAcc;
    }

    public void setSupportAcc(boolean bl) {
        this.isSupportAcc = bl;
    }

    public boolean isSupportGyro() {
        return this.isSupportGyro;
    }

    public void setSupportGyro(boolean bl) {
        this.isSupportGyro = bl;
    }

    public ControllerDevice(BTDevice bTDevice) {
        if (bTDevice == null) {
            return;
        }
        this.deviceId = bTDevice.getDeviceId();
        this.bb = bTDevice.getDeviceAddr();
        this.ba = bTDevice.getDeviceType();
        this.state = bTDevice.getState();
        this.playerOrder = bTDevice.getPlayerOrder();
        this.isExternal = bTDevice.isExternal();
        this.features = bTDevice.getFeatures();
        this.deviceName = bTDevice.getDeviceName();
        this.isSupportAcc = bTDevice.isSupportAcc();
        this.isSupportGyro = bTDevice.isSupportGyro();
    }

    public int describeContents() {
        return 5200;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.deviceId);
        parcel.writeInt(this.ba);
        parcel.writeInt(this.playerOrder);
        parcel.writeInt(this.state);
        parcel.writeInt(this.isExternal ? 1 : 0);
        parcel.writeString(this.bb);
        parcel.writeInt(this.features);
        parcel.writeString(this.deviceName);
        parcel.writeInt(this.isSupportAcc ? 1 : 0);
        parcel.writeInt(this.isSupportGyro ? 1 : 0);
    }

    public ControllerDevice(Parcel parcel) {
        this.deviceId = parcel.readInt();
        this.ba = parcel.readInt();
        this.playerOrder = parcel.readInt();
        this.state = parcel.readInt();
        this.isExternal = parcel.readInt() == 1;
        this.bb = parcel.readString();
        this.features = parcel.readInt();
        this.deviceName = parcel.readString();
        this.isSupportAcc = parcel.readInt() == 1;
        this.isSupportGyro = parcel.readInt() == 1;
    }

    public BTDevice getBTDevice() {
        BTDevice bTDevice = new BTDevice();
        bTDevice.setDeviceAddr(this.bb);
        bTDevice.setDeviceName(this.deviceName);
        bTDevice.setDeviceType(this.ba);
        return bTDevice;
    }

    public String toString() {
        return "ControllerDevice [playerOrder=" + this.playerOrder + ", state=" + this.state + ", driverType=" + this.ba + ", isExternal=" + this.isExternal + ", deviceId=" + this.deviceId + ", feature=" + this.features + ", address=" + this.bb + ", deviceName=" + this.deviceName + ", isSupportAcc=" + this.isSupportAcc + ", isSupportGyro=" + this.isSupportGyro + "]";
    }
}

