/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.nibiru.lib.controller.AccEvent;
import com.nibiru.lib.controller.CombKeyService;
import com.nibiru.lib.controller.ContinuesKeyService;
import com.nibiru.lib.controller.Controller;
import com.nibiru.lib.controller.ControllerDevice;
import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.ControllerService;
import com.nibiru.lib.controller.ControllerServiceException;
import com.nibiru.lib.controller.CursorService;
import com.nibiru.lib.controller.DpadService;
import com.nibiru.lib.controller.GyroEvent;
import com.nibiru.lib.controller.MotionSenseEvent;
import com.nibiru.lib.controller.OnAccListener;
import com.nibiru.lib.controller.OnGyroListener;
import com.nibiru.lib.controller.OnKeyListener;
import com.nibiru.lib.controller.OnMotionSenseListener;
import com.nibiru.lib.controller.OnSimpleStickListener;
import com.nibiru.lib.controller.OnStateListener;
import com.nibiru.lib.controller.OnStickListener;
import com.nibiru.lib.controller.StickEvent;
import com.nibiru.lib.controller.StickSimService;

public class ControllerActivity
extends Activity
implements CombKeyService.OnCombKeyListener,
ControllerService.OnControllerSeviceListener,
OnAccListener,
OnGyroListener,
OnKeyListener,
OnMotionSenseListener,
OnSimpleStickListener,
OnStateListener,
OnStickListener {
    protected ControllerService mControllerService;
    protected CombKeyService mCombKeyService;
    protected StickSimService mStickSimService;
    protected ContinuesKeyService mContinuesKeyService;
    protected CursorService mCursorService;
    protected DpadService mDpadService;
    private boolean aY = true;
    private boolean aZ = false;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mControllerService = Controller.getControllerService();
        this.mCombKeyService = this.mControllerService.getCombKeyService();
        this.mStickSimService = this.mControllerService.getStickSimService();
        this.mContinuesKeyService = this.mControllerService.getContinusKeyService();
        this.mCursorService = this.mControllerService.getCursorService();
        this.mDpadService = this.mControllerService.getDpadService();
        this.mControllerService.setHandler(new Handler());
        if (this.mControllerService.checkNibiruInstall((Context)this, false)) {
            this.initNibiruService();
        }
    }

    protected void initNibiruService() {
        this.mControllerService.setKeyListener(this);
        this.mControllerService.setStickListener(this);
        this.mControllerService.setSimpleStickListener(this);
        this.mControllerService.setStateListener(this);
        this.mControllerService.setControllerServiceListener(this);
        this.mControllerService.setAccListener(this);
        this.mControllerService.setGyroListener(this);
        this.mControllerService.setMotionSenseListener(this);
        this.mCombKeyService.setCombKeyListener(this);
        try {
            this.mControllerService.register((Context)this);
            return;
        }
        catch (ControllerServiceException controllerServiceException) {
            ControllerServiceException controllerServiceException2 = controllerServiceException;
            controllerServiceException.printStackTrace();
            return;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mControllerService != null) {
            this.mControllerService.unregister();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(false);
        }
        if (this.aY) {
            this.getWindow().clearFlags(128);
        }
    }

    public void startCursorMode(int n) {
        this.getCursorSerivce().createCursor(n);
    }

    protected void onResume() {
        super.onResume();
        if (this.mControllerService != null && !this.mControllerService.isServiceEnable()) {
            this.initNibiruService();
        }
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(true);
        }
        if (this.aY) {
            this.getWindow().setFlags(128, 128);
        }
    }

    protected void setScreenOnMode(boolean bl) {
        if (bl) {
            this.getWindow().clearFlags(128);
            this.getWindow().setFlags(128, 128);
        } else {
            this.getWindow().clearFlags(128);
        }
        this.aY = bl;
    }

    @Override
    public void onControllerStateChanged(int n, int n2, ControllerDevice controllerDevice) {
    }

    @Override
    public void onBluetoothStateChanged(int n) {
    }

    @Override
    public void onControllerStickEvent(int n, StickEvent stickEvent) {
    }

    @Override
    public void onControllerKeyDown(int n, int n2, ControllerKeyEvent controllerKeyEvent) {
    }

    @Override
    public void onControllerKeyUp(int n, int n2, ControllerKeyEvent controllerKeyEvent) {
    }

    public boolean isControllerServiceEnable() {
        return this.aZ;
    }

    public ControllerService getControllerService() {
        return this.mControllerService;
    }

    public CombKeyService getCombKeyService() {
        return this.mCombKeyService;
    }

    public StickSimService getStickSimService() {
        return this.mStickSimService;
    }

    public ContinuesKeyService getContinuesKeyService() {
        return this.mContinuesKeyService;
    }

    public CursorService getCursorSerivce() {
        return this.mCursorService;
    }

    public DpadService getDpadService() {
        return this.mDpadService;
    }

    @Override
    public void onCombKeyEventStart(String string, int n, CombKeyService.CombKey combKey) {
    }

    @Override
    public void onCombKeyEventOver(String string, int n, CombKeyService.CombKey combKey) {
    }

    @Override
    public void onControllerServiceReady(boolean bl) {
        this.aZ = bl;
    }

    @Override
    public void onControllerGyroEvent(int n, GyroEvent gyroEvent) {
    }

    @Override
    public void onControllerAccEvent(int n, AccEvent accEvent) {
    }

    @Override
    public void onLeftStickChanged(int n, float f2, float f3) {
    }

    @Override
    public void onRightStickChanged(int n, float f2, float f3) {
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)keyEvent)) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)motionEvent)) {
            return true;
        }
        return super.dispatchGenericMotionEvent(motionEvent);
    }

    @Override
    public void onMotionSenseChanged(int n, MotionSenseEvent motionSenseEvent) {
    }
}

