/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import java.math.BigDecimal;

public class AccEvent
implements Parcelable {
    private long time;
    private int playerOrder;
    private int aA;
    private int aB;
    private int aC;
    public static final int MAX_VALUE = 65536;
    public static final int ACC_AXIS_X = 0;
    public static final int ACC_AXIS_Y = 1;
    public static final int ACC_AXIS_Z = 2;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new AccEvent(parcel);
        }
    };

    public AccEvent() {
    }

    public AccEvent(AccEvent accEvent) {
        this.time = accEvent.time;
        this.playerOrder = accEvent.playerOrder;
        this.aA = accEvent.aA;
        this.aB = accEvent.aB;
        this.aC = accEvent.aC;
    }

    public AccEvent(Parcel parcel) {
        this.time = parcel.readLong();
        this.playerOrder = parcel.readInt();
        this.aA = parcel.readInt();
        this.aB = parcel.readInt();
        this.aC = parcel.readInt();
    }

    public static AccEvent getDefaultAccEvent(int n) {
        AccEvent accEvent = new AccEvent();
        new AccEvent().aA = 32768;
        accEvent.aB = 32768;
        accEvent.aC = 32768;
        accEvent.playerOrder = n;
        accEvent.time = SystemClock.uptimeMillis();
        return accEvent;
    }

    public void setAxisValue(int[] nArray) {
        if (nArray == null || nArray.length < 3) {
            return;
        }
        this.aA = nArray[0];
        this.aB = nArray[1];
        this.aC = nArray[2];
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    public void setPlayerOrder(int n) {
        this.playerOrder = n;
    }

    public AccEvent(byte[] byArray, int n) {
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        int n4 = byArray[2] & 0xFF;
        int n5 = byArray[3] & 0xFF;
        int n6 = byArray[4] & 0xFF;
        int n7 = byArray[5] & 0xFF;
        this.aA = (n2 << 8) + n3;
        this.aB = (n4 << 8) + n5;
        this.aC = (n6 << 8) + n7;
        if (this.aA >= 32768) {
            this.aA -= 65536;
        }
        if (this.aB >= 32768) {
            this.aB -= 65536;
        }
        if (this.aC >= 32768) {
            this.aC -= 65536;
        }
        this.playerOrder = n;
        this.time = SystemClock.uptimeMillis();
    }

    public boolean isEquals(AccEvent accEvent) {
        if (this.playerOrder != accEvent.getPlayerOrder()) {
            return false;
        }
        return Math.abs(this.aA - accEvent.aA) < 655 && Math.abs(this.aB - accEvent.aB) < 655 && Math.abs(this.aC - accEvent.aC) < 655;
    }

    public long getTime() {
        return this.time;
    }

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public static double getFormatData(double d2, boolean bl) {
        d2 = new BigDecimal(d2).setScale(3, 4).doubleValue();
        if (bl) {
            if (Math.abs(d2 - 0.5) < 0.02) {
                d2 = 0.5;
            }
        } else if (Math.abs(d2) < 0.02) {
            d2 = 0.0;
        }
        return d2;
    }

    public double getAccValue(int n) {
        switch (n) {
            case 0: {
                return AccEvent.getFormatData((float)this.aA / 32768.0f, false);
            }
            case 1: {
                return AccEvent.getFormatData((float)this.aB / 32768.0f, false);
            }
            case 2: {
                return AccEvent.getFormatData((float)this.aC / 32768.0f, true);
            }
        }
        return 0.0;
    }

    public String toString() {
        return "AccEvent [time=" + this.time + ", playerOrder=" + this.playerOrder + ", accX=" + this.getAccValue(0) + ", accY=" + this.getAccValue(1) + ", accZ=" + this.getAccValue(2) + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.time);
        parcel.writeInt(this.playerOrder);
        parcel.writeInt(this.aA);
        parcel.writeInt(this.aB);
        parcel.writeInt(this.aC);
    }
}

