/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.nibiru.lib.BTDevice;
import com.nibiru.lib.controller.GlobalLog;
import com.nibiru.lib.controller.StickEvent;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class BTUtil {
    public static final String LOG_DIR = "sdcard/nibiru/log/";
    public static final int MAX_LOG_COUNT = 0;
    public static final String SERVICE_NAME = "com.nibiru.service";
    public static final String SERVICE_MAINUI = "com.nibiru.mainui";
    public static final String SUPPORT_SERVICE_NAME = "com.nibiru.support.service";
    public static final String SERVICE_UI = "com.nibiru.view.devicelist";
    public static final String CHECK_PACKAGENAME = "com.nibiru";
    private static boolean isStart = false;
    private static boolean Q = false;
    private static boolean R = false;
    public static SimpleDateFormat mDateFormatLog = new SimpleDateFormat("MM_dd__HH_mm_ss", Locale.CHINA);

    public static int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static BTDevice[] parseBTDeviceList(String object) {
        if (object == null) {
            return null;
        }
        if ((object = object.split("#")) == null) {
            return null;
        }
        if (((String[])object).length == 0) {
            return new BTDevice[0];
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        String[] stringArray = object;
        int n = ((String[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            if (((String[])(object = object.split("\\|"))).length >= 6) {
                Serializable serializable;
                try {
                    serializable = new BTDevice();
                    ((BTDevice)serializable).setDeviceName(object[0]);
                    ((BTDevice)serializable).setDeviceAddr(object[1]);
                    ((BTDevice)serializable).setDeviceType(Integer.parseInt(object[2]));
                    ((BTDevice)serializable).setDeviceId(Integer.parseInt(object[3]));
                    ((BTDevice)serializable).setPlayerOrder(Integer.parseInt(object[4]));
                    ((BTDevice)serializable).setConnected(Boolean.parseBoolean(object[5]));
                    if (((String[])object).length > 6) {
                        ((BTDevice)serializable).setState(Integer.parseInt(object[6]));
                    }
                    arrayList.add(serializable);
                }
                catch (Exception exception) {
                    serializable = exception;
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        return arrayList.toArray(new BTDevice[arrayList.size()]);
    }

    public static BTDevice parseBTDevice(String object) {
        if (object == null) {
            return null;
        }
        if ((object = BTUtil.parseBTDeviceList((String)object)) != null && ((BTDevice[])object).length > 0) {
            object = object[0];
            return object;
        }
        return null;
    }

    public static String generateBTDeviceListCode(BTDevice[] object) {
        if (object == null) {
            return "";
        }
        String string = "";
        BTDevice[] bTDeviceArray = object;
        int n = ((BTDevice[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = bTDeviceArray[n2];
            string = String.valueOf(string) + BTUtil.generateBTDeviceCode((BTDevice)object);
            string = String.valueOf(string) + "#";
            ++n2;
        }
        return string;
    }

    public static KeyEvent parseKeyEvent(String stringArray, int[] nArray) {
        if (stringArray == null) {
            return null;
        }
        if ((stringArray = stringArray.split("\\|")).length >= 5) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                boolean bl = Boolean.parseBoolean(stringArray[3]);
                int n4 = Integer.parseInt(stringArray[4]);
                long l2 = SystemClock.uptimeMillis();
                if (nArray != null && n2 < nArray.length) {
                    n2 = nArray[n2];
                }
                return new KeyEvent(l2, l2, n, n2, bl ? 1 : 0, n3, n4, 0, 2);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static String generateBTDeviceCode(BTDevice bTDevice) {
        if (bTDevice == null) {
            return "";
        }
        String string = "";
        string = String.valueOf(string) + bTDevice.getDeviceName() + "|" + bTDevice.getDeviceAddr() + "|" + bTDevice.getDeviceType() + "|" + bTDevice.getDeviceId() + "|" + bTDevice.getPlayerOrder() + "|" + bTDevice.isConnected() + "|" + bTDevice.getState();
        return string;
    }

    public static String getApplicationSessionInfo(Context object) {
        try {
            object = object.getPackageManager().getPackageInfo(object.getPackageName(), 0);
            return object.packageName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = nameNotFoundException;
            nameNotFoundException.printStackTrace();
            return null;
        }
    }

    public static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static String getLogTimeDesc(long l2) {
        return mDateFormatLog.format(new Date(l2));
    }

    public static long getLongtime(String object) {
        try {
            return mDateFormatLog.parse((String)object).getTime();
        }
        catch (ParseException parseException) {
            object = parseException;
            parseException.printStackTrace();
            return 0L;
        }
    }

    public static MotionEvent generateMotionEvent(byte by, byte by2, byte by3, byte by4, int n) {
        long l2 = SystemClock.uptimeMillis();
        return MotionEvent.obtain((long)l2, (long)l2, (int)2, (float)(by & 0xFF), (float)(by2 & 0xFF), (float)0.0f, (float)1.0f, (int)0, (float)(by3 & 0xFF), (float)(by4 & 0xFF), (int)n, (int)0);
    }

    public static KeyEvent generateKeyEvent(int n, int n2, int n3) {
        long l2 = SystemClock.uptimeMillis();
        return new KeyEvent(l2, l2, n, n2, 0, 0, n3, 0, 0);
    }

    public static KeyEvent translateKey(KeyEvent keyEvent, int n) {
        return new KeyEvent(keyEvent.getEventTime(), keyEvent.getEventTime(), keyEvent.getAction(), n, keyEvent.getRepeatCount(), keyEvent.getMetaState(), keyEvent.getDeviceId(), 0, 2);
    }

    public static MotionEvent translateJoystick(MotionEvent motionEvent) {
        return BTUtil.translateJoystick(motionEvent.getX(), motionEvent.getY(), motionEvent.getXPrecision(), motionEvent.getYPrecision(), 0.0f, 0.0f, motionEvent.getDownTime());
    }

    public static MotionEvent translateJoystick(float f2, float f3, float f4, float f5, float f6, float f7, long l2) {
        if (BTUtil.getAndroidVersion() < 12) {
            return null;
        }
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[1];
        MotionEvent.PointerProperties[] pointerPropertiesArray2 = pointerPropertiesArray;
        pointerPropertiesArray[0] = new MotionEvent.PointerProperties();
        pointerPropertiesArray2[0].clear();
        pointerPropertiesArray2[0].id = 0;
        f3 = 128.0f - f3;
        f5 = 128.0f - f5;
        GlobalLog.e("LX: " + (f2 -= 128.0f) + " LY: " + f3 + " RX: " + (f4 -= 128.0f) + " RY:  " + f5);
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        pointerCoords.setAxisValue(0, f2);
        pointerCoords.setAxisValue(1, f3);
        pointerCoords.setAxisValue(11, f4);
        pointerCoords.setAxisValue(14, f5);
        pointerCoords.setAxisValue(15, f6);
        pointerCoords.setAxisValue(16, f7);
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerCoords[] pointerCoordsArray2 = pointerCoordsArray;
        pointerCoordsArray[0] = pointerCoords;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        if (BTUtil.getAndroidVersion() < 14) {
            return MotionEvent.obtain((long)l2, (long)l2, (int)2, (int)1, (int[])nArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (float)0.0f, (float)0.0f, (int)65535, (int)0, (int)0x1000010, (int)0);
        }
        return MotionEvent.obtain((long)l2, (long)l2, (int)2, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)65535, (int)0, (int)0x1000010, (int)0);
    }

    public static MotionEvent translateMouse(float f2, float f3, float f4, float f5, float f6, float f7, long l2) {
        if (BTUtil.getAndroidVersion() < 12) {
            return null;
        }
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[1];
        MotionEvent.PointerProperties[] pointerPropertiesArray2 = pointerPropertiesArray;
        pointerPropertiesArray[0] = new MotionEvent.PointerProperties();
        pointerPropertiesArray2[0].clear();
        pointerPropertiesArray2[0].id = 0;
        pointerPropertiesArray2[0].toolType = 3;
        f3 = 128.0f - f3;
        f5 = 128.0f - f5;
        GlobalLog.e("LX: " + (f2 -= 128.0f) + " LY: " + f3 + " RX: " + (f4 -= 128.0f) + " RY:  " + f5);
        Object object = new MotionEvent.PointerCoords();
        object.setAxisValue(0, f2 + 200.0f);
        object.setAxisValue(1, f3 + 400.0f);
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerCoords[] pointerCoordsArray2 = pointerCoordsArray;
        pointerCoordsArray[0] = object;
        pointerCoordsArray2[0].x = f2 + 200.0f;
        pointerCoordsArray2[0].y = f3 + 400.0f;
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = 0;
        if (BTUtil.getAndroidVersion() < 14) {
            return MotionEvent.obtain((long)l2, (long)l2, (int)2, (int)1, (int[])object, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (float)0.0f, (float)0.0f, (int)65535, (int)0, (int)8194, (int)0);
        }
        if (!isStart) {
            if ((int)f2 != 0 && (int)f3 != 0) {
                isStart = true;
                return MotionEvent.obtain((long)l2, (long)l2, (int)9, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)8194, (int)0);
            }
            return null;
        }
        if ((int)f2 != 0 || (int)f3 != 0) {
            isStart = true;
            return MotionEvent.obtain((long)l2, (long)l2, (int)7, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)8194, (int)0);
        }
        isStart = false;
        return MotionEvent.obtain((long)l2, (long)l2, (int)10, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)8194, (int)0);
    }

    public static MotionEvent[] translateTouch(float f2, float f3, float f4, float f5, long l2) {
        if (BTUtil.getAndroidVersion() < 12) {
            return null;
        }
        ArrayList<MotionEvent> arrayList = new ArrayList<MotionEvent>();
        MotionEvent motionEvent = BTUtil.translateTouch(0, f2, f3, l2);
        if (motionEvent != null) {
            arrayList.add(motionEvent);
        }
        if ((motionEvent = BTUtil.translateTouch(1, f4, f5, l2)) != null) {
            arrayList.add(motionEvent);
        }
        return arrayList.toArray(new MotionEvent[arrayList.size()]);
    }

    public static MotionEvent translateTouch(int n, float f2, float f3, long l2) {
        if (BTUtil.getAndroidVersion() < 12) {
            return null;
        }
        MotionEvent.PointerProperties[] pointerPropertiesArray = new MotionEvent.PointerProperties[1];
        MotionEvent.PointerProperties[] pointerPropertiesArray2 = pointerPropertiesArray;
        pointerPropertiesArray[0] = new MotionEvent.PointerProperties();
        pointerPropertiesArray2[0].clear();
        pointerPropertiesArray2[0].id = 0;
        pointerPropertiesArray2[0].toolType = 1;
        int n2 = (int)(f2 - 128.0f);
        int n3 = (int)(128.0f - f3);
        if (n == 0) {
            f2 = (f2 - 128.0f) * 2.0f + 300.0f;
            f3 = (128.0f - f3) * 2.0f + 500.0f;
        } else {
            f2 = (f2 - 128.0f) * 2.0f + 900.0f;
            f3 = (128.0f - f3) * 2.0f + 500.0f;
        }
        MotionEvent.PointerCoords pointerCoords = new MotionEvent.PointerCoords();
        MotionEvent.PointerCoords[] pointerCoordsArray = new MotionEvent.PointerCoords[1];
        MotionEvent.PointerCoords[] pointerCoordsArray2 = pointerCoordsArray;
        pointerCoordsArray[0] = pointerCoords;
        pointerCoordsArray2[0].x = f2;
        pointerCoordsArray2[0].y = f3;
        pointerCoordsArray2[0].pressure = 0.66f;
        pointerCoordsArray2[0].size = 0.5f;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        if (BTUtil.getAndroidVersion() < 14) {
            return MotionEvent.obtain((long)l2, (long)l2, (int)2, (int)1, (int[])nArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (float)0.0f, (float)0.0f, (int)65535, (int)0, (int)4098, (int)0);
        }
        if (n == 0) {
            if (!Q) {
                if (n2 != 0 || n3 != 0) {
                    Q = true;
                    GlobalLog.e("DOWN LX: " + pointerCoordsArray2[0].x + " LY: " + pointerCoordsArray2[0].y);
                    return MotionEvent.obtain((long)l2, (long)l2, (int)0, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)4098, (int)0);
                }
                GlobalLog.e("NULL LX: " + pointerCoordsArray2[0].x + " LY: " + pointerCoordsArray2[0].y);
                return null;
            }
            if (n2 != 0 || n3 != 0) {
                Q = true;
                GlobalLog.e("MOVE LX: " + pointerCoordsArray2[0].x + " LY: " + pointerCoordsArray2[0].y);
                return MotionEvent.obtain((long)l2, (long)l2, (int)2, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)4098, (int)0);
            }
            GlobalLog.e("UP LX: " + pointerCoordsArray2[0].x + " LY: " + pointerCoordsArray2[0].y);
            Q = false;
            return MotionEvent.obtain((long)l2, (long)l2, (int)1, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)4098, (int)0);
        }
        if (!R) {
            if (n2 != 0 || n3 != 0) {
                R = true;
                GlobalLog.e("DOWN LX: " + pointerCoordsArray2[0].x + " LY: " + pointerCoordsArray2[0].y);
                return MotionEvent.obtain((long)l2, (long)l2, (int)0, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)4098, (int)0);
            }
            GlobalLog.e("NULL LX: " + pointerCoordsArray2[0].x + " LY: " + pointerCoordsArray2[0].y);
            return null;
        }
        if (n2 != 0 || n3 != 0) {
            R = true;
            GlobalLog.e("MOVE LX: " + pointerCoordsArray2[0].x + " LY: " + pointerCoordsArray2[0].y);
            return MotionEvent.obtain((long)l2, (long)l2, (int)2, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)4098, (int)0);
        }
        GlobalLog.e("UP LX: " + pointerCoordsArray2[0].x + " LY: " + pointerCoordsArray2[0].y);
        R = false;
        return MotionEvent.obtain((long)l2, (long)l2, (int)1, (int)1, (MotionEvent.PointerProperties[])pointerPropertiesArray2, (MotionEvent.PointerCoords[])pointerCoordsArray2, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)0, (int)4098, (int)0);
    }

    public static MotionEvent getMotionEvent(StickEvent stickEvent) {
        int[] nArray = stickEvent.getAxisValue();
        return MotionEvent.obtain((long)stickEvent.getTime(), (long)stickEvent.getTime(), (int)2, (float)nArray[0], (float)nArray[1], (float)0.0f, (float)1.0f, (int)0, (float)nArray[2], (float)nArray[3], (int)stickEvent.getPlayerOrder(), (int)0);
    }

    public static final String md5(String object) {
        if (object == null) {
            return null;
        }
        try {
            Object object2 = MessageDigest.getInstance("MD5");
            ((MessageDigest)object2).update(((String)object).getBytes());
            object = ((MessageDigest)object2).digest();
            object2 = new StringBuffer();
            int n = 0;
            while (n < ((Object)object).length) {
                String string = Integer.toHexString(0xFF & object[n]);
                while (string.length() < 2) {
                    string = "0" + string;
                }
                ((StringBuffer)object2).append(string);
                ++n;
            }
            return ((StringBuffer)object2).toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            NoSuchAlgorithmException noSuchAlgorithmException2 = noSuchAlgorithmException;
            noSuchAlgorithmException.printStackTrace();
            return "-1";
        }
    }
}

