/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.InputDevice;
import com.nibiru.lib.c;
import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.StickEvent;
import java.io.Serializable;

public class BTDevice
implements Parcelable,
Serializable {
    protected static final long serialVersionUID = 4473651087026692626L;
    protected String deviceName = "No Device";
    protected int deviceId = -1;
    protected int deviceType = -1;
    protected int playerOrder = 0;
    protected String deviceAddr = "0:0:0:0:0:0";
    protected boolean isConnected = false;
    protected long connectTime = 0L;
    protected int state = 3;
    protected boolean isExternal = false;
    protected int features = 0;
    protected boolean isSupportAcc = false;
    protected boolean isSupportGyro = false;
    protected StickEvent lastStickEvent = null;
    protected ControllerKeyEvent lastKeyEvent = null;
    protected c mDeviceInfo;
    public static final int STATE_CONNING = 0;
    public static final int STATE_CONN = 1;
    public static final int STATE_DISCONNING = 2;
    public static final int STATE_DISCONN = 3;
    public static final int STATE_STOP = 4;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new BTDevice(parcel);
        }
    };

    public BTDevice(BluetoothDevice bluetoothDevice) {
        this.deviceAddr = bluetoothDevice.getAddress();
        this.deviceName = bluetoothDevice.getName();
        if (this.deviceName == null || this.deviceName.length() == 0) {
            this.deviceName = "Unknown Device";
        }
        this.state = 3;
    }

    public c getDeviceInfo() {
        return this.mDeviceInfo;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean bl) {
        this.isExternal = bl;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int n) {
        this.deviceId = n;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int n) {
        this.deviceType = n;
    }

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public void setPlayerOrder(int n) {
        this.playerOrder = n;
    }

    public String getDeviceAddr() {
        return this.deviceAddr;
    }

    public void setDeviceAddr(String string) {
        this.deviceAddr = string;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    public int getFeatures() {
        return this.features;
    }

    public boolean isSupportAcc() {
        return this.isSupportAcc;
    }

    public void setSupportAcc(boolean bl) {
        this.isSupportAcc = bl;
        if (bl) {
            this.features |= 1;
            return;
        }
        this.features &= 0xFFFFFFFE;
    }

    public boolean isSupportGyro() {
        return this.isSupportGyro;
    }

    public void setSupportGyro(boolean bl) {
        this.isSupportGyro = bl;
        if (this.isSupportAcc) {
            this.features |= 2;
            return;
        }
        this.features &= 0xFFFFFFFD;
    }

    public void addFeatures(int n) {
        this.features |= n;
    }

    public void removeFeatures(int n) {
        this.features &= ~n;
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public StickEvent getLastStickEvent() {
        return this.lastStickEvent;
    }

    public void setLastStickEvent(StickEvent stickEvent) {
        this.lastStickEvent = stickEvent;
    }

    public ControllerKeyEvent getLastKeyEvent() {
        return this.lastKeyEvent;
    }

    public void setLastKeyEvent(ControllerKeyEvent controllerKeyEvent) {
        this.lastKeyEvent = controllerKeyEvent;
    }

    public String toString() {
        return "BTDevice [deviceName=" + this.deviceName + ", deviceId=" + this.deviceId + ", deviceType=" + this.deviceType + ", playerOrder=" + this.playerOrder + ", deviceAddr=" + this.deviceAddr + ", isConnected=" + this.isConnected + ", connectTime=" + this.connectTime + ", state=" + this.state + ", isExternal=" + this.isExternal + ", model=" + this.features + ", isSupportAcc=" + this.isSupportAcc + ", isSupportGyro=" + this.isSupportGyro + "]";
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(long l2) {
        this.connectTime = l2;
    }

    public int hashCode() {
        int n = 31 + (this.deviceAddr == null ? 0 : this.deviceAddr.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (BTDevice)object;
        return !(this.deviceAddr == null ? ((BTDevice)object).deviceAddr != null : !this.deviceAddr.equals(((BTDevice)object).deviceAddr));
    }

    public BTDevice(String string, int n, int n2, String string2, boolean bl, int n3, boolean bl2) {
        this.isExternal = bl;
        this.state = n3;
        this.isConnected = bl2;
        this.deviceName = string;
        this.deviceId = n;
        this.deviceType = n2;
        this.deviceAddr = string2;
    }

    public BTDevice() {
    }

    public BTDevice(String string) {
        this.deviceName = "device";
        this.deviceId = -1;
        this.deviceAddr = string;
        this.deviceType = -1;
    }

    public boolean isValid() {
        if (this.isExternal) {
            return true;
        }
        return !this.deviceAddr.equals("0:0:0:0:0:0") && this.deviceType >= 0;
    }

    public void recordConnectTime() {
        this.connectTime = System.currentTimeMillis();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public boolean isHost() {
        return this.playerOrder == 1;
    }

    public BTDevice(Parcel parcel) {
        this.setConnectTime(parcel.readLong());
        this.setDeviceAddr(parcel.readString());
        this.setDeviceId(parcel.readInt());
        this.setDeviceName(parcel.readString());
        this.setDeviceType(parcel.readInt());
        this.setConnected(parcel.readInt() == 1);
        this.setPlayerOrder(parcel.readInt());
        this.setState(parcel.readInt());
        this.setExternal(parcel.readInt() == 1);
        this.setFeatures(parcel.readInt());
        this.setSupportAcc(parcel.readInt() == 1);
        this.setSupportGyro(parcel.readInt() == 1);
    }

    public void setFeatures(int n) {
        this.features = n;
    }

    public BTDevice(InputDevice inputDevice) {
        this.isExternal = true;
        this.isConnected = true;
        this.state = 1;
        this.deviceId = inputDevice.getId();
        this.deviceName = inputDevice.getName();
        this.deviceType = 0;
        this.connectTime = SystemClock.uptimeMillis();
        this.deviceAddr = "gen:" + inputDevice.getName() + ":" + inputDevice.getId();
    }

    public BTDevice(BTDevice bTDevice) {
        this.isExternal = bTDevice.isExternal;
        this.isConnected = bTDevice.isConnected;
        this.state = bTDevice.state;
        this.deviceId = bTDevice.deviceId;
        this.deviceName = bTDevice.deviceName;
        this.deviceType = bTDevice.deviceType;
        this.connectTime = bTDevice.connectTime;
        this.playerOrder = bTDevice.playerOrder;
        this.deviceAddr = bTDevice.deviceAddr;
    }

    public int describeContents() {
        return 3012;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeLong(this.connectTime);
        if (this.deviceAddr == null) {
            this.deviceAddr = "";
        }
        parcel.writeString(this.deviceAddr);
        parcel.writeInt(this.deviceId);
        if (this.deviceName == null) {
            this.deviceName = "Unknown";
        }
        parcel.writeString(this.deviceName);
        parcel.writeInt(this.deviceType);
        parcel.writeInt(this.isConnected ? 1 : 0);
        parcel.writeInt(this.playerOrder);
        parcel.writeInt(this.state);
        parcel.writeInt(this.isExternal ? 1 : 0);
        parcel.writeInt(this.features);
        parcel.writeInt(this.isSupportAcc ? 1 : 0);
        parcel.writeInt(this.isSupportGyro ? 1 : 0);
    }
}

