/*
 * Decompiled with CFR 0.152.
 */
package cn.uc.gamesdk.bridge;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.uc.gamesdk.bridge.BridgeChromeClient;
import cn.uc.gamesdk.bridge.BridgeChromeClient7;
import cn.uc.gamesdk.bridge.BridgeProgressBar;
import cn.uc.gamesdk.bridge.BridgeWebView;
import cn.uc.gamesdk.bridge.BridgeWebViewClient;
import cn.uc.gamesdk.bridge.BridgeWebViewClient11;
import cn.uc.gamesdk.bridge.CallbackServer;
import cn.uc.gamesdk.bridge.RelativeLayoutSoftKeyboardDetect;
import cn.uc.gamesdk.bridge.TrustDomain;
import cn.uc.gamesdk.bridge.a.a;
import cn.uc.gamesdk.bridge.a.e;
import cn.uc.gamesdk.c.f;
import cn.uc.gamesdk.c.i;
import cn.uc.gamesdk.g.g;
import cn.uc.gamesdk.i.c;
import cn.uc.gamesdk.j.a.b;
import cn.uc.gamesdk.j.l;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

public class WebBridge
extends Activity
implements RelativeLayoutSoftKeyboardDetect.KeyboardListener,
a {
    public static final String CLASS_NAME = "WebBridge";
    public static final String LOADING_TIP_CONTENT = "\u6b63\u5728\u52a0\u8f7d";
    private static final String g = "javascript:";
    private static final String h = "http://";
    private static final String i = "https://";
    public static final int TOP_BAR_HEIGHT_DIP = 44;
    public static final int BOTTOM_BAR_HEIGHT_DIP = 55;
    public RelativeLayoutSoftKeyboardDetect rootLayout;
    public CallbackServer callbackServer;
    protected BridgeWebView a;
    protected WebViewClient b;
    protected e c;
    protected int d = 0;
    protected int e = 40000;
    protected boolean f = true;
    private boolean j = true;
    private boolean k = true;
    private boolean l = false;
    private static boolean m = false;
    private static WeakReference<WebView> n;
    private static final int o = 1;
    private static int p;
    private static int q;
    private static int r;
    public Stack<String> urls = new Stack();
    public String currentUrl = null;
    private View s;
    private BridgeProgressBar t = null;
    private EditText u = null;
    private int v = 0;
    private View.OnClickListener w = new View.OnClickListener(){

        public void onClick(View v2) {
            if (WebBridge.this.a != null) {
                WebBridge.this.a.stopLoading();
            }
        }
    };
    private static final Timer x;
    public static final int PROGRESS_UPDATE = 0;
    public Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    int progress = (Integer)msg.obj;
                    if (WebBridge.this.t == null) break;
                    WebBridge.this.t.setProgress(progress);
                    break;
                }
            }
        }
    };
    private static final int y = 1;
    private static final int z = 2;
    private static final int A = 3;

    public void setBackHistroyEnable(boolean enable) {
        this.j = enable;
    }

    public void setKeyboardBackExitEnable(boolean enable) {
        this.k = enable;
    }

    @TargetApi(value=11)
    public void onCreate(Bundle savedInstanceState) {
        cn.uc.gamesdk.g.g.a(CLASS_NAME, "onCreate", "onCreate call");
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setSoftInputMode(16);
        this.getWindow().getDecorView().setDrawingCacheEnabled(true);
    }

    public void initWebUI(String url) {
        cn.uc.gamesdk.g.g.a(CLASS_NAME, "init", "WebBridge.initWebUI()");
        cn.uc.gamesdk.g.g.b(CLASS_NAME, "initWebUI", "enter", "");
        this.initUI(url);
        this.initNOUILogic();
        cn.uc.gamesdk.g.g.b(CLASS_NAME, "initWebUI", "cost", "");
    }

    public void initNOUILogic() {
        if (this.c == null) {
            this.c = new e(this.a, this);
            this.c.a();
        }
        if (this.callbackServer == null) {
            this.callbackServer = new CallbackServer();
        }
    }

    public void showKeyboard(boolean isPassword, String text, String hint, final cn.uc.gamesdk.c.g<String> callback) {
        if (this.u != null) {
            if (isPassword) {
                this.u.setInputType(129);
            } else {
                this.u.setInputType(1);
            }
            this.u.setHint((CharSequence)hint);
            this.u.setVisibility(0);
            this.u.getEditableText().clear();
            this.u.getEditableText().append((CharSequence)text);
            this.u.setImeOptions(2);
            this.u.setSingleLine(true);
            this.u.setImeActionLabel((CharSequence)"\u786e\u5b9a", 6);
            this.u.requestFocus();
            InputMethodManager im = (InputMethodManager)this.getSystemService("input_method");
            im.showSoftInput((View)this.u, 0);
            this.u.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v2, int actionId, KeyEvent event) {
                    if (!(actionId != 3 && actionId != 6 && (event.getAction() != 0 || event.getKeyCode() != 66) || event != null && event.isShiftPressed())) {
                        if (WebBridge.this.u != null) {
                            WebBridge.this.u.setVisibility(8);
                        }
                        callback.callback(WebBridge.this.u.getEditableText().toString());
                        cn.uc.gamesdk.g.g.a(WebBridge.CLASS_NAME, "showKeyboard", "finish press value = " + WebBridge.this.u.toString());
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    public void initUI(String url) {
        if (this.rootLayout == null) {
            this.rootLayout = new RelativeLayoutSoftKeyboardDetect((Context)this);
            this.rootLayout.setBackgroundColor(0);
            this.rootLayout.registerKeyboardListener(this);
        }
        this.setContentView((View)this.rootLayout);
        BridgeChromeClient wcc = null;
        int androidSdkVer = Build.VERSION.SDK_INT;
        wcc = androidSdkVer >= 7 ? new BridgeChromeClient7((Context)this) : new BridgeChromeClient((Context)this);
        this.b = androidSdkVer >= 11 ? new BridgeWebViewClient11(this) : new BridgeWebViewClient(this);
        this.a = new BridgeWebView(this, wcc, this.b);
        n = new WeakReference<BridgeWebView>(this.a);
        if (m) {
            this.a.clearCache(false);
            m = false;
        }
        RelativeLayout.LayoutParams layoutParams = null;
        this.s = this.topBar(url);
        View bottomBar = this.bottomBar();
        if (this.s != null) {
            this.s.setId(1);
            layoutParams = new RelativeLayout.LayoutParams(-1, cn.uc.gamesdk.c.i.a(44));
            this.rootLayout.addView(this.s, (ViewGroup.LayoutParams)layoutParams);
        }
        layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        if (this.s != null) {
            layoutParams.addRule(3, this.s.getId());
        }
        if (bottomBar != null) {
            layoutParams.addRule(2, bottomBar.getId());
        }
        this.rootLayout.addView((View)this.a, (ViewGroup.LayoutParams)layoutParams);
        layoutParams = new RelativeLayout.LayoutParams(-1, cn.uc.gamesdk.c.i.a(4));
        this.t = new BridgeProgressBar((Context)this, null, 16842875);
        if (this.s != null) {
            layoutParams.addRule(3, this.s.getId());
        }
        this.rootLayout.addView((View)this.t, (ViewGroup.LayoutParams)layoutParams);
        if (bottomBar != null) {
            RelativeLayout.LayoutParams bottomParams = new RelativeLayout.LayoutParams(-1, -2);
            bottomParams.addRule(12, -1);
            this.rootLayout.addView(bottomBar, (ViewGroup.LayoutParams)bottomParams);
        }
        this.u = new EditText((Context)this);
        layoutParams = new RelativeLayout.LayoutParams(0, 0);
        layoutParams.addRule(12, -1);
        this.u.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.u.setVisibility(8);
        this.rootLayout.addView((View)this.u);
    }

    protected View topBar(String url) {
        return null;
    }

    protected View bottomBar() {
        return null;
    }

    @Override
    public void loadUrl(String url) {
        this.loadUrlIntoView(url);
    }

    private void loadUrlIntoView(final String url) {
        final WebBridge me = this;
        if (url == null) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (me.urls.size() == 0) {
                        me.finish();
                    }
                }
            });
            cn.uc.gamesdk.c.i.a("Url\u4e3a\u7a7a");
            return;
        }
        if (url.startsWith(g)) {
            cn.uc.gamesdk.g.g.a(CLASS_NAME, "loadUrlIntoView", "WebBridge.loadUr = " + url);
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (me.a != null) {
                        me.a.loadUrl(url);
                    }
                }
            });
            return;
        }
        if ((url.startsWith(h) || url.startsWith(i)) && !this.isUrlWhiteListed(url)) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (me.urls.size() == 0) {
                        me.finish();
                    } else {
                        me.a.stopLoading();
                    }
                }
            });
            cn.uc.gamesdk.c.i.a("Url=" + url + ", \u8bbf\u95ee\u88ab\u7981\u6b62");
            return;
        }
        this.currentUrl = url;
        if (!url.startsWith(g)) {
            cn.uc.gamesdk.g.g.a(CLASS_NAME, "loadUrlIntoView", String.format("WebBridge: url=%s", url));
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (me.a == null) {
                    me.initWebUI(url);
                }
                cn.uc.gamesdk.g.g.a(WebBridge.CLASS_NAME, "initWebUI", "finished");
                me.urls.push(url);
                try {
                    me.a.loadUrl(url);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public void loadHttpUrlAsync(final String url) {
        final WebBridge me = this;
        final String ua = me.a.getSettings().getUserAgentString();
        me.spinnerStart(LOADING_TIP_CONTENT, 1);
        cn.uc.gamesdk.c.l.a(new Runnable(){

            @Override
            public void run() {
                b httpConn = new b(ua);
                String content = httpConn.a(url, (HashMap<String, String>)null);
                if (content == null) {
                    content = "\u7f51\u7edc\u6ca1\u6709\u54cd\u5e94\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5.";
                }
                final String finalContent = content;
                me.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        me.a.loadDataWithBaseURL(url, finalContent, "text/plain", "utf-8", url);
                    }
                });
                me.spinnerStop();
            }
        });
    }

    @Override
    public void clearBridgeHistory() {
        this.urls.clear();
        this.a.clearHistory();
        this.onUpdateWebviewHistory();
        if (this.currentUrl != null) {
            this.urls.push(this.currentUrl);
        }
    }

    public void clearWebview() {
        if (this.a != null) {
            this.destoryBridgeRes();
        }
        this.a = null;
    }

    @Override
    public boolean backHistory() {
        if (!this.j || this.a == null) {
            cn.uc.gamesdk.g.g.a(CLASS_NAME, "backHistory", "Webbridge \u8fd4\u56de\u5386\u53f2\u6ca1\u6709\u751f\u6548");
            return false;
        }
        boolean toBack = false;
        if (this.a.canGoBack()) {
            WebBackForwardList webbflist = this.a.copyBackForwardList();
            WebHistoryItem historyItem = webbflist.getItemAtIndex(webbflist.getCurrentIndex() - 1);
            this.a.loadUrl("javascript:try{bridge.fireDocumentEvent('bridgebackhistory', {'historyToBack' : '" + historyItem.getUrl() + "' }); }catch(e){console.log(e);};");
            this.a.goBack();
            toBack = true;
        }
        x.schedule(new TimerTask(){

            @Override
            public void run() {
                WebBridge.this.onUpdateWebviewHistory();
            }
        }, 100L);
        return toBack;
    }

    protected String getCurrentRealUrl() {
        WebBackForwardList webbflist = this.a.copyBackForwardList();
        WebHistoryItem curHisItem = webbflist.getCurrentItem();
        return curHisItem != null ? curHisItem.getUrl() : "";
    }

    protected void onPause() {
        cn.uc.gamesdk.g.g.a(CLASS_NAME, "onPause", "onPause call");
        super.onPause();
        if (this.v == r) {
            return;
        }
        if (this.a == null) {
            return;
        }
        if (!this.f) {
            this.a.pauseTimers();
        }
    }

    protected void onResume() {
        cn.uc.gamesdk.g.g.a(CLASS_NAME, "onResume", "onResume call");
        WebView.enablePlatformNotifications();
        super.onResume();
        if (this.v == p) {
            this.v = q;
            return;
        }
        if (this.a == null) {
            return;
        }
        if (this.c != null) {
            this.c.b(this.f);
        }
        if (!this.f) {
            this.a.resumeTimers();
        }
    }

    public void onDestroy() {
        cn.uc.gamesdk.g.g.a(CLASS_NAME, "onDestroy", "onDestroy call");
        this.destoryBridgeRes();
        super.onDestroy();
    }

    public void privateClearWebviewCache() {
        WebBridge.clearWebviewCache((Context)this);
        if (this.a != null) {
            this.a.clearCache(true);
        }
    }

    public static void clearWebviewCache(Context ctx) {
        Context appContext = ctx.getApplicationContext();
        WebBridge.clearCache(appContext, 0);
        appContext.deleteDatabase("webview.db");
        appContext.deleteDatabase("webviewCache.db");
    }

    public void destoryBridgeRes() {
        if (this.a != null) {
            this.a.stopLoading();
            this.a.loadUrl("javascript:try{bridge.require('bridge/channel').onDestroy.fire();}catch(e){console.log('exception firing destroy event from native');};");
            this.a.loadUrl("about:blank");
        }
        if (this.c != null) {
            this.c.e();
        }
    }

    @Override
    public void sendJavascript(String statement) {
        cn.uc.gamesdk.g.g.a(CLASS_NAME, "sendJavascript", statement);
        if (this.callbackServer != null) {
            this.callbackServer.sendJavascript(statement);
        }
    }

    @Override
    public void showWebPage(String url, boolean openExternal, boolean clearHistory, HashMap<String, Object> params) {
        cn.uc.gamesdk.g.g.a(CLASS_NAME, "showWebPage", String.format("showWebPage(%s, %b, %b, HashMap", url, openExternal, clearHistory));
        if (clearHistory) {
            this.clearBridgeHistory();
        }
        if (!openExternal) {
            if (url.startsWith("file://") || this.isUrlWhiteListed(url)) {
                if (clearHistory) {
                    this.urls.clear();
                }
                this.loadUrl(url);
            } else {
                cn.uc.gamesdk.g.g.a(CLASS_NAME, "showWebPage", String.format("showWebPage: Cannot load URL into webview since it is not in white list.  Loading into browser instead. (URL=" + url + ")", new Object[0]));
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException e2) {
                    cn.uc.gamesdk.g.g.b(CLASS_NAME, "showWebPage", "Error loading url " + url + e2.getMessage());
                }
            }
        } else {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                this.startActivity(intent);
            }
            catch (ActivityNotFoundException e3) {
                cn.uc.gamesdk.g.g.b(CLASS_NAME, "showWebPage", "Error loading url " + url + e3.getMessage());
            }
        }
    }

    public void spinnerStart(final String message, final int loadMaskType) {
        final WebBridge me = this;
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (me.isFinishing()) {
                        return;
                    }
                    cn.uc.gamesdk.view.b.a((Context)WebBridge.this, message, WebBridge.this.w, loadMaskType);
                }
            });
        }
        catch (Exception e2) {
            cn.uc.gamesdk.g.g.b(CLASS_NAME, "spinnerStart", "\u52a0\u8f7d\u83ca\u82b1\u5f02\u5e38", e2);
        }
    }

    public void spinnerStop() {
        final WebBridge me = this;
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (me.isFinishing()) {
                        return;
                    }
                    cn.uc.gamesdk.view.b.a((Context)WebBridge.this);
                }
            });
        }
        catch (Exception e2) {
            cn.uc.gamesdk.g.g.b(CLASS_NAME, "spinnerStop", "\u52a0\u8f7d\u83ca\u82b1\u5f02\u5e38", e2);
        }
    }

    @Override
    public synchronized void finish() {
        try {
            cn.uc.gamesdk.view.b.a();
            this.v = r;
            super.finish();
        }
        catch (Exception e2) {
            cn.uc.gamesdk.g.g.a(CLASS_NAME, "finish", "SDK INNER API call error", "ui\u5f02\u5e38", e2);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.a == null) {
            return super.onKeyDown(keyCode, event);
        }
        if (keyCode == 4) {
            if (this.l) {
                this.loadUrl("javascript:bridge.fireDocumentEvent('backbutton');");
                return true;
            }
            if (this.backHistory()) {
                return true;
            }
            if (this.k) {
                this.v = r;
                return super.onKeyDown(keyCode, event);
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean hasBackHistory() {
        if (this.a == null) {
            return false;
        }
        return this.a.canGoBack();
    }

    @Override
    public String getCurrentDomain() {
        try {
            String domain = new URL(this.currentUrl).getHost();
            if (cn.uc.gamesdk.j.l.k(domain)) {
                domain = "localhost";
            }
            cn.uc.gamesdk.g.g.a(CLASS_NAME, "getCurrentDomain", "domain = " + domain);
            return domain;
        }
        catch (MalformedURLException e2) {
            cn.uc.gamesdk.g.g.a(CLASS_NAME, "getCurrentDomain", "domain\u83b7\u53d6\u5931\u8d25 ");
            return null;
        }
    }

    public void onReceivedError(int errorCode, String description, String failingUrl) {
        final WebBridge me = this;
        String message = "";
        message = errorCode == -8 ? "\u7f51\u7edc\u52a0\u8f7d\u8f83\u6162\u3002\u5982\u679c\u6709\u95ee\u9898\uff0c\u8bf7\u8fd4\u56de\u6e38\u620f\u540e\u91cd\u8bd5\u3002" : "\u7f51\u7edc\u6ca1\u6709\u54cd\u5e94\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002";
        final String errMsg = message;
        me.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (me.isFinishing()) {
                    return;
                }
                if (me.a != null) {
                    me.a.stopLoading();
                }
                me.setProgress(100);
                me.spinnerStop();
                try {
                    AlertDialog.Builder ab = new AlertDialog.Builder((Context)me);
                    ab.setMessage((CharSequence)errMsg);
                    ab.setCancelable(false);
                    ab.setNegativeButton((CharSequence)"\u53d6\u6d88", null);
                    ab.show();
                    me.a.setVisibility(0);
                }
                catch (Exception e2) {
                    cn.uc.gamesdk.g.g.b(WebBridge.CLASS_NAME, "onReceivedError", "ui\u5f02\u5e38");
                }
            }
        });
    }

    public String peekAtUrlStack() {
        if (this.urls.size() > 0) {
            return this.urls.peek();
        }
        return "";
    }

    public void pushUrl(String url) {
        this.urls.push(url);
    }

    @Override
    public Stack<String> getUrls() {
        return this.urls;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        if (cn.uc.gamesdk.c.f.d) {
            menu.add(0, 1, 1, (CharSequence)"\u5173\u95ed\u7f13\u5b58");
            menu.add(0, 2, 2, (CharSequence)"\u5f00\u542f\u7f13\u5b58");
            menu.add(0, 3, 3, (CharSequence)"\u6e05\u7a7a\u7f13\u5b58");
        }
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        return super.onPrepareOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                cn.uc.gamesdk.i.c.b(1);
                break;
            }
            case 2: {
                cn.uc.gamesdk.i.c.b(2);
                break;
            }
            case 3: {
                this.privateClearWebviewCache();
                break;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public boolean isUrlWhiteListed(String source) {
        return TrustDomain.isUrlFromTrustDomain(source);
    }

    protected void onStop() {
        WebView.disablePlatformNotifications();
        super.onStop();
    }

    static int clearCacheFolder(File dir, int numDays) {
        int deletedFiles = 0;
        if (dir != null && dir.isDirectory()) {
            try {
                for (File child : dir.listFiles()) {
                    if (child.isDirectory()) {
                        deletedFiles += WebBridge.clearCacheFolder(child, numDays);
                    }
                    if (child.lastModified() >= new Date().getTime() - (long)numDays * 86400000L || !child.delete()) continue;
                    ++deletedFiles;
                }
            }
            catch (Exception e2) {
                Log.e((String)CLASS_NAME, (String)String.format("Failed to clean the cache, error %s", e2.getMessage()));
            }
        }
        return deletedFiles;
    }

    public static void clearCache(Context context, int numDays) {
        WebBridge.clearCacheFolder(context.getCacheDir(), numDays);
    }

    public void onReceiveJsBridgeConfig(JSONObject jsonObject) {
    }

    public void onPageFinished(String url) {
    }

    @Override
    public void onUpdateWebviewHistory() {
    }

    public void onLowMemory() {
        super.onLowMemory();
        cn.uc.gamesdk.g.g.b(CLASS_NAME, "onLowMemory", "\u5185\u5b58\u8f83\u4f4e\uff0c\u8bf7\u53ca\u65f6\u6e05\u7406\u5185\u5b58");
    }

    public static void toClearWebviewRAMCacheOnce() {
        cn.uc.gamesdk.c.f.a.post(new Runnable(){

            @Override
            public void run() {
                if (n != null) {
                    WebView wv = (WebView)n.get();
                    if (wv != null) {
                        wv.clearCache(false);
                    }
                } else {
                    m = true;
                }
            }
        });
    }

    public void onPageStarted(String url) {
    }

    @Override
    public void bindBackButton(boolean override) {
        this.l = override;
    }

    @Override
    public void onKeyboardShow() {
    }

    @Override
    public void onKeyboardHide() {
    }

    static {
        p = 0;
        q = 1;
        r = 2;
        x = new Timer();
    }
}

