/*
 * Decompiled with CFR 0.152.
 */
package cn.uc.gamesdk.bridge;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.http.HttpHost;

public class ProxySettings {
    private static final String b = "GAEProxy.ProxySettings";
    static final int a = 193;

    private static Object getDeclaredField(Object obj, String name) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f2 = obj.getClass().getDeclaredField(name);
        f2.setAccessible(true);
        Object out = f2.get(obj);
        return out;
    }

    public static Object getRequestQueue(Context ctx) throws Exception {
        Object networkObj;
        Object ret = null;
        Class<?> networkClass = Class.forName("android.webkit.Network");
        if (networkClass != null && (networkObj = ProxySettings.invokeMethod(networkClass, "getInstance", new Object[]{ctx}, Context.class)) != null) {
            ret = ProxySettings.getDeclaredField(networkObj, "mRequestQueue");
        }
        return ret;
    }

    private static Object invokeMethod(Object object, String methodName, Object[] params, Class ... types) throws Exception {
        Class<?> c2;
        Object out = null;
        Class<?> clazz = c2 = object instanceof Class ? (Class<?>)object : object.getClass();
        if (types != null) {
            Method method = c2.getMethod(methodName, types);
            out = method.invoke(object, params);
        } else {
            Method method = c2.getMethod(methodName, new Class[0]);
            out = method.invoke(object, new Object[0]);
        }
        return out;
    }

    public static void resetProxy(Context ctx) throws Exception {
        Object requestQueueObject = ProxySettings.getRequestQueue(ctx);
        if (requestQueueObject != null) {
            ProxySettings.setDeclaredField(requestQueueObject, "mProxyHost", null);
        }
    }

    private static void setDeclaredField(Object obj, String name, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f2 = obj.getClass().getDeclaredField(name);
        f2.setAccessible(true);
        f2.set(obj, value);
    }

    public static boolean setProxy(Context ctx, String host, int port) {
        boolean ret = false;
        ProxySettings.setSystemProperties(host, port);
        try {
            if (Build.VERSION.SDK_INT < 14) {
                Object requestQueueObject = ProxySettings.getRequestQueue(ctx);
                if (requestQueueObject != null) {
                    HttpHost httpHost = new HttpHost(host, port, "http");
                    ProxySettings.setDeclaredField(requestQueueObject, "mProxyHost", httpHost);
                    ret = true;
                }
            } else {
                ret = ProxySettings.setICSProxy(host, port);
            }
        }
        catch (Exception e2) {
            Log.e((String)b, (String)"error setting up webkit proxying", (Throwable)e2);
        }
        return ret;
    }

    private static boolean setICSProxy(String host, int port) throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> webViewCoreClass = Class.forName("android.webkit.WebViewCore");
        Class<?> proxyPropertiesClass = Class.forName("android.net.ProxyProperties");
        if (webViewCoreClass != null && proxyPropertiesClass != null) {
            Method m2 = webViewCoreClass.getDeclaredMethod("sendStaticMessage", Integer.TYPE, Object.class);
            Constructor<?> c2 = proxyPropertiesClass.getConstructor(String.class, Integer.TYPE, String.class);
            m2.setAccessible(true);
            c2.setAccessible(true);
            Object properties = c2.newInstance(host, port, null);
            m2.invoke(null, 193, properties);
            return true;
        }
        return false;
    }

    private static void setSystemProperties(String host, int port) {
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", port + "");
        System.setProperty("https.proxyHost", host);
        System.setProperty("https.proxyPort", port + "");
    }
}

