/*
 * Decompiled with CFR 0.152.
 */
package cn.uc.gamesdk.bridge;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import cn.uc.gamesdk.bridge.BridgeReflect;
import cn.uc.gamesdk.bridge.Console;
import cn.uc.gamesdk.bridge.WebBridge;
import cn.uc.gamesdk.g.g;
import cn.uc.gamesdk.i.c;
import org.json.JSONObject;

public class BridgeWebView
extends WebView {
    private static final String a = "BridgeWebView";
    private WebBridge b;
    private WebviewOnTouchListener c;

    public BridgeWebView(WebBridge context, WebChromeClient wcc, WebViewClient wvc) {
        super((Context)context);
        this.b = context;
        this.c = new WebviewOnTouchListener();
        this.setOnTouchListener(this.c);
        this.setWebChromeClient(wcc);
        this.setWebViewClient(wvc);
        this.setup();
    }

    @TargetApi(value=11)
    public void setup() {
        WebView.enablePlatformNotifications();
        this.setInitialScale(0);
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.requestFocusFromTouch();
        this.requestFocus();
        this.setFocusable(true);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v2, MotionEvent e2) {
                switch (e2.getAction()) {
                    case 0: 
                    case 1: {
                        if (v2.hasFocus()) break;
                        v2.requestFocus();
                    }
                }
                return false;
            }
        });
        if (Integer.valueOf(Build.VERSION.SDK) <= 7) {
            this.addJavascriptInterface(new Console(), "console");
        }
        class UCGameSDK {
            UCGameSDK() {
            }
        }
        this.addJavascriptInterface(new UCGameSDK(), "UCGameSDK");
        WebSettings webSettings = this.getSettings();
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setNeedInitialFocus(true);
        webSettings.setSaveFormData(false);
        webSettings.setSavePassword(false);
        webSettings.setPluginsEnabled(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setSupportZoom(true);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setCacheMode(-1);
        Class<?> webSettingCls = webSettings.getClass();
        g.a(a, "setup", "app cache policy = " + cn.uc.gamesdk.i.c.j());
        int appCachePolicy = cn.uc.gamesdk.i.c.j();
        switch (appCachePolicy) {
            case 2: {
                webSettings.setAllowFileAccess(true);
                String appCachePath = this.getAppCachePath();
                BridgeReflect.invokeMethod(webSettingCls, webSettings, "setAppCacheMaxSize", new Class[]{Long.TYPE}, new Object[]{0x800000L});
                BridgeReflect.invokeMethod(webSettingCls, webSettings, "setAppCacheEnabled", new Class[]{Boolean.TYPE}, new Object[]{Boolean.TRUE});
                BridgeReflect.invokeMethod(webSettingCls, webSettings, "setAppCachePath", new Class[]{String.class}, new Object[]{appCachePath});
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                break;
            }
        }
        BridgeReflect.invokeMethod(webSettingCls, webSettings, "setDomStorageEnabled", new Class[]{Boolean.TYPE}, new Object[]{true});
        if (Build.VERSION.SDK_INT < 11) {
            webSettings.setNavDump(true);
        }
        BridgeReflect.invokeMethod(webSettingCls, webSettings, "setPageCacheCapacity", new Class[]{Integer.TYPE}, new Object[]{20});
        BridgeReflect.invokeMethod(webSettingCls, webSettings, "setDatabaseEnabled", new Class[]{Boolean.TYPE}, new Object[]{true});
        String dbPath = this.getDataBasePath();
        BridgeReflect.invokeMethod(webSettingCls, webSettings, "setDatabasePath", new Class[]{String.class}, new Object[]{dbPath});
        this.disableGPU();
    }

    @TargetApi(value=11)
    private void disableGPU() {
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                this.setLayerType(1, null);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void setConfig(JSONObject config) {
        g.a(a, "setConfig", "config = " + config);
        if (config == null) {
            return;
        }
        if (config.has("scrollable")) {
            boolean scrollable;
            this.c.scrollable = scrollable = config.optBoolean("scrollable", true);
        }
    }

    private String getAppCachePath() {
        return this.b.getApplicationContext().getCacheDir().getAbsolutePath();
    }

    private String getDataBasePath() {
        return this.b.getApplicationContext().getDir("database", 0).getPath();
    }

    private static class WebviewOnTouchListener
    implements View.OnTouchListener {
        public boolean scrollable = true;

        private WebviewOnTouchListener() {
        }

        public boolean onTouch(View v2, MotionEvent event) {
            return !this.scrollable && event.getAction() == 2;
        }
    }
}

