/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.action;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.facebook.ads.VideoAdActivity;
import com.facebook.ads.internal.action.AppAdAction;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoAppAdAction
extends AppAdAction {
    private static final String TAG = VideoAppAdAction.class.getSimpleName();
    private final Context context;
    private final Uri uri;

    public VideoAppAdAction(Context context, Uri uri) {
        super(context, uri);
        this.context = context;
        this.uri = uri;
    }

    @Override
    public void execute(Map<String, String> intentExtras) {
        this.logAdClick(this.context, this.uri);
        String videoURL = this.uri.getQueryParameter("video_url");
        Intent videoIntent = new Intent(this.context, VideoAdActivity.class);
        videoIntent.putExtra("adUri", this.uri.toString());
        videoIntent.putExtra("adVideoPath", videoURL);
        videoIntent.putExtra("adMarketUri", this.getMarketUri().toString());
        VideoAppAdAction.addMapToIntentExtras(intentExtras, videoIntent);
        try {
            this.context.startActivity(videoIntent);
        }
        catch (Exception ex1) {
            Log.d((String)TAG, (String)"Failed to start video", (Throwable)ex1);
        }
    }

    private static void addMapToIntentExtras(Map<String, String> map, Intent intent) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            intent.putExtra(entry.getKey(), entry.getValue());
        }
    }
}

