/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal.action;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.Log;
import com.facebook.ads.internal.AdInvalidationUtils;
import com.facebook.ads.internal.AppSiteData;
import com.facebook.ads.internal.StringUtils;
import com.facebook.ads.internal.action.AdAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppAdAction
extends AdAction {
    private static final String TAG = AppAdAction.class.getSimpleName();
    private static final String MARKET_DETAIL_URI_FORMAT = "market://details?id=%s";
    private final Context context;
    private final Uri uri;

    public AppAdAction(Context context, Uri uri) {
        this.context = context;
        this.uri = uri;
    }

    protected Uri getMarketUri() {
        String storeId = this.uri.getQueryParameter("store_id");
        return Uri.parse((String)String.format(MARKET_DETAIL_URI_FORMAT, storeId));
    }

    private List<AppSiteData> getAppsiteDatas() {
        String appsiteDataString = this.uri.getQueryParameter("appsite_data");
        if (StringUtils.isNullOrEmpty(appsiteDataString) || "[]".equals(appsiteDataString)) {
            return null;
        }
        ArrayList<AppSiteData> appSiteDatas = new ArrayList<AppSiteData>();
        try {
            JSONObject dataObject = new JSONObject(appsiteDataString);
            JSONArray appsiteDataArray = dataObject.optJSONArray("android");
            if (appsiteDataArray != null) {
                for (int i = 0; i < appsiteDataArray.length(); ++i) {
                    AppSiteData appSiteData = AppSiteData.fromJSONObject(appsiteDataArray.optJSONObject(i));
                    if (appSiteData == null) continue;
                    appSiteDatas.add(appSiteData);
                }
            }
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)"Error parsing appsite_data", (Throwable)e);
        }
        return appSiteDatas;
    }

    private Intent getAppLinkIntentUnresolved(AppSiteData appSiteData) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(0x10000000);
        if (!StringUtils.isNullOrEmpty(appSiteData.getPackageName()) && !StringUtils.isNullOrEmpty(appSiteData.getClassName())) {
            intent.setComponent(new ComponentName(appSiteData.getPackageName(), appSiteData.getClassName()));
        }
        if (!StringUtils.isNullOrEmpty(appSiteData.getAppLinkUri())) {
            intent.setData(Uri.parse((String)appSiteData.getAppLinkUri()));
        }
        return intent;
    }

    private Intent getAppLaunchIntent(AppSiteData appSiteData) {
        if (StringUtils.isNullOrEmpty(appSiteData.getPackageName())) {
            return null;
        }
        if (!AdInvalidationUtils.isNativePackageInstalled(this.context, appSiteData.getPackageName())) {
            return null;
        }
        String appLinkUri = appSiteData.getAppLinkUri();
        if (!StringUtils.isNullOrEmpty(appLinkUri) && (appLinkUri.startsWith("tel:") || appLinkUri.startsWith("telprompt:"))) {
            return new Intent("android.intent.action.CALL", Uri.parse((String)appLinkUri));
        }
        PackageManager pm = this.context.getPackageManager();
        if (StringUtils.isNullOrEmpty(appSiteData.getClassName()) && StringUtils.isNullOrEmpty(appLinkUri)) {
            return pm.getLaunchIntentForPackage(appSiteData.getPackageName());
        }
        Intent unresolvedAppIntent = this.getAppLinkIntentUnresolved(appSiteData);
        List resolved = pm.queryIntentActivities(unresolvedAppIntent, 65536);
        if (unresolvedAppIntent.getComponent() == null) {
            for (ResolveInfo ri : resolved) {
                if (!ri.activityInfo.packageName.equals(appSiteData.getPackageName())) continue;
                unresolvedAppIntent.setComponent(new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name));
                break;
            }
        }
        if (resolved.isEmpty() || unresolvedAppIntent.getComponent() == null) {
            return null;
        }
        return unresolvedAppIntent;
    }

    protected List<Intent> getAppLaunchIntents() {
        List<AppSiteData> appSiteDatas = this.getAppsiteDatas();
        ArrayList<Intent> intents = new ArrayList<Intent>();
        if (appSiteDatas != null) {
            for (AppSiteData appSiteData : appSiteDatas) {
                Intent intent = this.getAppLaunchIntent(appSiteData);
                if (intent == null) continue;
                intents.add(intent);
            }
        }
        return intents;
    }

    @Override
    public void execute(Map<String, String> intentExtras) {
        this.logAdClick(this.context, this.uri);
        List<Intent> appLaunchIntents = this.getAppLaunchIntents();
        if (appLaunchIntents != null) {
            for (Intent appLaunchIntent : appLaunchIntents) {
                try {
                    this.context.startActivity(appLaunchIntent);
                    return;
                }
                catch (Exception ex) {
                    Log.d((String)TAG, (String)"Failed to open app intent, falling back", (Throwable)ex);
                }
            }
        }
        this.goToMarketURL();
    }

    public void goToMarketURL() {
        block4: {
            Uri marketUri = this.getMarketUri();
            Intent intent = new Intent("android.intent.action.VIEW", marketUri);
            try {
                this.context.startActivity(intent);
            }
            catch (Exception ex) {
                Log.d((String)TAG, (String)("Failed to open market url: " + this.uri.toString()), (Throwable)ex);
                String fallbackUrl = this.uri.getQueryParameter("store_url_web_fallback");
                if (fallbackUrl == null || fallbackUrl.length() <= 0) break block4;
                intent = new Intent("android.intent.action.VIEW", Uri.parse((String)fallbackUrl));
                try {
                    this.context.startActivity(intent);
                }
                catch (Exception ex2) {
                    Log.d((String)TAG, (String)("Failed to open fallback url: " + fallbackUrl), (Throwable)ex2);
                }
            }
        }
    }
}

