/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSiteData {
    private final String packageName;
    private final String className;
    private final String appLinkUri;
    private final List<String> keyHashes;
    private final String marketUri;
    private final String fallbackUrl;

    private AppSiteData(String packageName, String className, String appLinkUri, List<String> keyHashes, String marketUri, String fallbackUrl) {
        this.packageName = packageName;
        this.className = className;
        this.appLinkUri = appLinkUri;
        this.keyHashes = keyHashes;
        this.marketUri = marketUri;
        this.fallbackUrl = fallbackUrl;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getAppLinkUri() {
        return this.appLinkUri;
    }

    public List<String> getKeyHashes() {
        return this.keyHashes;
    }

    public String getMarketUri() {
        return this.marketUri;
    }

    public String getFallbackUrl() {
        return this.fallbackUrl;
    }

    public static AppSiteData fromJSONObject(JSONObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        String packageName = dataObject.optString("package");
        String appsite = dataObject.optString("appsite");
        String appsiteUri = dataObject.optString("appsite_url");
        JSONArray keyHashesArray = dataObject.optJSONArray("key_hashes");
        ArrayList<String> keyHashes = new ArrayList<String>();
        if (keyHashesArray != null) {
            for (int i = 0; i < keyHashesArray.length(); ++i) {
                keyHashes.add(keyHashesArray.optString(i));
            }
        }
        String marketUri = dataObject.optString("market_uri");
        String fallbackUrl = dataObject.optString("fallback_url");
        return new AppSiteData(packageName, appsite, appsiteUri, keyHashes, marketUri, fallbackUrl);
    }
}

