/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.Context;
import android.os.Looper;
import com.facebook.ads.internal.AdUtilities;
import com.facebook.ads.internal.StringUtils;
import java.lang.reflect.Method;

public class AdvertisingIdInfo {
    private static final int CONNECTION_RESULT_SUCCESS = 0;
    private final String id;
    private final boolean limitAdTrackingEnabled;

    private AdvertisingIdInfo(String id, boolean limitAdTrackingEnabled) {
        this.id = id;
        this.limitAdTrackingEnabled = limitAdTrackingEnabled;
    }

    public String getId() {
        return this.id;
    }

    public boolean isLimitAdTrackingEnabled() {
        return this.limitAdTrackingEnabled;
    }

    public static AdvertisingIdInfo getAdvertisingIdInfo(Context context, AdUtilities.Fb4aData fb4aData) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot get advertising info on main thread.");
        }
        if (fb4aData != null && !StringUtils.isNullOrEmpty(fb4aData.advertisingId)) {
            return new AdvertisingIdInfo(fb4aData.advertisingId, fb4aData.limitTrackingEnabled);
        }
        Method isGooglePlayServicesAvailable = AdUtilities.getMethod("com.google.android.gms.common.GooglePlayServicesUtil", "isGooglePlayServicesAvailable", Context.class);
        if (isGooglePlayServicesAvailable == null) {
            return null;
        }
        Object connectionResult = AdUtilities.invokeMethod(null, isGooglePlayServicesAvailable, context);
        if (connectionResult == null || (Integer)connectionResult != 0) {
            return null;
        }
        Method getAdvertisingIdInfo = AdUtilities.getMethod("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", Context.class);
        if (getAdvertisingIdInfo == null) {
            return null;
        }
        Object advertisingInfo = AdUtilities.invokeMethod(null, getAdvertisingIdInfo, context);
        if (advertisingInfo == null) {
            return null;
        }
        Method getId = AdUtilities.getMethod(advertisingInfo.getClass(), "getId", new Class[0]);
        Method isLimitAdTrackingEnabled = AdUtilities.getMethod(advertisingInfo.getClass(), "isLimitAdTrackingEnabled", new Class[0]);
        if (getId == null || isLimitAdTrackingEnabled == null) {
            return null;
        }
        String id = (String)AdUtilities.invokeMethod(advertisingInfo, getId, new Object[0]);
        Boolean limitAdTrackingEnabled = (Boolean)AdUtilities.invokeMethod(advertisingInfo, isLimitAdTrackingEnabled, new Object[0]);
        return new AdvertisingIdInfo(id, limitAdTrackingEnabled);
    }
}

