/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.facebook.ads.AdSettings;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdUtilities {
    private static final Uri ATTRIBUTION_ID_CONTENT_URI = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
    private static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final String ADVERTISING_ID_COLUMN_NAME = "androidid";
    private static final String LIMIT_TRACKING_COLUMN_NAME = "limit_tracking";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStreamToString(InputStream inputStream) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader reader = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(inputStream);
            reader = new InputStreamReader(bufferedInputStream);
            StringBuilder stringBuilder = new StringBuilder();
            int bufferSize = 2048;
            char[] buffer = new char[2048];
            while ((n = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, n);
            }
            string = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            AdUtilities.closeQuietly(bufferedInputStream);
            AdUtilities.closeQuietly(reader);
            throw throwable;
        }
        AdUtilities.closeQuietly(bufferedInputStream);
        AdUtilities.closeQuietly(reader);
        return string;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String jsonEncode(Map<String, Object> analogInfo) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : analogInfo.entrySet()) {
            try {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonObject.toString();
    }

    public static Object getStringPropertyAsJSON(JSONObject jsonObject, String key) throws JSONException {
        Object value = jsonObject.opt(key);
        if (value != null && value instanceof String) {
            JSONTokener tokener = new JSONTokener((String)value);
            value = tokener.nextValue();
        }
        if (value != null && !(value instanceof JSONObject) && !(value instanceof JSONArray)) {
            throw new IllegalArgumentException(key);
        }
        return value;
    }

    public static Fb4aData getFb4aData(ContentResolver contentResolver) {
        try {
            String[] projection = new String[]{ATTRIBUTION_ID_COLUMN_NAME, ADVERTISING_ID_COLUMN_NAME, LIMIT_TRACKING_COLUMN_NAME};
            Cursor c = contentResolver.query(ATTRIBUTION_ID_CONTENT_URI, projection, null, null, null);
            if (c == null || !c.moveToFirst()) {
                return new Fb4aData(null, null, false);
            }
            String attributionId = c.getString(c.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
            String advertisingId = c.getString(c.getColumnIndex(ADVERTISING_ID_COLUMN_NAME));
            Boolean limitTrackingEnabled = Boolean.valueOf(c.getString(c.getColumnIndex(LIMIT_TRACKING_COLUMN_NAME)));
            c.close();
            return new Fb4aData(attributionId, advertisingId, limitTrackingEnabled);
        }
        catch (Exception e) {
            return new Fb4aData(null, null, false);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethod(String className, String methodName, Class<?> ... parameterTypes) {
        try {
            Class<?> clazz = Class.forName(className);
            return AdUtilities.getMethod(clazz, methodName, parameterTypes);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static Object invokeMethod(Object receiver, Method method, Object ... args) {
        try {
            return method.invoke(receiver, args);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void displayDebugMessage(Context context, String message) {
        if (AdSettings.isTestMode(context)) {
            Log.d((String)"FBAudienceNetworkLog", (String)(message + " (displayed for test ads only)"));
        }
    }

    protected static class Fb4aData {
        protected String attributionId;
        protected String advertisingId;
        protected boolean limitTrackingEnabled;

        public Fb4aData(String attributionId, String androidId, boolean limitTrackingEnabled) {
            this.attributionId = attributionId;
            this.advertisingId = androidId;
            this.limitTrackingEnabled = limitTrackingEnabled;
        }
    }
}

