/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.Context;
import com.facebook.ads.AdError;
import com.facebook.ads.internal.AdDataModel;
import com.facebook.ads.internal.AdInvalidationUtils;
import com.facebook.ads.internal.AdType;
import com.facebook.ads.internal.HtmlAdDataModel;
import com.facebook.ads.internal.NativeAdDataModel;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdResponse {
    private static final int DEFAULT_REFRESH_INTERVAL_SECONDS = 0;
    private static final int DEFAULT_REFRESH_THRESHOLD_SECONDS = 20;
    private static final int DEFAULT_MIN_VIEWABILITY_PERCENTAGE = 10;
    private final int refreshIntervalMillis;
    private final int refreshThresholdMillis;
    private final int viewabilityThreshold;
    private final List<AdDataModel> dataModels;
    private final AdError error;

    private AdResponse(int refreshIntervalMillis, int refreshThresholdMillis, int viewabilityThresholdPercent, List<AdDataModel> dataModels, AdError error) {
        this.refreshIntervalMillis = refreshIntervalMillis;
        this.refreshThresholdMillis = refreshThresholdMillis;
        this.viewabilityThreshold = viewabilityThresholdPercent;
        this.dataModels = dataModels;
        this.error = error;
    }

    public int getRefreshIntervalMillis() {
        return this.refreshIntervalMillis;
    }

    public int getRefreshThresholdMillis() {
        return this.refreshThresholdMillis;
    }

    public int getViewabilityThreshold() {
        return this.viewabilityThreshold;
    }

    public AdDataModel getDataModel() {
        if (this.dataModels == null || this.dataModels.isEmpty()) {
            return null;
        }
        return this.dataModels.get(0);
    }

    public AdError getError() {
        return this.error;
    }

    public static AdResponse parseResponse(Context context, JSONObject jsonObject) {
        int refreshIntervalInMilli = jsonObject.optInt("refresh", 0) * 1000;
        int refreshThresholdMilli = jsonObject.optInt("refresh_threshold", 20) * 1000;
        int viewabilityThreshold = jsonObject.optInt("min_viewability_percentage", 10);
        AdError error = null;
        JSONObject errorObject = jsonObject.optJSONObject("reason");
        if (errorObject != null) {
            error = new AdError(errorObject.optInt("code"), errorObject.optString("message"));
        }
        int adType = jsonObject.optInt("ad_type");
        ArrayList<AdDataModel> dataModels = new ArrayList<AdDataModel>();
        JSONArray adsArray = jsonObject.optJSONArray("ads");
        if (adsArray != null && adsArray.length() > 0) {
            for (int i = 0; i < adsArray.length(); ++i) {
                JSONObject dataObject;
                JSONObject adData = adsArray.optJSONObject(i);
                if (adData == null) continue;
                AdDataModel dataModel = null;
                if (adType == AdType.HTML.getValue()) {
                    dataObject = adData.optJSONObject("data");
                    dataModel = HtmlAdDataModel.fromJSONObject(dataObject);
                } else if (adType == AdType.NATIVE.getValue()) {
                    dataObject = adData.optJSONObject("metadata");
                    dataModel = NativeAdDataModel.fromJSONObject(dataObject);
                }
                if (dataModel == null || AdInvalidationUtils.shouldInvalidate(context, dataModel)) continue;
                dataModels.add(dataModel);
            }
            if (dataModels.isEmpty()) {
                error = AdError.NO_FILL;
            }
        }
        return new AdResponse(refreshIntervalInMilli, refreshThresholdMilli, viewabilityThreshold, dataModels, error);
    }
}

