/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Handler;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.internal.AdRequest;
import com.facebook.ads.internal.AdResponse;
import com.facebook.ads.internal.AdType;

public class AdRequestController {
    private static final int MIN_REFRESH_INTERVAL_MILLIS = 30000;
    private static final int DEFAULT_REFRESH_THRESHOLD_MILLIS = 20000;
    private static final String ANDROID_PERMISSION_ACCESS_NETWORK_STATE = "android.permission.ACCESS_NETWORK_STATE";
    private final Context context;
    private final String placementId;
    private final AdSize adSize;
    private final AdRequest.Callback adViewRequestCallback;
    private final AdType adType;
    private final boolean shouldRefresh;
    private final ScreenStateReceiver screenStateReceiver;
    private int refreshInterval = 30000;
    private int refreshThreshold = 20000;
    private boolean initialLoadFinished = false;
    private volatile boolean refreshScheduled = false;
    private final Handler handler;
    private final Runnable refreshRunnable;
    private AsyncTask lastRequest;
    private volatile long lastLoadTimeMillis;
    private int currentVisibility = 8;

    public AdRequestController(Context context, String placementId, AdSize adSize, boolean shouldRefresh, AdType adType, AdRequest.Callback adViewRequestCallback) {
        if (adViewRequestCallback == null) {
            throw new IllegalArgumentException("adViewRequestCallback");
        }
        this.context = context;
        this.placementId = placementId;
        this.adSize = adSize;
        this.shouldRefresh = shouldRefresh;
        this.adType = adType;
        this.adViewRequestCallback = adViewRequestCallback;
        this.screenStateReceiver = new ScreenStateReceiver();
        this.handler = new Handler();
        this.refreshRunnable = new Runnable(){

            public void run() {
                AdRequestController.this.refreshScheduled = false;
                AdRequestController.this.loadAd();
            }
        };
        this.registerScreenStateReceiver();
    }

    private void registerScreenStateReceiver() {
        if (!this.shouldRefresh) {
            return;
        }
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        this.context.registerReceiver((BroadcastReceiver)this.screenStateReceiver, filter);
    }

    private void unregisterScreenStateReceiver() {
        if (!this.shouldRefresh) {
            return;
        }
        this.context.unregisterReceiver((BroadcastReceiver)this.screenStateReceiver);
    }

    public synchronized void scheduleRefresh(String reason) {
        if (!this.shouldRefresh) {
            return;
        }
        if (this.refreshInterval > 0) {
            if (this.refreshScheduled) {
                return;
            }
            this.handler.postDelayed(this.refreshRunnable, (long)this.refreshInterval);
            this.refreshScheduled = true;
        }
    }

    private synchronized void cancelRefresh(String reason) {
        if (!this.refreshScheduled) {
            return;
        }
        this.handler.removeCallbacks(this.refreshRunnable);
        this.refreshScheduled = false;
    }

    public synchronized void loadAd() {
        long earliestRefreshTime = this.lastLoadTimeMillis + (long)this.refreshThreshold;
        long now = System.currentTimeMillis();
        if (this.shouldRefresh && now < earliestRefreshTime) {
            this.adViewRequestCallback.onError(AdError.LOAD_TOO_FREQUENTLY);
            return;
        }
        if (this.refreshScheduled) {
            this.cancelRefresh(null);
        }
        if (this.lastRequest != null && this.lastRequest.getStatus() != AsyncTask.Status.FINISHED) {
            this.lastRequest.cancel(true);
        }
        if (!this.isNetworkConnected()) {
            this.refreshInterval = 30000;
            this.refreshThreshold = 20000;
            this.adViewRequestCallback.onError(new AdError(-1, "network unavailable"));
            this.scheduleRefresh("no network connection");
            return;
        }
        this.lastLoadTimeMillis = now;
        AdRequest adRequest = new AdRequest(this.context, this.placementId, this.adSize, this.adType, AdSettings.isTestMode(this.context), new AdRequest.Callback(){

            public void onError(AdError error) {
                AdRequestController.this.adViewRequestCallback.onError(error);
                AdRequestController.this.initialLoadFinished = true;
                AdRequestController.this.scheduleRefresh("onError");
            }

            public void onCompleted(AdResponse adResponse) {
                AdRequestController.this.refreshInterval = adResponse.getRefreshIntervalMillis();
                AdRequestController.this.refreshThreshold = adResponse.getRefreshThresholdMillis();
                AdRequestController.this.adViewRequestCallback.onCompleted(adResponse);
                AdRequestController.this.initialLoadFinished = true;
            }
        });
        this.lastRequest = adRequest.executeAsync();
    }

    public void destroy() {
        this.unregisterScreenStateReceiver();
        this.cancelRefresh("destroy");
    }

    public void onWindowVisibilityChanged(int visibility) {
        this.currentVisibility = visibility;
        if (visibility == 0) {
            if (this.initialLoadFinished) {
                this.scheduleRefresh("onWindowVisibilityChanged");
            }
        } else {
            this.cancelRefresh("onWindowVisibilityChanged");
        }
    }

    private boolean isNetworkConnected() {
        int result = this.context.checkCallingOrSelfPermission(ANDROID_PERMISSION_ACCESS_NETWORK_STATE);
        if (result != 0) {
            return true;
        }
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnected();
    }

    private class ScreenStateReceiver
    extends BroadcastReceiver {
        private ScreenStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(action)) {
                AdRequestController.this.cancelRefresh(intent.getAction());
            } else if ("android.intent.action.SCREEN_ON".equals(action) && AdRequestController.this.currentVisibility == 0) {
                AdRequestController.this.scheduleRefresh(intent.getAction());
            }
        }
    }
}

