/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Build;
import android.util.DisplayMetrics;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.internal.AdAnalogData;
import com.facebook.ads.internal.AdClientEventManager;
import com.facebook.ads.internal.AdResponse;
import com.facebook.ads.internal.AdSdkCapability;
import com.facebook.ads.internal.AdType;
import com.facebook.ads.internal.AdUtilities;
import com.facebook.ads.internal.AdWebViewUtils;
import com.facebook.ads.internal.AdvertisingIdInfo;
import com.facebook.ads.internal.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRequest {
    private static final String TAG = AdRequest.class.getSimpleName();
    private static final String GRAPH_URL_BASE = "https://graph.facebook.com";
    private static final String GRAPH_URL_BASE_PREFIX_FORMAT = "http://graph.%s.facebook.com";
    private static final String ADS_ENDPOINT = "network_ads";
    private static final String NATIVE_ADS_ENDPOINT = "network_ads_native";
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final String OS = "Android";
    private static final String AD_TYPE_PARAM = "ad_type";
    private static final String SDK_CAPABILITIES_PARAM = "sdk_capabilities";
    private static final String SDK_VERSION = "sdk_version";
    private static final String PLACEMENT_ID_PARAM = "placement_id";
    private static final String ATTRIBUTION_ID_PARAM = "attribution_id";
    private static final String WIDTH_PARAM = "width";
    private static final String HEIGHT_PARAM = "height";
    private static final String TEST_MODE_PARAM = "test_mode";
    private static final String DEVICE_ID_PARAM = "device_id";
    private static final String DEVICE_ID_TRACKING_ENABLED_PARAM = "tracking_enabled";
    private static final String OS_PARAM = "os";
    private static final String OS_VERSION_PARAM = "os_version";
    private static final String SCREEN_WIDTH_PARAM = "screen_width";
    private static final String SCREEN_HEIGHT_PARAM = "screen_height";
    private static final String APP_BUILD_PARAM = "app_build";
    private static final String APP_VERSION_PARAM = "app_version";
    private static final String LOCALE_PARAM = "locale";
    private static final String CHILD_DIRECTED_PARAM = "child_directed";
    private static final String PACKAGE_NAME_PARAM = "package_name";
    private static final String CLIENT_EVENTS_PARAM = "events";
    private static final int AD_REQUEST_TIMEOUT_MS = 30000;
    private final Context context;
    private final String placementId;
    private final AdSize adSize;
    private final String userAgentString;
    private final Callback callback;
    private final AdType adType;
    private final boolean testMode;

    public AdRequest(Context context, String placementId, AdSize adSize, AdType adType, boolean testMode, Callback callback) {
        if (placementId == null || placementId.length() < 1) {
            throw new IllegalArgumentException("placementId");
        }
        if (adSize == null) {
            throw new IllegalArgumentException("adSize");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        this.context = context;
        this.placementId = placementId;
        this.adSize = adSize;
        this.userAgentString = AdWebViewUtils.getUserAgentString(context);
        this.adType = adType;
        this.testMode = testMode;
        this.callback = callback;
    }

    private String getAdsEndpoint() {
        switch (this.adType) {
            case NATIVE: {
                return NATIVE_ADS_ENDPOINT;
            }
        }
        return ADS_ENDPOINT;
    }

    public AsyncTask executeAsync() {
        AdAnalogData.startUpdate(this.context);
        AsyncTask<Void, Void, AdRequestResponse> asyncTask = new AsyncTask<Void, Void, AdRequestResponse>(){

            protected AdRequestResponse doInBackground(Void ... params) {
                return AdRequest.this.executeConnectionAndWait();
            }

            protected void onPostExecute(AdRequestResponse response) {
                if (response == null) {
                    AdRequest.this.callback.onError(AdError.INTERNAL_ERROR);
                } else if (response.error != null) {
                    AdRequest.this.callback.onError(response.error);
                } else {
                    AdResponse adResponse = AdResponse.parseResponse(AdRequest.this.context, response.body);
                    AdRequest.this.callback.onCompleted(adResponse);
                }
            }
        };
        return asyncTask.execute((Object[])new Void[0]);
    }

    private Map<String, Object> getRequestParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AdUtilities.Fb4aData fb4aData = AdUtilities.getFb4aData(this.context.getContentResolver());
        params.put(AD_TYPE_PARAM, this.adType.getValue());
        params.put(SDK_CAPABILITIES_PARAM, AdSdkCapability.getSupportedCapabilitiesAsJSONString());
        params.put(SDK_VERSION, "3.17.2");
        params.put(PLACEMENT_ID_PARAM, this.placementId);
        params.put(ATTRIBUTION_ID_PARAM, fb4aData.attributionId);
        params.put(WIDTH_PARAM, this.adSize.getWidth());
        params.put(HEIGHT_PARAM, this.adSize.getHeight());
        params.put(TEST_MODE_PARAM, this.testMode);
        params.put(CHILD_DIRECTED_PARAM, AdSettings.isChildDirected());
        params.put(CLIENT_EVENTS_PARAM, AdClientEventManager.dumpClientEventToJson());
        this.addDeviceInfoParams(params);
        this.addAppInfoParams(params);
        this.addAdvertisingInfoParams(params, fb4aData);
        return params;
    }

    private void addDeviceInfoParams(Map<String, Object> params) {
        params.put(OS_PARAM, OS);
        params.put(OS_VERSION_PARAM, Build.VERSION.RELEASE);
        DisplayMetrics metrics = this.context.getResources().getDisplayMetrics();
        int screenWidth = (int)((float)metrics.widthPixels / metrics.density);
        int screenHeight = (int)((float)metrics.heightPixels / metrics.density);
        params.put(SCREEN_WIDTH_PARAM, screenWidth);
        params.put(SCREEN_HEIGHT_PARAM, screenHeight);
        try {
            PackageInfo pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            params.put(APP_BUILD_PARAM, pInfo.versionCode);
            params.put(APP_VERSION_PARAM, pInfo.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            params.put(APP_VERSION_PARAM, 0);
        }
        Locale locale = this.context.getResources().getConfiguration().locale;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        params.put(LOCALE_PARAM, locale.toString());
    }

    private void addAdvertisingInfoParams(Map<String, Object> params, AdUtilities.Fb4aData fb4aData) {
        AdvertisingIdInfo advertisingIdInfo = AdvertisingIdInfo.getAdvertisingIdInfo(this.context, fb4aData);
        if (advertisingIdInfo == null) {
            params.put(DEVICE_ID_TRACKING_ENABLED_PARAM, true);
            return;
        }
        params.put(DEVICE_ID_TRACKING_ENABLED_PARAM, !advertisingIdInfo.isLimitAdTrackingEnabled());
        if (!advertisingIdInfo.isLimitAdTrackingEnabled()) {
            params.put(DEVICE_ID_PARAM, advertisingIdInfo.getId());
        }
    }

    private void addAppInfoParams(Map<String, Object> params) {
        params.put(PACKAGE_NAME_PARAM, this.context.getPackageName());
    }

    private URL getUrlForRequest() throws MalformedURLException {
        String urlPrefix = AdSettings.getUrlPrefix();
        String urlBase = StringUtils.isNullOrEmpty(urlPrefix) ? GRAPH_URL_BASE : String.format(GRAPH_URL_BASE_PREFIX_FORMAT, urlPrefix);
        return new URL(String.format("%s/%s", urlBase, this.getAdsEndpoint()));
    }

    private String getQueryString(Map<String, Object> params) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(512);
        boolean first = true;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(URLEncoder.encode(entry.getKey(), DEFAULT_ENCODING)).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), DEFAULT_ENCODING));
        }
        return sb.toString();
    }

    private HttpURLConnection makeRequest() throws IOException {
        URL url = this.getUrlForRequest();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", this.userAgentString);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        Map<String, Object> params = this.getRequestParameters();
        String queryString = this.getQueryString(params);
        BufferedOutputStream outputStream = new BufferedOutputStream(connection.getOutputStream());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, DEFAULT_ENCODING));
        writer.write(queryString);
        writer.flush();
        writer.close();
        ((OutputStream)outputStream).close();
        connection.connect();
        return connection;
    }

    /*
     * Exception decompiling
     */
    public AdRequestResponse executeConnectionAndWait() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AdRequestResponse createResponsesFromStream(InputStream stream) {
        AdRequestResponse response = new AdRequestResponse();
        try {
            String responseString = AdUtilities.readStreamToString(stream);
            JSONTokener tokener = new JSONTokener(responseString);
            Object resultObject = tokener.nextValue();
            if (resultObject instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)resultObject;
                if (jsonObject.has("error")) {
                    JSONObject error = (JSONObject)AdUtilities.getStringPropertyAsJSON(jsonObject, "error");
                    int errorCode = error.optInt("code", -1);
                    String errorMessage = error.optString("message", null);
                    response.error = new AdError(errorCode, errorMessage);
                } else {
                    response.body = jsonObject;
                    response.error = null;
                }
            }
        }
        catch (Exception ex) {
            response.error = new AdError(-1, ex.getMessage());
        }
        if (response.body == null && response.error == null) {
            return null;
        }
        return response;
    }

    private static class AdRequestResponse {
        JSONObject body = null;
        AdError error = null;

        private AdRequestResponse() {
        }
    }

    public static interface Callback {
        public void onCompleted(AdResponse var1);

        public void onError(AdError var1);
    }
}

