/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.facebook.ads.InterstitialAdActivity;
import com.facebook.ads.internal.HtmlAdDataModel;
import com.facebook.ads.internal.action.AdActionFactory;
import com.facebook.ads.internal.action.AppAdAction;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoAdActivity
extends Activity {
    public static final String URI_INTENT_EXTRA = "adUri";
    public static final String VIDEO_PATH_INTENT_EXTRA = "adVideoPath";
    public static final String MARKET_URI_INTENT_EXTRA = "adMarketUri";
    private static final long CONTROLS_FADE_DELAY = 3000L;
    private VideoView mVideoView;
    private View mRootView;
    private ImageButton mInstallButton;
    private ImageButton mSkipButton;
    private ImageButton mMuteButton;
    private ImageButton mCloseButton;
    private PlayerState mState;
    private boolean mIsMuted = false;
    private MediaPlayer mMediaPlayer;
    private long mTimeOfLastTouch;
    private int mCurrentPosition = -1;
    private Handler mHandler = new Handler();
    private boolean mGoToAppStore = false;
    private RelativeLayout relativeLayout;
    private Uri uri;
    private Uri marketUri;
    private String path;
    private String uniqueId;
    private List<ImageButton> mAllControls;
    private List<ImageButton> mFullPlayingControls;
    private List<ImageButton> mMinPlayingControls;
    private List<ImageButton> mPausedControls;
    private List<ImageButton> mEndControls;
    private List<ImageButton> mBufferingView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.relativeLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        lp.addRule(15);
        this.setContentView((View)this.relativeLayout, (ViewGroup.LayoutParams)lp);
        this.mVideoView = new VideoView((Context)this);
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.relativeLayout.addView((View)this.mVideoView);
        this.mRootView = new View((Context)this);
        this.mInstallButton = new ImageButton((Context)this);
        this.mSkipButton = new ImageButton((Context)this);
        this.mMuteButton = new ImageButton((Context)this);
        this.mCloseButton = new ImageButton((Context)this);
        this.getIntentExtras();
        this.setVolumeControlStream(3);
        this.configureViews();
        this.bindModel();
        this.setButtonPosition();
        this.configureLayout();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ViewTreeObserver observer = this.mRootView.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                VideoAdActivity.this.mRootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                VideoAdActivity.this.updateVideoPlayerSize();
            }
        });
    }

    protected void onPause() {
        super.onPause();
        this.videoBackground();
    }

    protected void onResume() {
        super.onResume();
        if (this.mState == PlayerState.PLAYING && !this.mVideoView.isPlaying()) {
            this.mVideoView.seekTo(this.mCurrentPosition);
            this.mVideoView.start();
        }
        this.pulseControlsFromTouch();
    }

    protected void onStop() {
        super.onStop();
        this.videoBackground();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mGoToAppStore) {
            AppAdAction adAction = (AppAdAction)AdActionFactory.getAdAction((Context)this, this.uri);
            adAction.goToMarketURL();
        }
    }

    private void getIntentExtras() {
        Bundle extra = this.getIntent().getExtras();
        this.uri = Uri.parse((String)extra.getString(URI_INTENT_EXTRA));
        this.marketUri = Uri.parse((String)extra.getString(MARKET_URI_INTENT_EXTRA));
        this.path = extra.getString(VIDEO_PATH_INTENT_EXTRA);
        this.uniqueId = extra.getString("adInterstitialUniqueId");
    }

    private void configureViews() {
        this.mAllControls = Arrays.asList(this.mInstallButton, this.mMuteButton, this.mCloseButton, this.mSkipButton);
        this.mFullPlayingControls = Arrays.asList(this.mInstallButton, this.mMuteButton, this.mCloseButton, this.mSkipButton);
        this.mMinPlayingControls = Arrays.asList(this.mCloseButton, this.mInstallButton, this.mSkipButton);
        this.mPausedControls = Arrays.asList(this.mInstallButton, this.mMuteButton, this.mCloseButton, this.mSkipButton);
        this.mEndControls = Arrays.asList(this.mInstallButton, this.mMuteButton, this.mCloseButton, this.mSkipButton);
        this.mBufferingView = Arrays.asList(this.mInstallButton, this.mCloseButton, this.mSkipButton);
        View.OnTouchListener dimmerListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    v.setAlpha(0.5f);
                } else if (event.getAction() == 1) {
                    v.setAlpha(1.0f);
                }
                return false;
            }
        };
        this.mInstallButton.setOnTouchListener(dimmerListener);
        this.mSkipButton.setOnTouchListener(dimmerListener);
        this.mMuteButton.setOnTouchListener(dimmerListener);
        this.mCloseButton.setOnTouchListener(dimmerListener);
        this.mInstallButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoAdActivity.this.mGoToAppStore = true;
                VideoAdActivity.this.finish();
            }
        });
        this.mSkipButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoAdActivity.this.displayInterstitial();
            }
        });
        this.mMuteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoAdActivity.this.videoMute();
            }
        });
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoAdActivity.this.finish();
            }
        });
        this.mRootView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                VideoAdActivity.this.pulseControlsFromTouch();
                return false;
            }
        });
        this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                VideoAdActivity.this.mMediaPlayer = mp;
                if (VideoAdActivity.this.mIsMuted) {
                    VideoAdActivity.this.mMediaPlayer.setVolume(0.0f, 0.0f);
                } else {
                    VideoAdActivity.this.mMediaPlayer.setVolume(1.0f, 1.0f);
                }
                VideoAdActivity.this.updateVideoPlayerSize();
                if (VideoAdActivity.this.mState == PlayerState.PAUSED || VideoAdActivity.this.mState == PlayerState.COMPLETED) {
                    VideoAdActivity.this.mMediaPlayer.seekTo(VideoAdActivity.this.mCurrentPosition);
                } else if (VideoAdActivity.this.mState == PlayerState.PLAYING) {
                    VideoAdActivity.this.mMediaPlayer.seekTo(VideoAdActivity.this.mCurrentPosition);
                    VideoAdActivity.this.videoPlay();
                } else if (VideoAdActivity.this.mState == PlayerState.UNINITIALIZED) {
                    VideoAdActivity.this.setState(PlayerState.INITIALIZED);
                    VideoAdActivity.this.videoPlay();
                }
            }
        });
        this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                VideoAdActivity.this.setState(PlayerState.COMPLETED);
                VideoAdActivity.this.displayInterstitial();
            }
        });
        this.mVideoView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                VideoAdActivity.this.pulseControlsFromTouch();
                return false;
            }
        });
    }

    private void displayInterstitial() {
        Intent intent = new Intent((Context)this, InterstitialAdActivity.class);
        WindowManager wm = (WindowManager)this.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        intent.putExtra("displayRotation", display.getRotation());
        intent.putExtra("displayWidth", displayMetrics.widthPixels);
        intent.putExtra("displayHeight", displayMetrics.heightPixels);
        intent.putExtra("adInterstitialUniqueId", this.uniqueId);
        HtmlAdDataModel dataModel = HtmlAdDataModel.fromIntentExtra(this.getIntent());
        dataModel.addToIntentExtra(intent);
        this.startActivity(intent);
        this.finish();
    }

    private void bindModel() {
        this.setState(PlayerState.UNINITIALIZED);
        this.mInstallButton.setBackground(this.getResources().getDrawable(0x1080081));
        this.mSkipButton.setBackground(this.getResources().getDrawable(17301569));
        this.mMuteButton.setBackground(this.getResources().getDrawable(17301554));
        this.mCloseButton.setBackground(this.getResources().getDrawable(17301560));
        this.mVideoView.setVideoPath(this.path);
    }

    private void setButtonPosition() {
        this.mInstallButton.setX(270.0f);
        this.mInstallButton.setY(1400.0f);
        this.mSkipButton.setX(700.0f);
        this.mSkipButton.setY(1400.0f);
        this.mMuteButton.setX(10.0f);
        this.mMuteButton.setY(1160.0f);
        this.mCloseButton.setX(970.0f);
        this.mInstallButton.setScaleX(1.5f);
        this.mInstallButton.setScaleY(1.5f);
        this.mSkipButton.setScaleX(1.5f);
        this.mSkipButton.setScaleY(1.5f);
    }

    private void configureLayout() {
        this.relativeLayout.addView(this.mRootView);
        this.relativeLayout.addView((View)this.mInstallButton);
        this.relativeLayout.addView((View)this.mSkipButton);
        this.relativeLayout.addView((View)this.mMuteButton);
        this.relativeLayout.addView((View)this.mCloseButton);
    }

    private void updateVideoPlayerSize() {
        if (this.mMediaPlayer != null) {
            float scale = Math.min((float)this.mRootView.getWidth() / (float)this.mMediaPlayer.getVideoWidth(), (float)this.mRootView.getHeight() / (float)this.mMediaPlayer.getVideoHeight());
            int fitWidth = (int)((float)this.mMediaPlayer.getVideoWidth() * scale);
            int fitHeight = (int)((float)this.mMediaPlayer.getVideoHeight() * scale);
            this.mVideoView.getHolder().setFixedSize(fitWidth, fitHeight);
            this.mVideoView.requestLayout();
            this.mVideoView.invalidate();
        }
    }

    private void pulseControlsFromTouch() {
        this.mTimeOfLastTouch = System.currentTimeMillis();
        this.updateControlState();
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(new Runnable(){

            public void run() {
                VideoAdActivity.this.updateControlState();
            }
        }, 3000L);
    }

    private void activateControlSet(List<ImageButton> controls) {
        for (ImageButton button : this.mAllControls) {
            if (controls.contains(button)) {
                button.setVisibility(0);
                continue;
            }
            button.setVisibility(8);
        }
    }

    private void updateControlState() {
        this.mInstallButton.setAlpha(1.0f);
        this.mSkipButton.setAlpha(1.0f);
        this.mCloseButton.setAlpha(1.0f);
        this.mVideoView.setAlpha(1.0f);
        switch (this.mState) {
            case PLAYING: {
                if (System.currentTimeMillis() - this.mTimeOfLastTouch >= 3000L) {
                    this.activateControlSet(this.mMinPlayingControls);
                    this.mInstallButton.setAlpha(0.5f);
                    this.mSkipButton.setAlpha(0.5f);
                    this.mCloseButton.setAlpha(0.5f);
                    break;
                }
                this.activateControlSet(this.mFullPlayingControls);
                break;
            }
            case PAUSED: {
                this.activateControlSet(this.mPausedControls);
                break;
            }
            case UNINITIALIZED: {
                this.activateControlSet(this.mBufferingView);
                break;
            }
            case INITIALIZED: {
                this.activateControlSet(this.mBufferingView);
                break;
            }
            case COMPLETED: {
                this.activateControlSet(this.mEndControls);
                this.mMediaPlayer.seekTo((int)((float)this.mMediaPlayer.getDuration() * 0.75f));
                this.mVideoView.setAlpha(1.0f);
                break;
            }
        }
    }

    private void setState(PlayerState state) {
        if (state != this.mState) {
            this.mState = state;
            this.pulseControlsFromTouch();
        }
    }

    private void videoBackground() {
        if (this.mVideoView.isPlaying()) {
            this.mCurrentPosition = this.mVideoView.getCurrentPosition();
        }
        this.mVideoView.pause();
        this.mHandler.removeCallbacksAndMessages(null);
        this.mMediaPlayer = null;
    }

    private void videoPlay() {
        if (this.mState != PlayerState.UNINITIALIZED && this.mState != PlayerState.PLAYING) {
            if (this.mState == PlayerState.COMPLETED) {
                this.mVideoView.seekTo(0);
            }
            this.mVideoView.start();
            this.mCurrentPosition = this.mVideoView.getCurrentPosition();
            this.setState(PlayerState.PLAYING);
        }
    }

    private void videoMute() {
        if (this.mState != PlayerState.UNINITIALIZED) {
            if (this.mIsMuted) {
                this.mMediaPlayer.setVolume(1.0f, 1.0f);
                this.mMuteButton.setBackground(this.getResources().getDrawable(17301554));
            } else {
                this.mMediaPlayer.setVolume(0.0f, 0.0f);
                this.mMuteButton.setBackground(this.getResources().getDrawable(17301553));
            }
            this.mIsMuted = !this.mIsMuted;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PlayerState {
        UNINITIALIZED,
        INITIALIZED,
        PLAYING,
        PAUSED,
        COMPLETED;

    }
}

