/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.internal.AdClientEvent;
import com.facebook.ads.internal.AdClientEventManager;
import com.facebook.ads.internal.AdHandler;
import com.facebook.ads.internal.AdRequest;
import com.facebook.ads.internal.AdRequestController;
import com.facebook.ads.internal.AdResponse;
import com.facebook.ads.internal.AdType;
import com.facebook.ads.internal.DownloadImageTask;
import com.facebook.ads.internal.NativeAdDataModel;
import com.facebook.ads.internal.NativeAdHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeAd
implements Ad {
    private static final String TAG = NativeAd.class.getSimpleName();
    private final Context context;
    private AdRequestController adRequestController;
    private AdListener adListener;
    private volatile boolean loadRequested;
    private boolean adLoaded;
    private NativeAdDataModel adDataModel;
    private View adView;
    private List<View> clickListeners;
    private NativeAdHandler handler;
    private EventHandler eventHandler;
    private int viewabilityThreshold;
    private static WeakHashMap<View, WeakReference<NativeAd>> viewMapping = new WeakHashMap();

    public NativeAd(Context context, String placementId) {
        this.context = context;
        this.clickListeners = new ArrayList<View>();
        this.adRequestController = new AdRequestController(this.context, placementId, AdSize.INTERSTITIAL, false, AdType.NATIVE, new AdRequest.Callback(){

            public void onCompleted(AdResponse adResponse) {
                if (adResponse.getDataModel() != null && !(adResponse.getDataModel() instanceof NativeAdDataModel)) {
                    if (NativeAd.this.adListener != null) {
                        NativeAd.this.adListener.onError(NativeAd.this, AdError.INTERNAL_ERROR);
                    }
                    return;
                }
                NativeAd.this.adDataModel = (NativeAdDataModel)adResponse.getDataModel();
                if (NativeAd.this.adDataModel != null && NativeAd.this.adDataModel.isValid()) {
                    NativeAd.this.adLoaded = true;
                    if (NativeAd.this.adListener != null) {
                        NativeAd.this.adListener.onAdLoaded(NativeAd.this);
                    }
                    NativeAd.this.viewabilityThreshold = adResponse.getViewabilityThreshold();
                } else if (NativeAd.this.adDataModel == null) {
                    NativeAd.this.adLoaded = false;
                    if (NativeAd.this.adListener != null) {
                        NativeAd.this.adListener.onError(NativeAd.this, adResponse.getError() != null ? adResponse.getError() : AdError.INTERNAL_ERROR);
                    }
                } else {
                    NativeAd.this.adLoaded = false;
                    NativeAd.this.adDataModel = null;
                    if (NativeAd.this.adListener != null) {
                        NativeAd.this.adListener.onError(NativeAd.this, AdError.MISSING_PROPERTIES);
                    }
                }
            }

            public void onError(AdError error) {
                NativeAd.this.adLoaded = false;
                if (NativeAd.this.adListener != null) {
                    NativeAd.this.adListener.onError(NativeAd.this, error);
                }
            }
        });
    }

    private void ensureAdRequestController() {
        if (this.adRequestController == null) {
            RuntimeException ex = new RuntimeException("No request controller available, has the NativeAd been destroyed?");
            AdClientEventManager.addClientEvent(AdClientEvent.newErrorEvent(ex));
            throw ex;
        }
    }

    public void setAdListener(AdListener adListener) {
        this.adListener = adListener;
    }

    @Override
    public void loadAd() {
        if (this.loadRequested) {
            IllegalStateException ex = new IllegalStateException("Ad already loaded");
            AdClientEventManager.addClientEvent(AdClientEvent.newErrorEvent(ex));
            throw ex;
        }
        this.loadRequested = true;
        this.ensureAdRequestController();
        this.adRequestController.loadAd();
    }

    @Override
    public void destroy() {
        if (this.adRequestController != null) {
            this.adRequestController.destroy();
            this.adRequestController = null;
        }
        this.detachListeners();
        if (this.handler != null) {
            this.handler.cancelImpressionRetry();
            this.handler = null;
        }
        if (this.adView != null) {
            viewMapping.remove(this.adView);
            this.adView = null;
        }
    }

    public boolean isAdLoaded() {
        return this.adLoaded;
    }

    public Image getAdIcon() {
        if (!this.adLoaded) {
            return null;
        }
        return this.adDataModel.getIcon();
    }

    public Image getAdCoverImage() {
        if (!this.adLoaded) {
            return null;
        }
        return this.adDataModel.getImage();
    }

    public String getAdTitle() {
        if (!this.adLoaded) {
            return null;
        }
        return this.adDataModel.getTitle();
    }

    public String getAdBody() {
        if (!this.adLoaded) {
            return null;
        }
        return this.adDataModel.getBody();
    }

    public String getAdCallToAction() {
        if (!this.adLoaded) {
            return null;
        }
        return this.adDataModel.getCallToAction();
    }

    public String getAdSocialContext() {
        if (!this.adLoaded) {
            return null;
        }
        return this.adDataModel.getSocialContext();
    }

    public Rating getAdStarRating() {
        if (!this.adLoaded) {
            return null;
        }
        return this.adDataModel.getStarRating();
    }

    public static void downloadAndDisplayImage(Image image, ImageView imageView) {
        new DownloadImageTask(imageView).execute(new String[]{image.getUrl()});
    }

    public void registerViewForInteraction(View view) {
        ArrayList<View> clickableViews = new ArrayList<View>();
        this.collectAllSubviews(clickableViews, view);
        this.registerViewForInteraction(view, clickableViews);
    }

    private void collectAllSubviews(List<View> subviews, View v) {
        subviews.add(v);
        if (v instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)v;
            for (int i = 0; i < vg.getChildCount(); ++i) {
                this.collectAllSubviews(subviews, vg.getChildAt(i));
            }
        }
    }

    public void registerViewForInteraction(View view, List<View> clickableViews) {
        if (view == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Must provide a View");
            AdClientEventManager.addClientEvent(AdClientEvent.newErrorEvent(ex));
            throw ex;
        }
        if (clickableViews == null || clickableViews.size() == 0) {
            IllegalArgumentException ex = new IllegalArgumentException("Invalid set of clickable views");
            AdClientEventManager.addClientEvent(AdClientEvent.newErrorEvent(ex));
            throw ex;
        }
        if (!this.adLoaded) {
            Log.e((String)TAG, (String)"Ad not loaded");
            return;
        }
        if (this.adView != null) {
            Log.w((String)TAG, (String)"Native Ad was already registered with a View. Auto unregistering and proceeding.");
            this.unregisterView();
        }
        if (viewMapping.containsKey(view)) {
            Log.w((String)TAG, (String)"View already registered with a NativeAd. Auto unregistering and proceeding.");
            ((NativeAd)viewMapping.get(view).get()).unregisterView();
        }
        this.eventHandler = new EventHandler();
        this.adView = view;
        for (View v : clickableViews) {
            this.addListener(v);
        }
        this.handler = new NativeAdHandler(new AdHandler.ImpressionHelper(){

            public boolean shouldSendImpression() {
                return NativeAd.this.isViewOnScreen();
            }

            public void afterImpressionSent() {
            }
        }, 1000L, this.adDataModel, this.context);
        this.handler.trySendImpression();
        viewMapping.put(view, new WeakReference<NativeAd>(this));
    }

    private void addListener(View v) {
        this.clickListeners.add(v);
        v.setOnClickListener((View.OnClickListener)this.eventHandler);
        v.setOnTouchListener((View.OnTouchListener)this.eventHandler);
    }

    public void unregisterView() {
        if (this.adView == null) {
            return;
        }
        if (!viewMapping.containsKey(this.adView) || viewMapping.get(this.adView).get() != this) {
            IllegalStateException ex = new IllegalStateException("View not registered with this NativeAd");
            AdClientEventManager.addClientEvent(AdClientEvent.newErrorEvent(ex));
            throw ex;
        }
        viewMapping.remove(this.adView);
        this.detachListeners();
        this.handler.cancelImpressionRetry();
        this.handler = null;
        this.adView = null;
    }

    private void detachListeners() {
        for (View v : this.clickListeners) {
            v.setOnClickListener(null);
            v.setOnTouchListener(null);
        }
        this.clickListeners.clear();
    }

    private boolean isValidAlpha() {
        if (Build.VERSION.SDK_INT >= 11) {
            return this.adView.getAlpha() > 0.9f;
        }
        return true;
    }

    private boolean isViewOnScreen() {
        double totalArea;
        if (this.adView == null || !this.adLoaded || this.adView.getVisibility() != 0 || this.adView.getParent() == null || !this.isValidAlpha()) {
            return false;
        }
        Rect visibleRect = new Rect();
        if (!this.adView.getGlobalVisibleRect(visibleRect)) {
            return false;
        }
        double visibleArea = visibleRect.width() * visibleRect.height();
        return visibleArea >= (totalArea = (double)(this.adView.getWidth() * this.adView.getHeight())) * (double)this.viewabilityThreshold / 100.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventHandler
    implements View.OnClickListener,
    View.OnTouchListener {
        private int xCoord;
        private int yCoord;
        private int width;
        private int height;
        private float adPositionX;
        private float adPositionY;
        private int visibleHeight;
        private int visibleWidth;
        private boolean touchDataInitialized;

        private EventHandler() {
        }

        public void onClick(View v) {
            if (NativeAd.this.adListener != null) {
                NativeAd.this.adListener.onAdClicked(NativeAd.this);
            }
            if (!this.touchDataInitialized) {
                Log.e((String)"FBAudienceNetworkLog", (String)"No touch data recorded, please ensure touch events reach the ad View by returning false if you intercept the event.");
            }
            NativeAd.this.adDataModel.handleClick(NativeAd.this.context, this.getData());
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (!this.touchDataInitialized && event.getAction() == 0 && NativeAd.this.adView != null) {
                this.width = NativeAd.this.adView.getWidth();
                this.height = NativeAd.this.adView.getHeight();
                int[] adViewLocation = new int[2];
                NativeAd.this.adView.getLocationInWindow(adViewLocation);
                this.adPositionX = adViewLocation[0];
                this.adPositionY = adViewLocation[1];
                Rect visibleRect = new Rect();
                NativeAd.this.adView.getGlobalVisibleRect(visibleRect);
                this.visibleWidth = visibleRect.width();
                this.visibleHeight = visibleRect.height();
                int[] clickViewLocation = new int[2];
                v.getLocationInWindow(clickViewLocation);
                this.xCoord = (int)event.getX() + clickViewLocation[0] - adViewLocation[0];
                this.yCoord = (int)event.getY() + clickViewLocation[1] - adViewLocation[1];
                this.touchDataInitialized = true;
            }
            return false;
        }

        public Map<String, Object> getData() {
            HashMap<String, Object> touchData = new HashMap<String, Object>();
            touchData.put("clickX", this.xCoord);
            touchData.put("clickY", this.yCoord);
            touchData.put("width", this.width);
            touchData.put("height", this.height);
            touchData.put("adPositionX", Float.valueOf(this.adPositionX));
            touchData.put("adPositionY", Float.valueOf(this.adPositionY));
            touchData.put("visibleWidth", this.visibleWidth);
            touchData.put("visibleHeight", this.visibleHeight);
            return touchData;
        }
    }

    public static class Rating {
        private final double value;
        private final double scale;

        private Rating(double value, double scale) {
            this.value = value;
            this.scale = scale;
        }

        public double getValue() {
            return this.value;
        }

        public double getScale() {
            return this.scale;
        }

        public static Rating fromJSONObject(JSONObject dataObject) {
            if (dataObject == null) {
                return null;
            }
            double value = dataObject.optDouble("value", 0.0);
            double scale = dataObject.optDouble("scale", 0.0);
            if (value == 0.0 || scale == 0.0) {
                return null;
            }
            return new Rating(value, scale);
        }
    }

    public static class Image {
        private final String url;
        private final int width;
        private final int height;

        private Image(String url, int width, int height) {
            this.url = url;
            this.width = width;
            this.height = height;
        }

        public String getUrl() {
            return this.url;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static Image fromJSONObject(JSONObject dataObject) {
            if (dataObject == null) {
                return null;
            }
            String url = dataObject.optString("url");
            if (url == null) {
                return null;
            }
            int width = dataObject.optInt("width", 0);
            int height = dataObject.optInt("height", 0);
            return new Image(url, width, height);
        }
    }
}

