/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSize;
import com.facebook.ads.InterstitialAdActivity;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.internal.AdRequest;
import com.facebook.ads.internal.AdRequestController;
import com.facebook.ads.internal.AdResponse;
import com.facebook.ads.internal.AdType;
import com.facebook.ads.internal.HtmlAdDataModel;
import java.util.UUID;

public class InterstitialAd
implements Ad {
    public static final String INTERSTITIAL_DISPLAYED = "com.facebook.ads.interstitial.displayed";
    public static final String INTERSTITIAL_DISMISSED = "com.facebook.ads.interstitial.dismissed";
    public static final String INTERSTITIAL_CLICKED = "com.facebook.ads.interstitial.clicked";
    public static final String INTERSTITIAL_UNIQUE_ID_EXTRA = "adInterstitialUniqueId";
    public static final String DISPLAY_ROTATION_INTENT_EXTRA = "displayRotation";
    public static final String DISPLAY_WIDTH_INTENT_EXTRA = "displayWidth";
    public static final String DISPLAY_HEIGHT_INTENT_EXTRA = "displayHeight";
    private final Context context;
    private final String uniqueId;
    private AdRequestController adRequestController;
    private final AdInterstitialBroadcastReceiver broadcastReceiver;
    private InterstitialAdListener adListener;
    private boolean adLoaded = false;
    private AdResponse adResponse;

    public InterstitialAd(Context context, String placementId) {
        this.context = context;
        this.uniqueId = UUID.randomUUID().toString();
        this.adRequestController = new AdRequestController(this.context, placementId, AdSize.INTERSTITIAL, false, AdType.HTML, new AdRequest.Callback(){

            public void onCompleted(AdResponse adResponse) {
                InterstitialAd.this.adResponse = adResponse;
                if (adResponse.getDataModel() != null && adResponse.getDataModel() instanceof HtmlAdDataModel) {
                    InterstitialAd.this.adLoaded = true;
                    if (InterstitialAd.this.adListener != null) {
                        InterstitialAd.this.adListener.onAdLoaded(InterstitialAd.this);
                    }
                } else if (adResponse.getDataModel() == null) {
                    InterstitialAd.this.adLoaded = false;
                    if (InterstitialAd.this.adListener != null) {
                        InterstitialAd.this.adListener.onError(InterstitialAd.this, adResponse.getError() != null ? adResponse.getError() : AdError.INTERNAL_ERROR);
                    }
                } else {
                    InterstitialAd.this.adLoaded = false;
                    if (InterstitialAd.this.adListener != null) {
                        InterstitialAd.this.adListener.onError(InterstitialAd.this, AdError.INTERNAL_ERROR);
                    }
                }
            }

            public void onError(AdError error) {
                InterstitialAd.this.adLoaded = false;
                if (InterstitialAd.this.adListener != null) {
                    InterstitialAd.this.adListener.onError(InterstitialAd.this, error);
                }
            }
        });
        this.broadcastReceiver = new AdInterstitialBroadcastReceiver();
        this.broadcastReceiver.register();
    }

    private void ensureAdRequestController() {
        if (this.adRequestController == null) {
            throw new RuntimeException("No request controller available, has the InterstitialAd been destroyed?");
        }
    }

    public void setAdListener(InterstitialAdListener adListener) {
        this.adListener = adListener;
    }

    public void loadAd() {
        this.ensureAdRequestController();
        this.adLoaded = false;
        this.adRequestController.loadAd();
    }

    public void destroy() {
        if (this.adRequestController != null) {
            this.adRequestController.destroy();
            this.adRequestController = null;
            this.broadcastReceiver.unregister();
        }
    }

    public boolean isAdLoaded() {
        return this.adLoaded;
    }

    public boolean show() {
        if (!this.adLoaded) {
            if (this.adListener != null) {
                this.adListener.onError(this, AdError.INTERNAL_ERROR);
            }
            return false;
        }
        Intent intent = new Intent(this.context, InterstitialAdActivity.class);
        ((HtmlAdDataModel)this.adResponse.getDataModel()).addToIntentExtra(intent);
        this.adLoaded = false;
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        intent.putExtra(DISPLAY_ROTATION_INTENT_EXTRA, display.getRotation());
        intent.putExtra(DISPLAY_WIDTH_INTENT_EXTRA, displayMetrics.widthPixels);
        intent.putExtra(DISPLAY_HEIGHT_INTENT_EXTRA, displayMetrics.heightPixels);
        intent.putExtra(INTERSTITIAL_UNIQUE_ID_EXTRA, this.uniqueId);
        this.context.startActivity(intent);
        return true;
    }

    private class AdInterstitialBroadcastReceiver
    extends BroadcastReceiver {
        private AdInterstitialBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (InterstitialAd.this.adListener == null) {
                return;
            }
            String uniqueId = intent.getStringExtra(InterstitialAd.INTERSTITIAL_UNIQUE_ID_EXTRA);
            if (!InterstitialAd.this.uniqueId.equals(uniqueId)) {
                return;
            }
            String action = intent.getAction();
            if (InterstitialAd.INTERSTITIAL_CLICKED.equals(action)) {
                InterstitialAd.this.adListener.onAdClicked(InterstitialAd.this);
            } else if (InterstitialAd.INTERSTITIAL_DISMISSED.equals(action)) {
                InterstitialAd.this.adListener.onInterstitialDismissed(InterstitialAd.this);
            } else if (InterstitialAd.INTERSTITIAL_DISPLAYED.equals(action)) {
                InterstitialAd.this.adListener.onInterstitialDisplayed(InterstitialAd.this);
            }
        }

        public void register() {
            IntentFilter interstitialIntentFilter = new IntentFilter();
            interstitialIntentFilter.addAction(InterstitialAd.INTERSTITIAL_DISPLAYED);
            interstitialIntentFilter.addAction(InterstitialAd.INTERSTITIAL_DISMISSED);
            interstitialIntentFilter.addAction(InterstitialAd.INTERSTITIAL_CLICKED);
            LocalBroadcastManager.getInstance((Context)InterstitialAd.this.context).registerReceiver((BroadcastReceiver)this, interstitialIntentFilter);
        }

        public void unregister() {
            LocalBroadcastManager.getInstance((Context)InterstitialAd.this.context).unregisterReceiver((BroadcastReceiver)this);
        }
    }
}

