/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.node;

import com.flurry.org.codehaus.jackson.node.ArrayNode;
import com.flurry.org.codehaus.jackson.node.BigIntegerNode;
import com.flurry.org.codehaus.jackson.node.BinaryNode;
import com.flurry.org.codehaus.jackson.node.BooleanNode;
import com.flurry.org.codehaus.jackson.node.DecimalNode;
import com.flurry.org.codehaus.jackson.node.DoubleNode;
import com.flurry.org.codehaus.jackson.node.IntNode;
import com.flurry.org.codehaus.jackson.node.LongNode;
import com.flurry.org.codehaus.jackson.node.NullNode;
import com.flurry.org.codehaus.jackson.node.NumericNode;
import com.flurry.org.codehaus.jackson.node.ObjectNode;
import com.flurry.org.codehaus.jackson.node.POJONode;
import com.flurry.org.codehaus.jackson.node.TextNode;
import com.flurry.org.codehaus.jackson.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNodeFactory {
    public static final JsonNodeFactory instance = new JsonNodeFactory();

    protected JsonNodeFactory() {
    }

    public BooleanNode booleanNode(boolean v2) {
        return v2 ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    public NumericNode numberNode(byte v2) {
        return IntNode.valueOf(v2);
    }

    public ValueNode numberNode(Byte value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.intValue());
    }

    public NumericNode numberNode(short v2) {
        return IntNode.valueOf(v2);
    }

    public ValueNode numberNode(Short value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.shortValue());
    }

    public NumericNode numberNode(int v2) {
        return IntNode.valueOf(v2);
    }

    public ValueNode numberNode(Integer value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value);
    }

    public NumericNode numberNode(long v2) {
        return LongNode.valueOf(v2);
    }

    public ValueNode numberNode(Long value) {
        return value == null ? this.nullNode() : LongNode.valueOf(value);
    }

    public NumericNode numberNode(BigInteger v2) {
        return BigIntegerNode.valueOf(v2);
    }

    public NumericNode numberNode(float v2) {
        return DoubleNode.valueOf(v2);
    }

    public ValueNode numberNode(Float value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value.doubleValue());
    }

    public NumericNode numberNode(double v2) {
        return DoubleNode.valueOf(v2);
    }

    public ValueNode numberNode(Double value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value);
    }

    public NumericNode numberNode(BigDecimal v2) {
        return DecimalNode.valueOf(v2);
    }

    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return BinaryNode.valueOf(data, offset, length);
    }

    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    public POJONode POJONode(Object pojo) {
        return new POJONode(pojo);
    }
}

