/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.map.ser.std;

import com.flurry.org.codehaus.jackson.JsonGenerationException;
import com.flurry.org.codehaus.jackson.JsonGenerator;
import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.map.BeanProperty;
import com.flurry.org.codehaus.jackson.map.JsonMappingException;
import com.flurry.org.codehaus.jackson.map.JsonSerializer;
import com.flurry.org.codehaus.jackson.map.ResolvableSerializer;
import com.flurry.org.codehaus.jackson.map.SerializerProvider;
import com.flurry.org.codehaus.jackson.map.TypeSerializer;
import com.flurry.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import com.flurry.org.codehaus.jackson.map.ser.impl.PropertySerializerMap;
import com.flurry.org.codehaus.jackson.map.ser.std.ContainerSerializerBase;
import com.flurry.org.codehaus.jackson.map.ser.std.StdArraySerializers;
import com.flurry.org.codehaus.jackson.map.type.ArrayType;
import com.flurry.org.codehaus.jackson.node.ObjectNode;
import com.flurry.org.codehaus.jackson.schema.JsonSchema;
import com.flurry.org.codehaus.jackson.schema.SchemaAware;
import com.flurry.org.codehaus.jackson.type.JavaType;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class ObjectArraySerializer
extends StdArraySerializers.ArraySerializerBase<Object[]>
implements ResolvableSerializer {
    protected final boolean _staticTyping;
    protected final JavaType _elementType;
    protected JsonSerializer<Object> _elementSerializer;
    protected PropertySerializerMap _dynamicSerializers;

    @Deprecated
    public ObjectArraySerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
        this(elemType, staticTyping, vts, property, null);
    }

    public ObjectArraySerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property, JsonSerializer<Object> elementSerializer) {
        super(Object[].class, vts, property);
        this._elementType = elemType;
        this._staticTyping = staticTyping;
        this._dynamicSerializers = PropertySerializerMap.emptyMap();
        this._elementSerializer = elementSerializer;
    }

    @Override
    public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new ObjectArraySerializer(this._elementType, this._staticTyping, vts, this._property, this._elementSerializer);
    }

    @Override
    public void serializeContents(Object[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i2;
        int len = value.length;
        if (len == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(value, jgen, provider, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(value, jgen, provider);
            return;
        }
        Object elem = null;
        try {
            PropertySerializerMap serializers = this._dynamicSerializers;
            for (i2 = 0; i2 < len; ++i2) {
                elem = value[i2];
                if (elem == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                Class<?> cc2 = elem.getClass();
                JsonSerializer<Object> serializer = serializers.serializerFor(cc2);
                if (serializer == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._elementType, cc2), provider) : this._findAndAddDynamic(serializers, cc2, provider);
                }
                serializer.serialize(elem, jgen, provider);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e2) {
            Throwable t2 = e2;
            while (t2 instanceof InvocationTargetException && t2.getCause() != null) {
                t2 = t2.getCause();
            }
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
            throw JsonMappingException.wrapWithPath(t2, elem, i2);
        }
    }

    public void serializeContentsUsing(Object[] value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
        int i2;
        int len = value.length;
        TypeSerializer typeSer = this._valueTypeSerializer;
        Object elem = null;
        try {
            for (i2 = 0; i2 < len; ++i2) {
                elem = value[i2];
                if (elem == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                if (typeSer == null) {
                    ser.serialize(elem, jgen, provider);
                    continue;
                }
                ser.serializeWithType(elem, jgen, provider, typeSer);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e2) {
            Throwable t2 = e2;
            while (t2 instanceof InvocationTargetException && t2.getCause() != null) {
                t2 = t2.getCause();
            }
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
            throw JsonMappingException.wrapWithPath(t2, elem, i2);
        }
    }

    public void serializeTypedContents(Object[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i2;
        int len = value.length;
        TypeSerializer typeSer = this._valueTypeSerializer;
        Object elem = null;
        try {
            PropertySerializerMap serializers = this._dynamicSerializers;
            for (i2 = 0; i2 < len; ++i2) {
                elem = value[i2];
                if (elem == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                Class<?> cc2 = elem.getClass();
                JsonSerializer<Object> serializer = serializers.serializerFor(cc2);
                if (serializer == null) {
                    serializer = this._findAndAddDynamic(serializers, cc2, provider);
                }
                serializer.serializeWithType(elem, jgen, provider, typeSer);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e2) {
            Throwable t2 = e2;
            while (t2 instanceof InvocationTargetException && t2.getCause() != null) {
                t2 = t2.getCause();
            }
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
            throw JsonMappingException.wrapWithPath(t2, elem, i2);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        JavaType javaType;
        ObjectNode o2 = this.createSchemaNode("array", true);
        if (typeHint != null && (javaType = provider.constructType(typeHint)).isArrayType()) {
            Class<?> componentType = ((ArrayType)javaType).getContentType().getRawClass();
            if (componentType == Object.class) {
                o2.put("items", JsonSchema.getDefaultSchemaNode());
            } else {
                JsonSerializer<Object> ser = provider.findValueSerializer(componentType, this._property);
                JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, null) : JsonSchema.getDefaultSchemaNode();
                o2.put("items", schemaNode);
            }
        }
        return o2;
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._staticTyping && this._elementSerializer == null) {
            this._elementSerializer = provider.findValueSerializer(this._elementType, this._property);
        }
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, JavaType type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }
}

