/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.codehaus.jackson.map.deser.std;

import com.flurry.org.codehaus.jackson.JsonParser;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.map.DeserializationContext;
import com.flurry.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import com.flurry.org.codehaus.jackson.map.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class CalendarDeserializer
extends StdScalarDeserializer<Calendar> {
    protected final Class<? extends Calendar> _calendarClass;

    public CalendarDeserializer() {
        this((Class<? extends Calendar>)null);
    }

    public CalendarDeserializer(Class<? extends Calendar> cc2) {
        super(Calendar.class);
        this._calendarClass = cc2;
    }

    @Override
    public Calendar deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Date d2 = this._parseDate(jp, ctxt);
        if (d2 == null) {
            return null;
        }
        if (this._calendarClass == null) {
            return ctxt.constructCalendar(d2);
        }
        try {
            Calendar c2 = this._calendarClass.newInstance();
            c2.setTimeInMillis(d2.getTime());
            return c2;
        }
        catch (Exception e2) {
            throw ctxt.instantiationException(this._calendarClass, e2);
        }
    }
}

