/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.io.BinaryData;
import com.flurry.org.apache.avro.io.BinaryEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class DirectBinaryEncoder
extends BinaryEncoder {
    private OutputStream out;
    private final byte[] buf = new byte[12];

    DirectBinaryEncoder(OutputStream out) {
        this.configure(out);
    }

    DirectBinaryEncoder configure(OutputStream out) {
        if (null == out) {
            throw new NullPointerException("OutputStream cannot be null!");
        }
        this.out = out;
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void writeBoolean(boolean b2) throws IOException {
        this.out.write(b2 ? 1 : 0);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        int val = n2 << 1 ^ n2 >> 31;
        if ((val & 0xFFFFFF80) == 0) {
            this.out.write(val);
            return;
        }
        if ((val & 0xFFFFC000) == 0) {
            this.out.write(0x80 | val);
            this.out.write(val >>> 7);
            return;
        }
        int len = BinaryData.encodeInt(n2, this.buf, 0);
        this.out.write(this.buf, 0, len);
    }

    @Override
    public void writeLong(long n2) throws IOException {
        long val = n2 << 1 ^ n2 >> 63;
        if ((val & Integer.MIN_VALUE) == 0L) {
            int i2 = (int)val;
            while ((i2 & 0xFFFFFF80) != 0) {
                this.out.write((byte)((0x80 | i2) & 0xFF));
                i2 >>>= 7;
            }
            this.out.write((byte)i2);
            return;
        }
        int len = BinaryData.encodeLong(n2, this.buf, 0);
        this.out.write(this.buf, 0, len);
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        int len = BinaryData.encodeFloat(f2, this.buf, 0);
        this.out.write(this.buf, 0, len);
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        byte[] buf = new byte[8];
        int len = BinaryData.encodeDouble(d2, buf, 0);
        this.out.write(buf, 0, len);
    }

    @Override
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.out.write(bytes, start, len);
    }

    @Override
    protected void writeZero() throws IOException {
        this.out.write(0);
    }

    @Override
    public int bytesBuffered() {
        return 0;
    }
}

