/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.generic.GenericDatumReader;
import com.flurry.org.apache.avro.io.BinaryDecoder;
import com.flurry.org.apache.avro.io.Decoder;
import java.io.IOException;

public class BinaryData {
    private static final ThreadLocal<Decoders> DECODERS = new ThreadLocal<Decoders>(){

        @Override
        protected Decoders initialValue() {
            return new Decoders();
        }
    };
    private static final ThreadLocal<HashData> HASH_DATA = new ThreadLocal<HashData>(){

        @Override
        protected HashData initialValue() {
            return new HashData();
        }
    };

    private BinaryData() {
    }

    public static int compare(byte[] b1, int s1, byte[] b2, int s2, Schema schema) {
        return BinaryData.compare(b1, s1, b1.length - s1, b2, s2, b2.length - s2, schema);
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2, Schema schema) {
        Decoders decoders = DECODERS.get();
        decoders.set(b1, s1, l1, b2, s2, l2);
        try {
            return BinaryData.compare(decoders, schema);
        }
        catch (IOException e2) {
            throw new AvroRuntimeException(e2);
        }
    }

    private static int compare(Decoders d2, Schema schema) throws IOException {
        BinaryDecoder d1 = d2.d1;
        BinaryDecoder d22 = d2.d2;
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    if (field.order() == Schema.Field.Order.IGNORE) {
                        GenericDatumReader.skip(field.schema(), d1);
                        GenericDatumReader.skip(field.schema(), d22);
                        continue;
                    }
                    int c2 = BinaryData.compare(d2, field.schema());
                    if (c2 == 0) continue;
                    return field.order() != Schema.Field.Order.DESCENDING ? c2 : -c2;
                }
                return 0;
            }
            case ENUM: 
            case INT: {
                int i1 = ((Decoder)d1).readInt();
                int i2 = ((Decoder)d22).readInt();
                return i1 == i2 ? 0 : (i1 > i2 ? 1 : -1);
            }
            case LONG: {
                long l1 = ((Decoder)d1).readLong();
                long l2 = ((Decoder)d22).readLong();
                return l1 == l2 ? 0 : (l1 > l2 ? 1 : -1);
            }
            case ARRAY: {
                long i2 = 0L;
                long r1 = 0L;
                long r2 = 0L;
                long l1 = 0L;
                long l2 = 0L;
                block15: while (true) {
                    if (r1 == 0L) {
                        r1 = ((Decoder)d1).readLong();
                        if (r1 < 0L) {
                            r1 = -r1;
                            ((Decoder)d1).readLong();
                        }
                        l1 += r1;
                    }
                    if (r2 == 0L) {
                        r2 = ((Decoder)d22).readLong();
                        if (r2 < 0L) {
                            r2 = -r2;
                            ((Decoder)d22).readLong();
                        }
                        l2 += r2;
                    }
                    if (r1 == 0L || r2 == 0L) {
                        return l1 == l2 ? 0 : (l1 > l2 ? 1 : -1);
                    }
                    long l3 = Math.min(l1, l2);
                    while (true) {
                        if (i2 >= l3) continue block15;
                        int c3 = BinaryData.compare(d2, schema.getElementType());
                        if (c3 != 0) {
                            return c3;
                        }
                        ++i2;
                        --r1;
                        --r2;
                    }
                    break;
                }
            }
            case MAP: {
                throw new AvroRuntimeException("Can't compare maps!");
            }
            case UNION: {
                int i1 = ((Decoder)d1).readInt();
                int i2 = ((Decoder)d22).readInt();
                if (i1 == i2) {
                    return BinaryData.compare(d2, schema.getTypes().get(i1));
                }
                return i1 - i2;
            }
            case FIXED: {
                int size = schema.getFixedSize();
                int c4 = BinaryData.compareBytes(d2.b1.getBuf(), d2.b1.getPos(), size, d2.b2.getBuf(), d2.b2.getPos(), size);
                d2.d1.skipFixed(size);
                d2.d2.skipFixed(size);
                return c4;
            }
            case STRING: 
            case BYTES: {
                int l1 = ((Decoder)d1).readInt();
                int l2 = ((Decoder)d22).readInt();
                int c5 = BinaryData.compareBytes(d2.b1.getBuf(), d2.b1.getPos(), l1, d2.b2.getBuf(), d2.b2.getPos(), l2);
                d2.d1.skipFixed(l1);
                d2.d2.skipFixed(l2);
                return c5;
            }
            case FLOAT: {
                float f1 = ((Decoder)d1).readFloat();
                float f2 = ((Decoder)d22).readFloat();
                return f1 == f2 ? 0 : (f1 > f2 ? 1 : -1);
            }
            case DOUBLE: {
                double f1 = ((Decoder)d1).readDouble();
                double f2 = ((Decoder)d22).readDouble();
                return f1 == f2 ? 0 : (f1 > f2 ? 1 : -1);
            }
            case BOOLEAN: {
                boolean b1 = ((Decoder)d1).readBoolean();
                boolean b2 = ((Decoder)d22).readBoolean();
                return b1 == b2 ? 0 : (b1 ? 1 : -1);
            }
            case NULL: {
                return 0;
            }
        }
        throw new AvroRuntimeException("Unexpected schema to compare!");
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i2 = s1;
        for (int j2 = s2; i2 < end1 && j2 < end2; ++i2, ++j2) {
            int a2 = b1[i2] & 0xFF;
            int b3 = b2[j2] & 0xFF;
            if (a2 == b3) continue;
            return a2 - b3;
        }
        return l1 - l2;
    }

    public static int hashCode(byte[] bytes, int start, int length, Schema schema) {
        HashData data = HASH_DATA.get();
        data.set(bytes, start, length);
        try {
            return BinaryData.hashCode(data, schema);
        }
        catch (IOException e2) {
            throw new AvroRuntimeException(e2);
        }
    }

    private static int hashCode(HashData data, Schema schema) throws IOException {
        BinaryDecoder decoder = data.decoder;
        switch (schema.getType()) {
            case RECORD: {
                int hashCode = 1;
                for (Schema.Field field : schema.getFields()) {
                    if (field.order() == Schema.Field.Order.IGNORE) {
                        GenericDatumReader.skip(field.schema(), decoder);
                        continue;
                    }
                    hashCode = hashCode * 31 + BinaryData.hashCode(data, field.schema());
                }
                return hashCode;
            }
            case ENUM: 
            case INT: {
                return ((Decoder)decoder).readInt();
            }
            case FLOAT: {
                return Float.floatToIntBits(((Decoder)decoder).readFloat());
            }
            case LONG: {
                long l2 = ((Decoder)decoder).readLong();
                return (int)(l2 ^ l2 >>> 32);
            }
            case DOUBLE: {
                long l3 = Double.doubleToLongBits(((Decoder)decoder).readDouble());
                return (int)(l3 ^ l3 >>> 32);
            }
            case ARRAY: {
                Schema elementType = schema.getElementType();
                int hashCode = 1;
                long l4 = ((Decoder)decoder).readArrayStart();
                while (l4 != 0L) {
                    for (long i2 = 0L; i2 < l4; ++i2) {
                        hashCode = hashCode * 31 + BinaryData.hashCode(data, elementType);
                    }
                    l4 = ((Decoder)decoder).arrayNext();
                }
                return hashCode;
            }
            case MAP: {
                throw new AvroRuntimeException("Can't hashCode maps!");
            }
            case UNION: {
                return BinaryData.hashCode(data, schema.getTypes().get(((Decoder)decoder).readInt()));
            }
            case FIXED: {
                return BinaryData.hashBytes(1, data, schema.getFixedSize(), false);
            }
            case STRING: {
                return BinaryData.hashBytes(0, data, ((Decoder)decoder).readInt(), false);
            }
            case BYTES: {
                return BinaryData.hashBytes(1, data, ((Decoder)decoder).readInt(), true);
            }
            case BOOLEAN: {
                return ((Decoder)decoder).readBoolean() ? 1231 : 1237;
            }
            case NULL: {
                return 0;
            }
        }
        throw new AvroRuntimeException("Unexpected schema to hashCode!");
    }

    private static int hashBytes(int init, HashData data, int len, boolean rev) throws IOException {
        int hashCode = init;
        byte[] bytes = data.bytes.getBuf();
        int start = data.bytes.getPos();
        int end = start + len;
        if (rev) {
            for (int i2 = end - 1; i2 >= start; --i2) {
                hashCode = hashCode * 31 + bytes[i2];
            }
        } else {
            for (int i3 = start; i3 < end; ++i3) {
                hashCode = hashCode * 31 + bytes[i3];
            }
        }
        data.decoder.skipFixed(len);
        return hashCode;
    }

    public static int skipLong(byte[] bytes, int start) {
        int i2 = start;
        byte b2 = bytes[i2++];
        while ((b2 & 0x80) != 0) {
            b2 = bytes[i2++];
        }
        return i2;
    }

    public static int encodeBoolean(boolean b2, byte[] buf, int pos) {
        buf[pos] = b2 ? (byte)1 : 0;
        return 1;
    }

    public static int encodeInt(int n2, byte[] buf, int pos) {
        n2 = n2 << 1 ^ n2 >> 31;
        int start = pos;
        if ((n2 & 0xFFFFFF80) != 0) {
            buf[pos++] = (byte)((n2 | 0x80) & 0xFF);
            if ((n2 >>>= 7) > 127) {
                buf[pos++] = (byte)((n2 | 0x80) & 0xFF);
                if ((n2 >>>= 7) > 127) {
                    buf[pos++] = (byte)((n2 | 0x80) & 0xFF);
                    if ((n2 >>>= 7) > 127) {
                        buf[pos++] = (byte)((n2 | 0x80) & 0xFF);
                        n2 >>>= 7;
                    }
                }
            }
        }
        buf[pos++] = (byte)n2;
        return pos - start;
    }

    public static int encodeLong(long n2, byte[] buf, int pos) {
        n2 = n2 << 1 ^ n2 >> 63;
        int start = pos;
        if ((n2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
            if ((n2 >>>= 7) > 127L) {
                buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
                if ((n2 >>>= 7) > 127L) {
                    buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
                    if ((n2 >>>= 7) > 127L) {
                        buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
                        if ((n2 >>>= 7) > 127L) {
                            buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
                            if ((n2 >>>= 7) > 127L) {
                                buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
                                if ((n2 >>>= 7) > 127L) {
                                    buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
                                    if ((n2 >>>= 7) > 127L) {
                                        buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
                                        if ((n2 >>>= 7) > 127L) {
                                            buf[pos++] = (byte)((n2 | 0x80L) & 0xFFL);
                                            n2 >>>= 7;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        buf[pos++] = (byte)n2;
        return pos - start;
    }

    public static int encodeFloat(float f2, byte[] buf, int pos) {
        int len = 1;
        int bits = Float.floatToRawIntBits(f2);
        buf[pos] = (byte)(bits & 0xFF);
        buf[pos + len++] = (byte)(bits >>> 8 & 0xFF);
        buf[pos + len++] = (byte)(bits >>> 16 & 0xFF);
        buf[pos + len++] = (byte)(bits >>> 24 & 0xFF);
        return 4;
    }

    public static int encodeDouble(double d2, byte[] buf, int pos) {
        long bits = Double.doubleToRawLongBits(d2);
        int first = (int)(bits & 0xFFFFFFFFFFFFFFFFL);
        int second = (int)(bits >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        buf[pos] = (byte)(first & 0xFF);
        buf[pos + 4] = (byte)(second & 0xFF);
        buf[pos + 5] = (byte)(second >>> 8 & 0xFF);
        buf[pos + 1] = (byte)(first >>> 8 & 0xFF);
        buf[pos + 2] = (byte)(first >>> 16 & 0xFF);
        buf[pos + 6] = (byte)(second >>> 16 & 0xFF);
        buf[pos + 7] = (byte)(second >>> 24 & 0xFF);
        buf[pos + 3] = (byte)(first >>> 24 & 0xFF);
        return 8;
    }

    private static class HashData {
        private final BinaryDecoder.BufferAccessor bytes;
        private final BinaryDecoder decoder = new BinaryDecoder(new byte[0], 0, 0);

        public HashData() {
            this.bytes = this.decoder.getBufferAccessor();
        }

        public void set(byte[] bytes, int start, int len) {
            this.decoder.configure(bytes, start, len);
        }
    }

    private static class Decoders {
        private final BinaryDecoder.BufferAccessor b1;
        private final BinaryDecoder.BufferAccessor b2;
        private final BinaryDecoder d1 = new BinaryDecoder(new byte[0], 0, 0);
        private final BinaryDecoder d2 = new BinaryDecoder(new byte[0], 0, 0);

        public Decoders() {
            this.b1 = this.d1.getBufferAccessor();
            this.b2 = this.d2.getBufferAccessor();
        }

        public void set(byte[] data1, int off1, int len1, byte[] data2, int off2, int len2) {
            this.d1.configure(data1, off1, len1);
            this.d2.configure(data2, off2, len2);
        }
    }
}

