/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api.store;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StoreSection
implements Parcelable {
    public static final Parcelable.Creator<StoreSection> CREATOR = new Parcelable.Creator<StoreSection>(){

        public StoreSection createFromParcel(Parcel parcel) {
            String name = parcel.readString();
            String type = parcel.readString();
            int subsectionCount = parcel.readInt();
            ArrayList<StoreSection> subsections = new ArrayList<StoreSection>(subsectionCount);
            for (int i = 0; i < subsectionCount; ++i) {
                subsections.add(this.createFromParcel(parcel));
            }
            return new StoreSection(name, type, subsections);
        }

        public StoreSection[] newArray(int size) {
            return new StoreSection[size];
        }
    };
    private String name;
    private Type type;
    private List<StoreSection> subsections;

    public StoreSection() {
    }

    public StoreSection(JSONObject object) throws JSONException {
        this.readFromJSON(object);
    }

    public StoreSection(String name, String type, List<StoreSection> subsections) {
        this.name = name;
        this.type = Type.valueOf(type.toUpperCase());
        this.subsections = subsections;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<StoreSection> getSubsections() {
        return this.subsections;
    }

    public void setSubsections(List<StoreSection> subsections) {
        this.subsections = subsections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoreSection)) {
            return false;
        }
        StoreSection that = (StoreSection)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals((Object)that.type)) {
            return false;
        }
        return ((Object)this.subsections).equals(that.subsections);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + ((Object)this.subsections).hashCode();
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.name);
        parcel.writeString(this.type.name().toUpperCase());
        parcel.writeInt(this.subsections.size());
        for (int i = 0; i < this.subsections.size(); ++i) {
            this.subsections.get(i).writeToParcel(parcel, flags);
        }
    }

    public void readFromJSON(JSONObject object) throws JSONException {
        this.name = object.has("name") ? object.getString("name") : "";
        try {
            this.type = Type.valueOf(object.getString("type").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.type = Type.LIST;
        }
        this.subsections = new ArrayList<StoreSection>();
        if (object.has("contents")) {
            JSONArray contents = object.getJSONArray("contents");
            for (int i = 0; i < contents.length(); ++i) {
                this.subsections.add(new StoreSection(contents.getJSONObject(i)));
            }
        }
    }

    public static enum Type {
        TAG,
        LIST;

    }
}

