/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.os.Parcel;
import android.os.Parcelable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Currency;
import org.json.JSONException;
import org.json.JSONObject;

public class Product
implements Parcelable {
    public static final Parcelable.Creator<Product> CREATOR = new Parcelable.Creator<Product>(){

        public Product createFromParcel(Parcel parcel) {
            return new Product(parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readDouble(), parcel.readString(), parcel.readDouble(), parcel.readDouble(), parcel.readString(), parcel.readString());
        }

        public Product[] newArray(int size) {
            return new Product[size];
        }
    };
    private String identifier;
    private String name;
    private int priceInCents;
    private double localPrice;
    private String currencyCode;
    private double originalPrice;
    private double percentOff;
    private String description;
    private String developerName;
    public static final int INITIAL_PRODUCT_VERSION = 1;
    public static final int CURRENT_PRODUCT_VERSION = 5;
    private int productVersionToBundle = 5;

    public Product() {
    }

    public Product(JSONObject object) throws JSONException {
        this.readFromJSONObject(object);
    }

    public Product(String identifier, String name, int priceInCents, double localPrice, String currencyCode, double originalPrice, double percentOff, String description, String developerName) {
        this.identifier = identifier;
        this.name = name;
        this.priceInCents = priceInCents;
        this.localPrice = localPrice;
        this.currencyCode = currencyCode;
        this.originalPrice = originalPrice;
        this.percentOff = percentOff;
        this.description = description;
        this.developerName = developerName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public int getPriceInCents() {
        return this.priceInCents;
    }

    public double getLocalPrice() {
        return this.localPrice;
    }

    public double getOriginalPrice() {
        return this.originalPrice;
    }

    public double getPercentOff() {
        return this.percentOff;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getFormattedPrice() {
        DecimalFormat df;
        if (this.currencyCode != null && !this.currencyCode.isEmpty()) {
            df = (DecimalFormat)NumberFormat.getCurrencyInstance();
            df.setCurrency(Currency.getInstance(this.currencyCode));
        } else {
            df = new DecimalFormat("#.00");
        }
        return df.format(this.localPrice);
    }

    public String getDescription() {
        return this.description;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public void setProductVersionToBundle(int productVersionToBundle) {
        this.productVersionToBundle = productVersionToBundle;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.identifier);
        dest.writeString(this.name);
        dest.writeInt(this.priceInCents);
        if (this.productVersionToBundle >= 2) {
            dest.writeDouble(this.localPrice);
            dest.writeString(this.currencyCode);
        }
        if (this.productVersionToBundle >= 3) {
            dest.writeDouble(this.originalPrice);
            dest.writeDouble(this.percentOff);
        }
        if (this.productVersionToBundle >= 4) {
            dest.writeString(this.description);
        }
        if (this.productVersionToBundle >= 5) {
            dest.writeString(this.developerName);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product product = (Product)o;
        if (this.priceInCents != product.priceInCents) {
            return false;
        }
        if (!this.name.equals(product.name)) {
            return false;
        }
        if (!this.identifier.equals(product.identifier)) {
            return false;
        }
        if (this.localPrice != product.localPrice) {
            return false;
        }
        if (this.currencyCode != null && !this.currencyCode.equals(product.currencyCode)) {
            return false;
        }
        if (this.originalPrice != product.originalPrice) {
            return false;
        }
        if (this.percentOff != product.percentOff) {
            return false;
        }
        if (!this.description.equals(product.description)) {
            return false;
        }
        return this.developerName.equals(product.developerName);
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.priceInCents;
        result = 31 * result + Double.valueOf(this.localPrice).hashCode();
        if (this.currencyCode != null) {
            result = 31 * result + this.currencyCode.hashCode();
        }
        return result;
    }

    public void readFromJSONObject(JSONObject object) throws JSONException {
        this.identifier = object.getString("identifier");
        this.name = object.getString("name");
        this.priceInCents = object.optInt("priceInCents");
        this.localPrice = object.optDouble("localPrice");
        this.currencyCode = object.optString("currency", null);
        this.originalPrice = object.optDouble("originalPrice");
        this.percentOff = object.optDouble("percentOff");
        this.description = object.optString("description", "");
        this.developerName = object.optString("developerName", "");
    }
}

