/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tv.ouya.console.api.GamerInfo;
import tv.ouya.console.api.OuyaResponseListener;
import tv.ouya.console.api.Product;
import tv.ouya.console.api.Purchasable;
import tv.ouya.console.api.RequestRunnable;
import tv.ouya.console.internal.GamerInfoListenerBinder;
import tv.ouya.console.internal.IIapServiceDefinition;
import tv.ouya.console.internal.ProductListListenerBinder;
import tv.ouya.console.internal.StringListenerBinder;

public class OuyaFacade
implements ServiceConnection {
    private static final String LOG_TAG = "OUYAF";
    private static final String[] USER_DATA_COLUMNS = new String[]{"value"};
    private static final String[] ALL_DATA_COLUMNS = new String[]{"property_name", "value"};
    static final int ODK_VERSION_NUMBER = 62;
    private static final String OUYA_DEVICE_INFO_ACTION = "tv.ouya.DEVICE_INFO_ACTION";
    private static final String EXTRA_SUPPORTED_DEVICE = "SUPPORTED_DEVICE";
    private static final String EXTRA_DEVICE_NAME = "DEVICE_NAME";
    private static final String EXTRA_DEVICE_ENUM = "DEVICE_ENUM";
    private static OuyaFacade instance = new OuyaFacade();
    private static final String ODK_INITIALIZED_ACTION = "tv.ouya.ODK_INITIALIZED";
    private static final String ODK_SHUTDOWN_ACTION = "tv.ouya.ODK_SHUTDOWN";
    private static final String EXTRA_PACKAGE_NAME = "package_name";
    private Context context;
    private IIapServiceDefinition remoteService;
    private List<Runnable> pendingRequests = new ArrayList<Runnable>();
    private boolean bindRequestHasBeenMade;
    private String developerId;
    private DeviceHardware mDeviceHardware;
    private static boolean hasShownNonOuyaMessage = false;

    public static OuyaFacade getInstance() {
        return instance;
    }

    public static int getOdkVersionNumber() {
        return 62;
    }

    @Deprecated
    static void setInstance(OuyaFacade instance) {
        OuyaFacade.instance = instance;
    }

    OuyaFacade() {
        Log.v((String)LOG_TAG, (String)"ODK version number: 62");
    }

    public void init(Context context, String developerId) {
        if (this.isInitialized()) {
            return;
        }
        this.context = context.getApplicationContext();
        this.developerId = developerId;
        Intent initializedIntent = new Intent(ODK_INITIALIZED_ACTION);
        initializedIntent.putExtra(EXTRA_PACKAGE_NAME, context.getPackageName());
        this.context.sendBroadcast(initializedIntent);
    }

    public void shutdown() {
        if (this.context != null) {
            if (this.remoteService != null) {
                this.context.unbindService((ServiceConnection)this);
                this.remoteService = null;
                this.bindRequestHasBeenMade = false;
            }
            Intent shutdownIntent = new Intent(ODK_SHUTDOWN_ACTION);
            shutdownIntent.putExtra(EXTRA_PACKAGE_NAME, this.context.getPackageName());
            this.context.sendBroadcast(shutdownIntent);
            this.context = null;
        }
    }

    public boolean isInitialized() {
        return this.context != null;
    }

    public DeviceHardware getDeviceHardware() {
        if (this.mDeviceHardware == null) {
            if (!this.isInitialized()) {
                throw new RuntimeException("Must call OuyaFacade.init first");
            }
            Intent deviceInfoIntent = this.context.registerReceiver(null, new IntentFilter(OUYA_DEVICE_INFO_ACTION));
            if (deviceInfoIntent == null) {
                return new DeviceHardware(false, "unknown", DeviceEnum.UNKNOWN);
            }
            boolean supportedDevice = deviceInfoIntent.getBooleanExtra(EXTRA_SUPPORTED_DEVICE, false);
            String deviceName = deviceInfoIntent.getStringExtra(EXTRA_DEVICE_NAME);
            String deviceEnumName = deviceInfoIntent.getStringExtra(EXTRA_DEVICE_ENUM);
            DeviceEnum deviceEnum = DeviceEnum.UNKNOWN;
            try {
                deviceEnum = DeviceEnum.valueOf(deviceEnumName);
            }
            catch (Exception e) {
                Log.w((String)LOG_TAG, (String)("Error looking up deviceEnum for: " + deviceEnumName));
            }
            this.mDeviceHardware = new DeviceHardware(supportedDevice, deviceName, deviceEnum);
        }
        return this.mDeviceHardware;
    }

    public boolean isRunningOnOUYAHardware() {
        boolean runningOnOuya;
        boolean bl = runningOnOuya = "cardhu".equals(Build.DEVICE) || "ouya_1_1".equals(Build.DEVICE);
        if (!runningOnOuya && !hasShownNonOuyaMessage) {
            hasShownNonOuyaMessage = true;
            Log.w((String)LOG_TAG, (String)("Not running on Ouya hardware: " + Build.DEVICE));
        }
        return runningOnOuya;
    }

    public boolean isRunningOnOUYASupportedHardware() {
        boolean runningOnSupportedHardware = this.getDeviceHardware().isSupported();
        return runningOnSupportedHardware;
    }

    public void setTestMode() {
        SetTestModeRunnable setTestModeRunnable = new SetTestModeRunnable();
        this.runRequest(setTestModeRunnable);
    }

    public void putGameData(String name, String value) {
        ContentValues cv = new ContentValues();
        cv.put("value", value);
        String[] args = new String[]{name};
        Cursor result = this.context.getContentResolver().query(Uri.parse((String)("content://tv.ouya.userdata/settings/" + name)), null, "property_name = ?", args, null);
        if (result.getCount() > 0) {
            this.context.getContentResolver().update(Uri.parse((String)("content://tv.ouya.userdata/settings/" + name)), cv, "property_name = ?", args);
        } else {
            this.context.getContentResolver().insert(Uri.parse((String)("content://tv.ouya.userdata/settings/" + name)), cv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGameData(String name) {
        String[] args = new String[]{name};
        Cursor results = this.context.getContentResolver().query(Uri.parse((String)("content://tv.ouya.userdata/settings/" + name)), USER_DATA_COLUMNS, "property_name = ?", args, null, null);
        try {
            if (results.moveToNext()) {
                String string = results.getString(0);
                return string;
            }
        }
        finally {
            results.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAllGameData() {
        HashMap<String, String> result = null;
        Cursor results = this.context.getContentResolver().query(Uri.parse((String)"content://tv.ouya.userdata/settings/"), ALL_DATA_COLUMNS, null, null, null, null);
        try {
            while (results.moveToNext()) {
                if (result == null) {
                    result = new HashMap<String, String>();
                }
                result.put(results.getString(0), results.getString(1));
            }
        }
        finally {
            results.close();
        }
        return result;
    }

    public void requestProductList(List<Purchasable> purchasables, OuyaResponseListener<ArrayList<Product>> productListListener) {
        RequestProductListRunnable requestProductListRunnable = new RequestProductListRunnable(purchasables, productListListener);
        this.runRequest(requestProductListRunnable);
    }

    public void requestPurchase(Purchasable purchasable, OuyaResponseListener<String> purchaseListener) {
        RequestPurchaseRunnable requestProductListRunnable = new RequestPurchaseRunnable(purchasable, purchaseListener);
        this.runRequest(requestProductListRunnable);
    }

    public void requestReceipts(OuyaResponseListener<String> receiptListListener) {
        this.runRequest(new RequestReceiptsRunnable(receiptListListener));
    }

    public void requestGamerUuid(OuyaResponseListener<String> gamerUuidListener) {
        this.runRequest(new RequestGamerUuidRunnable(gamerUuidListener));
    }

    public void requestGamerInfo(OuyaResponseListener<GamerInfo> gamerInfoListener) {
        this.runRequest(new RequestGamerInfoRunnable(gamerInfoListener));
    }

    private void runRequest(Runnable requestRunnable) {
        this.ensureServiceIsBound();
        if (this.remoteService != null) {
            requestRunnable.run();
        } else {
            this.pendingRequests.add(requestRunnable);
        }
    }

    @Deprecated
    IIapServiceDefinition getRemoteService() {
        return this.remoteService;
    }

    @Deprecated
    public boolean bindRequestHasBeenMade() {
        return this.bindRequestHasBeenMade;
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Log.d((String)"inAppPurchase", (String)"Successfully bound to IapService");
        this.remoteService = IIapServiceDefinition.Stub.asInterface(iBinder);
        while (this.pendingRequests.size() > 0) {
            this.pendingRequests.remove(0).run();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.remoteService = null;
        this.bindRequestHasBeenMade = false;
    }

    void ensureServiceIsBound() {
        if (this.context == null) {
            Log.e((String)LOG_TAG, (String)"Dropping request because connect has been shut down");
            return;
        }
        if (!this.bindRequestHasBeenMade) {
            Log.d((String)"inAppPurchase", (String)"Binding to IapService");
            Intent intent = new Intent();
            intent.setClassName("tv.ouya", "tv.ouya.console.service.iap.IapService");
            this.context.bindService(intent, (ServiceConnection)this, 1);
            this.bindRequestHasBeenMade = true;
        }
    }

    private class RequestGamerInfoRunnable
    extends RequestRunnable {
        public RequestGamerInfoRunnable(OuyaResponseListener<GamerInfo> gamerInfoListener) {
            super(gamerInfoListener, "fetching gamer info");
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestGamerInfo(OuyaFacade.this.developerId, new GamerInfoListenerBinder(this.listener));
        }
    }

    private class RequestGamerUuidRunnable
    extends RequestRunnable {
        public RequestGamerUuidRunnable(OuyaResponseListener<String> gamerUuidListener) {
            super(gamerUuidListener, "fetching gamer UUID");
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestGamerUuid(OuyaFacade.this.developerId, new StringListenerBinder(this.listener));
        }
    }

    private class RequestReceiptsRunnable
    extends RequestRunnable {
        private RequestReceiptsRunnable(OuyaResponseListener<String> listener) {
            super(listener, "fetching receipts");
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestReceipts(OuyaFacade.this.developerId, new StringListenerBinder(this.listener));
        }
    }

    private class RequestPurchaseRunnable
    extends RequestRunnable {
        private final Purchasable purchasable;

        public RequestPurchaseRunnable(Purchasable purchasable, OuyaResponseListener<String> purchaseListener) {
            super(purchaseListener, "purchasing");
            this.purchasable = purchasable;
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestPurchase(OuyaFacade.this.developerId, this.purchasable, new StringListenerBinder(this.listener));
        }
    }

    private class RequestProductListRunnable
    extends RequestRunnable {
        private final List<Purchasable> purchasables;

        public RequestProductListRunnable(List<Purchasable> purchasables, OuyaResponseListener<ArrayList<Product>> productListListener) {
            super(productListListener, "fetching product list");
            this.purchasables = purchasables;
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.requestProductListForVersion(OuyaFacade.this.developerId, 5, this.purchasables, new ProductListListenerBinder(this.listener));
        }
    }

    private class SetTestModeRunnable
    extends RequestRunnable {
        public SetTestModeRunnable() {
            super(new OuyaResponseListener(){

                public void onSuccess(Object result) {
                }

                @Override
                public void onFailure(int errorCode, String errorMessage, Bundle optionalData) {
                }

                @Override
                public void onCancel() {
                }
            }, "setting test mode");
        }

        @Override
        void doRun() throws RemoteException {
            OuyaFacade.this.remoteService.setTestMode();
        }
    }

    public static class DeviceHardware {
        private boolean mIsSupported;
        private String mDeviceName;
        private DeviceEnum mDeviceEnum;

        DeviceHardware(boolean isSupported, String deviceName, DeviceEnum deviceEnum) {
            this.mIsSupported = isSupported;
            this.mDeviceName = deviceName;
            this.mDeviceEnum = deviceEnum;
        }

        public boolean isSupported() {
            return this.mIsSupported;
        }

        public String deviceName() {
            return this.mDeviceName;
        }

        public DeviceEnum deviceEnum() {
            return this.mDeviceEnum;
        }
    }

    public static enum DeviceEnum {
        OUYA,
        MOJO,
        UNKNOWN;

    }
}

