/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import tv.ouya.console.api.OuyaInputMapper;

public class OuyaActivity
extends Activity {
    private static final String TAG = OuyaActivity.class.getSimpleName();
    private static final int INPUT_BROADCAST_COOLDOWN_MS = 30000;
    private static final String ACTION_OUYA_USER_INPUT = "tv.ouya.metrics.action.USER_INPUT";
    private static final String EXTRA_OUYA_INPUT_ANALOG = "analog";
    public static final int FLAGS_DEFAULT = 0;
    public static final int FLAG_SKIP_TAKE_KEYS = 1;
    public static final int FLAG_SKIP_HIDE_NAV_BAR = 2;
    public static final int FLAG_SKIP_OUYACONTROLLER_DISPATCH = 4;
    public static final int FLAG_SKIP_OUYAINPUTMAPPER_DISPATCHES = 8;
    private int mFlags = 0;
    private long mLastAnalogTick;
    private long mLastDigitalTick;

    public void setFlags(int flags) {
        this.mFlags = flags;
    }

    protected void onCreate(Bundle savedInstanceState) {
        OuyaInputMapper.init(this);
        boolean enableControllerDispatch = (this.mFlags & 4) == 0;
        OuyaInputMapper.setEnableControllerDispatch(enableControllerDispatch);
        super.onCreate(savedInstanceState);
    }

    protected void onDestroy() {
        super.onDestroy();
        OuyaInputMapper.shutdown(this);
    }

    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        OuyaActivity.setContentView(this, this.mFlags);
    }

    public void setContentView(View view) {
        super.setContentView(view);
        OuyaActivity.setContentView(this, this.mFlags);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        OuyaActivity.setContentView(this, this.mFlags);
    }

    public static void setContentView(Activity activity, int flags) {
        if ((flags & 1) == 0) {
            activity.takeKeyEvents(true);
        }
        if ((flags & 2) == 0) {
            OuyaActivity.hideNavigationBar(activity);
        }
    }

    public static void hideNavigationBar(Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        int uiOptions = 6;
        decorView.setSystemUiVisibility(uiOptions);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if ((this.mFlags & 8) == 0 && OuyaInputMapper.shouldHandleInputEvent((InputEvent)keyEvent)) {
            this.broadcastInputNotification(false);
            return OuyaInputMapper.dispatchKeyEvent(this, keyEvent);
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if ((this.mFlags & 8) == 0 && OuyaInputMapper.shouldHandleInputEvent((InputEvent)motionEvent)) {
            this.broadcastInputNotification(true);
            return OuyaInputMapper.dispatchGenericMotionEvent(this, motionEvent);
        }
        return super.dispatchGenericMotionEvent(motionEvent);
    }

    private void broadcastInputNotification(boolean analog) {
        long lastTick;
        long curTick = System.nanoTime() / 1000000L;
        long l = lastTick = analog ? this.mLastAnalogTick : this.mLastDigitalTick;
        if (curTick - lastTick < 30000L) {
            return;
        }
        if (analog) {
            this.mLastAnalogTick = curTick;
        } else {
            this.mLastDigitalTick = curTick;
        }
        Intent intent = new Intent(ACTION_OUYA_USER_INPUT);
        intent.putExtra(EXTRA_OUYA_INPUT_ANALOG, analog);
        this.sendBroadcast(intent);
    }
}

