/*
 * Decompiled with CFR 0.152.
 */
package com.boothen.jsonedit.preferences;

import com.boothen.jsonedit.preferences.JsonPreferenceStore;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkbenchPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    private BooleanFieldEditor usePlatformTabSetting;
    private BooleanFieldEditor spacesForTab;
    private IntegerFieldEditor indentSpaces;

    public WorkbenchPreferencePage() {
        super(1);
        IPreferenceStore store = JsonPreferenceStore.getIPreferenceStore();
        this.setPreferenceStore(store);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JsonPreferenceStore.getIPreferenceStore();
    }

    public WorkbenchPreferencePage(String title) {
        super(1);
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        if (this.usePlatformTabSetting != null) {
            this.usePlatformTabSetting.setPropertyChangeListener(null);
        }
        super.dispose();
    }

    protected void createFieldEditors() {
        Boolean overrideTabSetting = this.getPreferenceStore().getBoolean("override_tab_setting");
        this.usePlatformTabSetting = new BooleanFieldEditor("override_tab_setting", "Override Workbench Tab Setting", this.getFieldEditorParent());
        this.addField((FieldEditor)this.usePlatformTabSetting);
        this.usePlatformTabSetting.setPropertyChangeListener((IPropertyChangeListener)this);
        this.spacesForTab = new BooleanFieldEditor("spaces_for_tabs", "Insert Spaces For Tabs", this.getFieldEditorParent());
        this.spacesForTab.setEnabled(overrideTabSetting.booleanValue(), this.getFieldEditorParent());
        this.addField((FieldEditor)this.spacesForTab);
        this.indentSpaces = new IntegerFieldEditor("num_spaces", "&Number of spaces to indent:", this.getFieldEditorParent(), 1);
        this.indentSpaces.setValidRange(0, 10);
        this.indentSpaces.setEnabled(overrideTabSetting.booleanValue(), this.getFieldEditorParent());
        this.addField((FieldEditor)this.indentSpaces);
        BooleanFieldEditor autoFormatOnSave = new BooleanFieldEditor("autoFormatOnSave", "Auto Format On Save", this.getFieldEditorParent());
        this.addField((FieldEditor)autoFormatOnSave);
        ColorFieldEditor stringColor = new ColorFieldEditor("stringColor", "&Key Attribute Color", this.getFieldEditorParent());
        this.addField((FieldEditor)stringColor);
        ColorFieldEditor valueColor = new ColorFieldEditor("valueColor", "&Value Attribute Color", this.getFieldEditorParent());
        this.addField((FieldEditor)valueColor);
        ColorFieldEditor nullColor = new ColorFieldEditor("nullColor", "&Null Value Color", this.getFieldEditorParent());
        this.addField((FieldEditor)nullColor);
        ColorFieldEditor defaultColor = new ColorFieldEditor("defaultColor", "&Default Color", this.getFieldEditorParent());
        this.addField((FieldEditor)defaultColor);
    }

    protected void performDefaults() {
        Boolean defaultUsePlatformTabSetting = this.getPreferenceStore().getDefaultBoolean("override_tab_setting");
        this.togglePreferences(defaultUsePlatformTabSetting);
        super.performDefaults();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.usePlatformTabSetting) {
            this.togglePreferences((Boolean)event.getNewValue());
        }
        super.propertyChange(event);
    }

    private void togglePreferences(Boolean enabled) {
        this.spacesForTab.setEnabled(enabled.booleanValue(), this.getFieldEditorParent());
        this.indentSpaces.setEnabled(enabled.booleanValue(), this.getFieldEditorParent());
    }
}

