/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.internal;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Comparator;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.koneki.ldt.debug.core.internal.Activator;

public class LuaVariableComparator
implements Comparator<IVariable>,
Serializable {
    private static final long serialVersionUID = -5828968181211469862L;

    private int category(IVariable var) throws DebugException {
        return var.getReferenceTypeName().equals("special") ? 0 : 1;
    }

    private String extractValueFromBracket(String key) {
        int keyLenght = key.length();
        if (key.charAt(0) == '[' && key.charAt(keyLenght - 1) == ']') {
            return key.substring(1, keyLenght - 1);
        }
        return null;
    }

    private Double getArrayVarNumberIndex(IVariable var) throws DebugException {
        if (NumberUtils.isNumber((String)this.extractValueFromBracket(var.getName().trim()))) {
            try {
                return Double.valueOf(this.extractValueFromBracket(var.getName().trim()));
            }
            catch (NumberFormatException e) {
                Activator.logWarning(MessageFormat.format("[VariableView] Unable to retreive table Index for varialble {0}", var.getName()), e);
            }
        }
        return null;
    }

    @Override
    public int compare(IVariable v1, IVariable v2) {
        block13: {
            Double numberIndex2;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            try {
                                if (v1 != null || v2 != null) break block9;
                                return 0;
                            }
                            catch (DebugException debugException) {
                                return 0;
                            }
                        }
                        if (v1 != null) break block10;
                        return 1;
                    }
                    if (v2 != null) break block11;
                    return -1;
                }
                int cat1 = this.category(v1);
                int cat2 = this.category(v2);
                if (cat1 != cat2) {
                    return cat1 - cat2;
                }
                numberIndex2 = this.getArrayVarNumberIndex(v2);
                Double numberIndex1 = this.getArrayVarNumberIndex(v1);
                if (numberIndex1 != null && numberIndex2 != null) {
                    return NumberUtils.compare((double)numberIndex1, (double)numberIndex2);
                }
                if (numberIndex1 == null) break block12;
                return -1;
            }
            if (numberIndex2 == null) break block13;
            return 1;
        }
        return v1.getName().compareTo(v2.getName());
    }
}

