/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.ui.model.WorkbenchContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingViewContentProvider
extends WorkbenchContentProvider {
    private StagingEntry[] content = new StagingEntry[0];
    private StagingFolderEntry[] treeFolders;
    private StagingFolderEntry[] compactTreeFolders;
    private StagingView stagingView;
    private boolean unstagedSection;
    private Repository repository;

    StagingViewContentProvider(StagingView stagingView, boolean unstagedSection) {
        this.stagingView = stagingView;
        this.unstagedSection = unstagedSection;
    }

    public Object getParent(Object element) {
        if (element instanceof StagingFolderEntry) {
            return ((StagingFolderEntry)element).getParent();
        }
        if (element instanceof StagingEntry) {
            return ((StagingEntry)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof StagingEntry);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (this.repository == null) {
            return new Object[0];
        }
        if (parentElement instanceof StagingEntry) {
            return new Object[0];
        }
        if (parentElement instanceof StagingFolderEntry) {
            return this.getFolderChildren((StagingFolderEntry)parentElement);
        }
        if (this.stagingView.getPresentation() == StagingView.Presentation.LIST) {
            return this.content;
        }
        StagingFolderEntry[] allFolders = this.getStagingFolderEntries();
        ArrayList<IAdaptable> roots = new ArrayList<IAdaptable>();
        IAdaptable[] iAdaptableArray = allFolders;
        int n = allFolders.length;
        int n2 = 0;
        while (n2 < n) {
            StagingFolderEntry folder = iAdaptableArray[n2];
            if (folder.getParentPath().segmentCount() == 0) {
                roots.add(folder);
            }
            ++n2;
        }
        iAdaptableArray = this.content;
        n = this.content.length;
        n2 = 0;
        while (n2 < n) {
            IAdaptable entry = iAdaptableArray[n2];
            if (!entry.getPath().contains("/")) {
                roots.add(entry);
            }
            ++n2;
        }
        return roots.toArray(new Object[roots.size()]);
    }

    private Object[] getFolderChildren(StagingFolderEntry parent) {
        IPath parentPath = parent.getPath();
        ArrayList<IAdaptable> children = new ArrayList<IAdaptable>();
        IAdaptable[] iAdaptableArray = this.getStagingFolderEntries();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            StagingFolderEntry folder = iAdaptableArray[n2];
            if (folder.getParentPath().equals((Object)parentPath)) {
                folder.setParent(parent);
                children.add(folder);
            }
            ++n2;
        }
        iAdaptableArray = this.content;
        n = this.content.length;
        n2 = 0;
        while (n2 < n) {
            IAdaptable file = iAdaptableArray[n2];
            if (file.getParentPath().equals((Object)parentPath)) {
                file.setParent(parent);
                children.add(file);
            }
            ++n2;
        }
        return children.toArray(new Object[children.size()]);
    }

    StagingFolderEntry[] getStagingFolderEntries() {
        StagingView.Presentation presentation = this.stagingView.getPresentation();
        switch (presentation) {
            case COMPACT_TREE: {
                return this.getCompactTreeFolders();
            }
            case TREE: {
                return this.getTreeFolders();
            }
        }
        return new StagingFolderEntry[0];
    }

    private StagingFolderEntry[] getCompactTreeFolders() {
        if (this.compactTreeFolders == null) {
            this.compactTreeFolders = this.calculateTreeFolders(true);
        }
        return this.compactTreeFolders;
    }

    private StagingFolderEntry[] getTreeFolders() {
        if (this.treeFolders == null) {
            this.treeFolders = this.calculateTreeFolders(false);
        }
        return this.treeFolders;
    }

    private StagingFolderEntry[] calculateTreeFolders(boolean compact) {
        if (this.content == null || this.content.length == 0) {
            return new StagingFolderEntry[0];
        }
        HashSet<IPath> folderPaths = new HashSet<IPath>();
        HashMap<IPath, String> childSegments = new HashMap<IPath, String>();
        StagingEntry[] stagingEntryArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry file = stagingEntryArray[n2];
            IPath folderPath = file.getParentPath();
            if (folderPath.segmentCount() != 0) {
                folderPaths.add(folderPath);
                IPath p = folderPath;
                while (p.segmentCount() != 1) {
                    IPath parent = p.removeLastSegments(1);
                    if (!compact) {
                        folderPaths.add(parent);
                    } else {
                        String childSegment = p.lastSegment();
                        String knownChildSegment = (String)childSegments.get(parent);
                        if (knownChildSegment == null) {
                            childSegments.put(parent, childSegment);
                        } else if (!childSegment.equals(knownChildSegment)) {
                            folderPaths.add(parent);
                        }
                    }
                    p = p.removeLastSegments(1);
                }
            }
            ++n2;
        }
        Path workingDirectory = new Path(this.repository.getWorkTree().getAbsolutePath());
        ArrayList<StagingFolderEntry> folderEntries = new ArrayList<StagingFolderEntry>();
        for (IPath folderPath : folderPaths) {
            IPath parent = folderPath.removeLastSegments(1);
            while (parent.segmentCount() != 0 && !folderPaths.contains(parent)) {
                parent = parent.removeLastSegments(1);
            }
            if (parent.segmentCount() == 0) {
                StagingFolderEntry folderEntry = new StagingFolderEntry((IPath)workingDirectory, folderPath, folderPath);
                folderEntries.add(folderEntry);
                continue;
            }
            IPath nodePath = folderPath.makeRelativeTo(parent);
            StagingFolderEntry folderEntry = new StagingFolderEntry((IPath)workingDirectory, folderPath, nodePath);
            folderEntries.add(folderEntry);
        }
        Collections.sort(folderEntries, FolderComparator.INSTANCE);
        return folderEntries.toArray(new StagingFolderEntry[folderEntries.size()]);
    }

    int getShownCount() {
        String filterString = this.getFilterString();
        if (filterString.length() == 0) {
            return this.getCount();
        }
        int shownCount = 0;
        StagingEntry[] stagingEntryArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry entry = stagingEntryArray[n2];
            if (this.isInFilter(entry)) {
                ++shownCount;
            }
            ++n2;
        }
        return shownCount;
    }

    List<StagingEntry> getStagingEntriesFiltered(StagingFolderEntry folder) {
        ArrayList<StagingEntry> stagingEntries = new ArrayList<StagingEntry>();
        StagingEntry[] stagingEntryArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry stagingEntry = stagingEntryArray[n2];
            if (folder.getLocation().isPrefixOf(stagingEntry.getLocation()) && this.isInFilter(stagingEntry)) {
                stagingEntries.add(stagingEntry);
            }
            ++n2;
        }
        return stagingEntries;
    }

    boolean isInFilter(StagingEntry stagingEntry) {
        String filterString = this.getFilterString();
        return filterString.length() == 0 || stagingEntry.getPath().toUpperCase().contains(filterString.toUpperCase());
    }

    private String getFilterString() {
        return this.stagingView.getFilterString();
    }

    boolean hasVisibleChildren(StagingFolderEntry folder) {
        if (this.getFilterString().length() == 0) {
            return true;
        }
        return !this.getStagingEntriesFiltered(folder).isEmpty();
    }

    StagingEntry[] getStagingEntries() {
        return this.content;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (!(newInput instanceof StagingView.StagingViewUpdate)) {
            return;
        }
        StagingView.StagingViewUpdate update = (StagingView.StagingViewUpdate)newInput;
        if (update.repository == null || update.indexDiff == null) {
            this.content = new StagingEntry[0];
            this.treeFolders = new StagingFolderEntry[0];
            this.compactTreeFolders = new StagingFolderEntry[0];
            return;
        }
        if (update.repository != this.repository) {
            this.treeFolders = null;
            this.compactTreeFolders = null;
        }
        this.repository = update.repository;
        TreeSet<StagingEntry> nodes = new TreeSet<StagingEntry>(new Comparator<StagingEntry>(){

            @Override
            public int compare(StagingEntry o1, StagingEntry o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        if (update.changedResources != null && !update.changedResources.isEmpty()) {
            nodes.addAll(Arrays.asList(this.content));
            for (String res : update.changedResources) {
                StagingEntry[] stagingEntryArray = this.content;
                int n = this.content.length;
                int n2 = 0;
                while (n2 < n) {
                    StagingEntry stagingEntry = stagingEntryArray[n2];
                    if (stagingEntry.getPath().equals(res)) {
                        nodes.remove(stagingEntry);
                    }
                    ++n2;
                }
            }
        }
        IndexDiffData indexDiff = update.indexDiff;
        if (this.unstagedSection) {
            for (String file : indexDiff.getMissing()) {
                if (indexDiff.getChanged().contains(file)) {
                    nodes.add(new StagingEntry(this.repository, StagingEntry.State.MISSING_AND_CHANGED, file));
                    continue;
                }
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.MISSING, file));
            }
            for (String file : indexDiff.getModified()) {
                if (indexDiff.getChanged().contains(file)) {
                    nodes.add(new StagingEntry(this.repository, StagingEntry.State.PARTIALLY_MODIFIED, file));
                    continue;
                }
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.MODIFIED, file));
            }
            for (String file : indexDiff.getUntracked()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.UNTRACKED, file));
            }
            for (String file : indexDiff.getConflicting()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.CONFLICTING, file));
            }
        } else {
            for (String file : indexDiff.getAdded()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.ADDED, file));
            }
            for (String file : indexDiff.getChanged()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.CHANGED, file));
            }
            for (String file : indexDiff.getRemoved()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.REMOVED, file));
            }
        }
        try {
            SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)this.repository);
            while (walk.next()) {
                for (StagingEntry stagingEntry : nodes) {
                    stagingEntry.setSubmodule(stagingEntry.getPath().equals(walk.getPath()));
                }
            }
        }
        catch (IOException e) {
            Activator.error(UIText.StagingViewContentProvider_SubmoduleError, e);
        }
        this.content = nodes.toArray(new StagingEntry[nodes.size()]);
        this.treeFolders = null;
        this.compactTreeFolders = null;
    }

    public void dispose() {
    }

    public int getCount() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FolderComparator
    implements Comparator<StagingFolderEntry> {
        public static FolderComparator INSTANCE = new FolderComparator();

        private FolderComparator() {
        }

        @Override
        public int compare(StagingFolderEntry o1, StagingFolderEntry o2) {
            return o1.getPath().toString().compareTo(o2.getPath().toString());
        }
    }
}

