/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.CreateLocalBranchOperation;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.ValidationUtils;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.components.UpstreamConfigComponent;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class CreateBranchPage
extends WizardPage {
    private final Repository myRepository;
    private final IInputValidator myValidator;
    private final String myBaseRef;
    private final RevCommit myBaseCommit;
    private Text nameText;
    private boolean nameIsSuggestion;
    private Button checkout;
    private CreateLocalBranchOperation.UpstreamConfig upstreamConfig;
    private UpstreamConfigComponent upstreamConfigComponent;
    private Label sourceIcon;
    private Label sourceNameLabel;
    private String sourceRefName = "";
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static String getProposedTargetName(String sourceName) {
        if (sourceName == null) {
            return null;
        }
        if (sourceName.startsWith("refs/remotes/")) {
            String target = sourceName.substring("refs/remotes/".length());
            int postSlash = target.indexOf(47) + 1;
            if (postSlash > 0 && postSlash < target.length()) {
                return target.substring(postSlash);
            }
            return target;
        }
        if (sourceName.startsWith("refs/tags/")) {
            return String.valueOf(sourceName.substring("refs/tags/".length())) + "-branch";
        }
        return "";
    }

    public CreateBranchPage(Repository repo, Ref baseRef) {
        super(CreateBranchPage.class.getName());
        this.myRepository = repo;
        this.myBaseRef = baseRef != null ? baseRef.getName() : null;
        this.myBaseCommit = null;
        this.myValidator = ValidationUtils.getRefNameInputValidator(this.myRepository, "refs/heads/", true);
        this.upstreamConfig = baseRef != null ? CreateLocalBranchOperation.UpstreamConfig.getDefault((Repository)repo, (String)baseRef.getName()) : CreateLocalBranchOperation.UpstreamConfig.NONE;
        this.setTitle(UIText.CreateBranchPage_Title);
        this.setMessage(UIText.CreateBranchPage_ChooseBranchAndNameMessage);
    }

    public CreateBranchPage(Repository repo, RevCommit baseCommit) {
        super(CreateBranchPage.class.getName());
        this.myRepository = repo;
        this.myBaseRef = null;
        this.myBaseCommit = baseCommit;
        this.myValidator = ValidationUtils.getRefNameInputValidator(this.myRepository, "refs/heads/", true);
        this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.NONE;
        this.setTitle(UIText.CreateBranchPage_Title);
        this.setMessage(UIText.CreateBranchPage_ChooseNameMessage);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(4, false));
        Label sourceLabel = new Label(main, 0);
        sourceLabel.setText(UIText.CreateBranchPage_SourceLabel);
        sourceLabel.setToolTipText(UIText.CreateBranchPage_SourceTooltip);
        this.sourceIcon = new Label(main, 0);
        this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.BRANCH));
        this.sourceIcon.setLayoutData((Object)GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).create());
        this.sourceNameLabel = new Label(main, 0);
        this.sourceNameLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        Button selectButton = new Button(main, 0);
        selectButton.setText(UIText.CreateBranchPage_SourceSelectButton);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchPage.this.selectSource();
            }
        });
        UIUtils.setButtonLayoutData(selectButton);
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(UIText.CreateBranchPage_BranchNameLabel);
        nameLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(1, 1).align(1, 0x1000000).create());
        nameLabel.setToolTipText(UIText.CreateBranchPage_BranchNameToolTip);
        this.nameText = new Text(main, 2048);
        nameLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                CreateBranchPage.this.nameText.setFocus();
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBranchPage.this.nameIsSuggestion = false;
            }
        });
        this.nameText.setData("org.eclipse.swtbot.widget.key", (Object)"BranchName");
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.nameText);
        this.upstreamConfigComponent = new UpstreamConfigComponent(main, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(4, 1).applyTo((Control)this.upstreamConfigComponent.getContainer());
        this.upstreamConfigComponent.addUpstreamConfigSelectionListener(new UpstreamConfigComponent.UpstreamConfigSelectionListener(){

            public void upstreamConfigSelected(CreateLocalBranchOperation.UpstreamConfig newUpstreamConfig) {
                CreateBranchPage.this.upstreamConfig = newUpstreamConfig;
                CreateBranchPage.this.checkPage();
            }
        });
        boolean isBare = this.myRepository.isBare();
        this.checkout = new Button(main, 32);
        this.checkout.setText(UIText.CreateBranchPage_CheckoutButton);
        this.checkout.setSelection(!isBare);
        this.checkout.setEnabled(!isBare);
        this.checkout.setVisible(!isBare);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.checkout);
        this.checkout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchPage.this.checkPage();
            }
        });
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
        if (this.myBaseCommit != null) {
            this.setSourceCommit(this.myBaseCommit);
        } else if (this.myBaseRef != null) {
            this.setSourceRef(this.myBaseRef);
        }
        this.nameText.setFocus();
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBranchPage.this.checkPage();
            }
        });
    }

    public void dispose() {
        this.resourceManager.dispose();
    }

    private void setSourceRef(String refName) {
        String shortName = Repository.shortenRefName((String)refName);
        this.sourceNameLabel.setText(shortName);
        if (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/")) {
            this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.BRANCH));
        } else if (refName.startsWith("refs/tags/")) {
            this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.TAG));
        } else {
            this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.CHANGESET));
        }
        this.sourceRefName = refName;
        this.suggestBranchName(refName);
        this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.getDefault((Repository)this.myRepository, (String)refName);
        this.checkPage();
    }

    private void setSourceCommit(RevCommit commit) {
        this.sourceNameLabel.setText(commit.abbreviate(7).name());
        this.sourceIcon.setImage(UIIcons.getImage((ResourceManager)this.resourceManager, UIIcons.CHANGESET));
        this.sourceRefName = commit.name();
        this.upstreamConfig = CreateLocalBranchOperation.UpstreamConfig.NONE;
        this.checkPage();
    }

    private void selectSource() {
        SourceSelectionDialog dialog = new SourceSelectionDialog(this.getShell(), this.myRepository, this.sourceRefName);
        int result = dialog.open();
        if (result == 0) {
            String refName = dialog.getRefName();
            this.setSourceRef(refName);
            this.nameText.setFocus();
        }
    }

    private void checkPage() {
        block10: {
            block9: {
                block8: {
                    try {
                        boolean basedOnLocalBranch;
                        this.upstreamConfigComponent.setUpstreamConfig(this.upstreamConfig);
                        boolean showUpstreamConfig = this.sourceRefName.startsWith("refs/heads/") || this.sourceRefName.startsWith("refs/remotes/");
                        Composite container = this.upstreamConfigComponent.getContainer();
                        GridData gd = (GridData)container.getLayoutData();
                        if (gd.exclude == showUpstreamConfig) {
                            gd.exclude = !showUpstreamConfig;
                            container.setVisible(showUpstreamConfig);
                            container.getParent().layout(true);
                        }
                        if ((basedOnLocalBranch = this.sourceRefName.startsWith("refs/heads/")) && this.upstreamConfig != CreateLocalBranchOperation.UpstreamConfig.NONE) {
                            this.setMessage(UIText.CreateBranchPage_LocalBranchWarningMessage, 1);
                        } else {
                            this.setMessage(null);
                        }
                        if (this.sourceRefName.length() != 0) break block8;
                        this.setErrorMessage(UIText.CreateBranchPage_MissingSourceMessage);
                    }
                    catch (Throwable throwable) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw throwable;
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                if (this.nameText.getText().length() != 0) break block9;
                this.setErrorMessage(UIText.CreateBranchPage_ChooseNameMessage);
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            String message = this.myValidator.isValid(this.nameText.getText());
            if (message == null) break block10;
            this.setErrorMessage(message);
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public String getBranchName() {
        return this.nameText.getText();
    }

    public void createBranch(IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask(UIText.CreateBranchPage_CreatingBranchMessage, -1);
        String newRefName = this.getBranchName();
        CreateLocalBranchOperation cbop = this.myBaseCommit != null && this.sourceRefName.equals(this.myBaseCommit.name()) ? new CreateLocalBranchOperation(this.myRepository, newRefName, this.myBaseCommit) : new CreateLocalBranchOperation(this.myRepository, newRefName, this.myRepository.getRef(this.sourceRefName), this.upstreamConfig);
        cbop.execute(monitor);
        if (this.checkout.getSelection()) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask(UIText.CreateBranchPage_CheckingOutMessage, -1);
            BranchOperationUI.checkout(this.myRepository, "refs/heads/" + newRefName).run(monitor);
        }
    }

    private void suggestBranchName(String ref) {
        String branchNameSuggestion;
        if ((this.nameText.getText().length() == 0 || this.nameIsSuggestion) && (branchNameSuggestion = CreateBranchPage.getProposedTargetName(ref)) != null) {
            this.nameText.setText(branchNameSuggestion);
            this.nameText.selectAll();
            this.nameIsSuggestion = true;
        }
    }

    private static class SourceSelectionDialog
    extends AbstractBranchSelectionDialog {
        public SourceSelectionDialog(Shell parentShell, Repository repository, String refToMark) {
            super(parentShell, repository, refToMark, 254);
        }

        protected void refNameSelected(String refName) {
            this.setOkButtonEnabled(refName != null);
        }

        protected String getTitle() {
            return UIText.CreateBranchPage_SourceSelectionDialogTitle;
        }

        protected String getMessageText() {
            return UIText.CreateBranchPage_SourceSelectionDialogMessage;
        }
    }
}

