/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowVersionsHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(this.getPage());
        Object input = this.getPage().getInputInternal().getSingleFile();
        if (selection.size() < 1 || input == null) {
            return null;
        }
        boolean compareMode = Boolean.parseBoolean(event.getParameter("org.eclipse.egit.ui.history.CompareMode"));
        Repository repository = this.getRepository(event);
        String gitPath = null;
        if (input instanceof IFile) {
            IFile resource = (IFile)input;
            RepositoryMapping map = RepositoryMapping.getMapping((IResource)resource);
            gitPath = map.getRepoRelativePath((IResource)resource);
        } else if (input instanceof File) {
            File fileInput = (File)input;
            gitPath = this.getRepoRelativePath(repository, fileInput);
        } else {
            return null;
        }
        boolean errorOccurred = false;
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        for (RevCommit commit : selection) {
            IFileRevision revision = null;
            try {
                revision = CompareUtils.getFileRevision(gitPath, commit, repository, null);
            }
            catch (IOException e) {
                Activator.logError(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)gitPath, (Object)commit.getId()), e);
                errorOccurred = true;
            }
            if (revision == null) {
                ids.add(commit.getId());
                continue;
            }
            if (compareMode) {
                String dstRevCommit = commit.getId().getName();
                IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
                try {
                    if (input instanceof IFile) {
                        IResource[] resources = new IResource[]{(IFile)input};
                        CompareUtils.compare(resources, repository, "HEAD", dstRevCommit, true, workBenchPage);
                        continue;
                    }
                    Path location = new Path(((File)input).getAbsolutePath());
                    CompareUtils.compare((IPath)location, repository, "HEAD", dstRevCommit, true, workBenchPage);
                }
                catch (IOException e) {
                    Activator.logError(UIText.GitHistoryPage_openFailed, e);
                    errorOccurred = true;
                }
                continue;
            }
            try {
                EgitUiEditorUtils.openEditor(this.getPart(event).getSite().getPage(), revision, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.logError(UIText.GitHistoryPage_openFailed, e);
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
        }
        if (ids.size() > 0) {
            StringBuilder idList = new StringBuilder("");
            for (ObjectId objectId : ids) {
                idList.append(objectId.getName()).append(' ');
            }
            MessageDialog.openError((Shell)this.getPart(event).getSite().getShell(), (String)UIText.GitHistoryPage_fileNotFound, (String)NLS.bind((String)UIText.GitHistoryPage_notContainedInCommits, (Object)gitPath, (Object)idList.toString()));
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        int size = this.getSelection(page).size();
        if (size == 0) {
            return false;
        }
        return page.getInputInternal().isSingleFile();
    }
}

