/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.ui.launching;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ccdt.common.CommonPython;
import org.ccdt.common.config.model.JSConfig;
import org.ccdt.common.manager.CocosLaunchManager;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.utils.AndroidUtil;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.debug.core.jsdi.connect.Connector;
import org.ccdt.debug.internal.core.JavaScriptDebugPlugin;
import org.ccdt.debug.internal.jsbinding.connect.AndroidConnector;
import org.ccdt.debug.internal.jsbinding.connect.IOSConnector;
import org.ccdt.debug.internal.jsbinding.connect.IOSSimulatorFamilyArgument;
import org.ccdt.debug.internal.jsbinding.connect.LaunchActivityArgument;
import org.ccdt.debug.internal.jsbinding.connect.MacConnector;
import org.ccdt.debug.internal.jsbinding.connect.Win32Connector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;

public class JSLaunchManager
implements CocosLaunchManager.ICocosLauncher {
    public boolean canHandle(IProject iProject) {
        try {
            return iProject.hasNature("org.ccdt.jsdt.core.jsNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean canHandle(ILaunchConfiguration iLaunchConfiguration) {
        Map map = null;
        try {
            map = iLaunchConfiguration.getAttribute("argument_map", null);
        }
        catch (CoreException coreException) {
            return false;
        }
        return map != null;
    }

    public void launchProject(IProject iProject, String string) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            iLaunchConfiguration = CocosLaunchManager.getLaunchConfig((String)iProject.getName());
            if (iLaunchConfiguration == null) {
                iLaunchConfiguration = this.createLaunchConfig(iProject);
            }
            DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public String getProjectNameByLaunchConfig(ILaunchConfiguration iLaunchConfiguration) {
        Map map;
        block3: {
            try {
                map = iLaunchConfiguration.getAttribute("argument_map", null);
                if (map != null) break block3;
                return null;
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
                return null;
            }
        }
        return (String)map.get("project");
    }

    public int getPlatformByLaunchConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string = null;
        try {
            string = iLaunchConfiguration.getAttribute("connector_id", null);
        }
        catch (CoreException coreException) {}
        if (string == null) {
            return 0;
        }
        if (string.equals(IOSConnector.ID)) {
            return 1;
        }
        if (string.equals(MacConnector.ID)) {
            return 2;
        }
        if (string.equals(AndroidConnector.ID)) {
            return 3;
        }
        if (string.equals(Win32Connector.ID)) {
            return 4;
        }
        return 0;
    }

    public void refreshConfigRuntime(ILaunchConfiguration iLaunchConfiguration, IProject iProject, int n2) {
        String string = null;
        String string2 = null;
        switch (n2) {
            case 1: {
                string = Connector.IOSRuntimePath.NAME;
                string2 = String.format("runtime/ios/%s.app", iProject.getName());
                break;
            }
            case 2: {
                string = Connector.MacRuntimePath.NAME;
                string2 = String.format("runtime/mac/%s.app", iProject.getName());
                break;
            }
            case 3: {
                string = Connector.AndroidRuntimePath.NAME;
                string2 = String.format("runtime/android/%s.apk", String.valueOf(iProject.getName()) + "-debug");
                break;
            }
            case 4: {
                string = Connector.Win32RuntimePath.NAME;
                string2 = String.format("runtime/win32/%s.exe", iProject.getName());
                break;
            }
        }
        String string3 = String.valueOf(iProject.getLocation().toString()) + File.separator + string2;
        File file = new File(string3);
        if (!file.exists()) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy;
            Map map = iLaunchConfiguration.getAttribute("argument_map", null);
            if (map == null) {
                return;
            }
            map.put(string, string2);
            if (n2 == 3) {
                iLaunchConfigurationWorkingCopy = AndroidUtil.extractPackageAndActivity((String)string3);
                map.put("packageName", iLaunchConfigurationWorkingCopy[0]);
                map.put(LaunchActivityArgument.NAME, iLaunchConfigurationWorkingCopy[1]);
            }
            iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
            iLaunchConfigurationWorkingCopy.setAttribute("argument_map", map);
            iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public static boolean runInBrowser(IProject iProject) {
        JSConfig jSConfig = (JSConfig)ConfigurationManager.COMMON.getConfig(JSConfig.class);
        String string = jSConfig.getJsEnginePath();
        String string2 = String.valueOf(string) + File.separator + "tools" + File.separator + "cocos2d-console" + File.separator + "bin" + File.separator + "cocos.py";
        String string3 = iProject.getProject().getLocation().toString();
        String string4 = String.format("%s %s run -s %s -p web", CommonPython.getPython(), string2, string3);
        String string5 = null;
        string5 = SystemInfo.isMac ? String.format("osascript -e 'tell app \"Terminal\" to do script \"%s\"'", string4) : String.format("cmd.exe /k start %s", string4);
        CommandHelper.execute((String)string5, null, null, null);
        return true;
    }

    public ILaunchConfiguration createLaunchConfig(IProject iProject) throws CoreException {
        String string = iProject.getName();
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("org.ccdt.debug.core.cocosLaunchConfigType");
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
        iLaunchConfigurationWorkingCopy.setAttribute("connector_id", JSLaunchManager.a());
        iLaunchConfigurationWorkingCopy.setAttribute("argument_map", JSLaunchManager.a(iProject));
        return iLaunchConfigurationWorkingCopy.doSave();
    }

    static Map a(IProject iProject) throws CoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("project", new Connector.DefaultProjectArgument(""));
        List list = JavaScriptDebugPlugin.getConnectionsManager().getConnectors();
        Connector connector = null;
        int n2 = 0;
        while (n2 < list.size()) {
            connector = (Connector)list.get(n2);
            hashMap.putAll(connector.defaultArguments());
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                if (v instanceof Connector.ProjectArgument) {
                    hashMap.put(string, iProject.getName());
                    continue;
                }
                if (v instanceof Connector.HomePageArgument) {
                    hashMap.put(string, JSLaunchManager.b(iProject));
                    continue;
                }
                if (v instanceof Connector.StringArgument) {
                    hashMap.put(string, ((Connector.StringArgument)v).value());
                    continue;
                }
                if (v instanceof Connector.BooleanArgument) {
                    hashMap.put(string, ((Connector.BooleanArgument)v).value());
                    continue;
                }
                if (v instanceof Connector.IntegerArgument) {
                    hashMap.put(string, ((Connector.IntegerArgument)v).value());
                    continue;
                }
                if (!(v instanceof IOSSimulatorFamilyArgument)) continue;
                hashMap.put(string, ((IOSSimulatorFamilyArgument)v).value());
            }
            ++n2;
        }
        return hashMap;
    }

    static String b(IProject iProject) throws CoreException {
        IFile iFile = iProject.getFile("index.html");
        if (!iFile.exists()) {
            return "";
        }
        String string = iFile.getFullPath().makeRelative().removeFirstSegments(1).toOSString();
        return string;
    }

    static String a() {
        if (SystemInfo.isWindows) {
            return Win32Connector.ID;
        }
        return MacConnector.ID;
    }
}

