/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.ui.actions;

import java.util.Iterator;
import org.ccdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.ccdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.ccdt.debug.internal.ui.Messages;
import org.ccdt.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class e
implements IBreakpointsListener,
IObjectActionDelegate,
IPartListener {
    private IStructuredSelection a;
    private IAction b;
    private IWorkbenchPart c;

    public void run(IAction iAction) {
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            try {
                IJavaScriptBreakpoint iJavaScriptBreakpoint = (IJavaScriptBreakpoint)iterator.next();
                this.doAction(iJavaScriptBreakpoint);
            }
            catch (CoreException coreException) {
                String string = Messages.breakpoint_configuration;
                String string2 = Messages.exception_occurred_setting_bp_properties;
                ExceptionHandler.handle((CoreException)coreException, (String)string, (String)string2);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setAction(iAction);
        if (iSelection.isEmpty()) {
            this.setStructuredSelection(null);
            return;
        }
        if (iSelection instanceof IStructuredSelection) {
            IBreakpoint iBreakpoint;
            this.setStructuredSelection((IStructuredSelection)iSelection);
            boolean bl = this.isEnabledFor(this.getStructuredSelection());
            iAction.setEnabled(bl);
            if (bl && this.isToggleAction() && (iBreakpoint = (IBreakpoint)this.getStructuredSelection().getFirstElement()) instanceof IJavaScriptBreakpoint) {
                try {
                    iAction.setChecked(this.getToggleState((IJavaScriptBreakpoint)iBreakpoint));
                }
                catch (CoreException coreException) {
                    JavaScriptDebugUIPlugin.log(coreException);
                }
            }
        }
    }

    protected boolean isToggleAction() {
        return true;
    }

    public abstract void doAction(IJavaScriptBreakpoint var1) throws CoreException;

    protected abstract boolean getToggleState(IJavaScriptBreakpoint var1) throws CoreException;

    protected IStructuredSelection getStructuredSelection() {
        return this.a;
    }

    protected void setStructuredSelection(IStructuredSelection iStructuredSelection) {
        this.a = iStructuredSelection;
    }

    public abstract boolean isEnabledFor(IStructuredSelection var1);

    protected IBreakpointManager getBreakpointManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    protected IBreakpoint getBreakpoint(IMarker iMarker) {
        return this.getBreakpointManager().getBreakpoint(iMarker);
    }

    protected IAction getAction() {
        return this.b;
    }

    protected void setAction(IAction iAction) {
        this.b = iAction;
    }

    public void breakpointsAdded(IBreakpoint[] iBreakpointArray) {
    }

    public void breakpointsChanged(IBreakpoint[] iBreakpointArray, IMarkerDelta[] iMarkerDeltaArray) {
        IStructuredSelection iStructuredSelection;
        if (this.getAction() != null && (iStructuredSelection = this.getStructuredSelection()) != null) {
            IBreakpoint iBreakpoint = (IBreakpoint)iStructuredSelection.getFirstElement();
            int n2 = 0;
            while (n2 < iBreakpointArray.length) {
                IBreakpoint iBreakpoint2 = iBreakpointArray[n2];
                if (iBreakpoint.equals(iBreakpoint2)) {
                    this.selectionChanged(this.getAction(), (ISelection)iStructuredSelection);
                    return;
                }
                ++n2;
            }
        }
    }

    public void breakpointsRemoved(IBreakpoint[] iBreakpointArray, IMarkerDelta[] iMarkerDeltaArray) {
    }

    protected IWorkbenchPart getPart() {
        return this.c;
    }

    protected void setPart(IWorkbenchPart iWorkbenchPart) {
        this.c = iWorkbenchPart;
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.getPart()) {
            this.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
            iWorkbenchPart.getSite().getPage().removePartListener((IPartListener)this);
        }
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        IWorkbenchPart iWorkbenchPart2 = this.getPart();
        if (iWorkbenchPart2 != null) {
            this.getPart().getSite().getPage().removePartListener((IPartListener)this);
        }
        this.getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
        this.setPart(iWorkbenchPart);
        iWorkbenchPart.getSite().getPage().addPartListener((IPartListener)this);
    }
}

