/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.debug.internal.ui;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.ccdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.ccdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.ccdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.ccdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.ccdt.debug.core.model.IJavaScriptStackFrame;
import org.ccdt.debug.core.model.IJavaScriptThread;
import org.ccdt.debug.core.model.IJavaScriptValue;
import org.ccdt.debug.core.model.IScript;
import org.ccdt.debug.core.model.IScriptGroup;
import org.ccdt.debug.internal.core.JavaScriptDebugPlugin;
import org.ccdt.debug.internal.core.TextUtils;
import org.ccdt.debug.internal.core.breakpoints.JavaScriptExceptionBreakpoint;
import org.ccdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.ccdt.debug.internal.ui.Messages;
import org.ccdt.debug.internal.ui.e;
import org.ccdt.debug.internal.ui.eval.j;
import org.ccdt.debug.internal.ui.f;
import org.ccdt.jsdt.core.Signature;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.IDebugModelPresentationExtension;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class JavaScriptModelPresentation
extends LabelProvider
implements IDebugModelPresentationExtension {
    HashMap a = null;

    public boolean requiresUIThread(Object object) {
        return false;
    }

    public void computeDetail(IValue iValue, IValueDetailListener iValueDetailListener) {
        if (iValue instanceof IJavaScriptValue) {
            iValueDetailListener.detailComputed(iValue, ((IJavaScriptValue)iValue).getDetailString());
        }
    }

    public void setAttribute(String string, Object object) {
        if (this.a == null) {
            this.a = new HashMap();
        }
        this.a.put(string, object);
    }

    public void dispose() {
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        super.dispose();
    }

    boolean a() {
        Boolean bl;
        if (this.a != null && (bl = (Boolean)this.a.get("DISPLAY_QUALIFIED_NAMES")) != null) {
            return bl;
        }
        return true;
    }

    public String getText(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (object instanceof IDebugElement) {
                if (object instanceof IDebugTarget) {
                    stringBuffer.append(((IDebugTarget)object).getName());
                } else if (object instanceof IStackFrame) {
                    stringBuffer.append(this.a((IJavaScriptStackFrame)object));
                } else if (object instanceof IThread) {
                    stringBuffer.append(this.a((IJavaScriptThread)object));
                } else if (object instanceof IVariable) {
                    stringBuffer.append(((IVariable)object).getName());
                } else if (object instanceof IValue) {
                    stringBuffer.append(((IValue)object).getValueString());
                } else if (object instanceof IScriptGroup) {
                    stringBuffer.append(Messages.scripts);
                } else if (object instanceof IScript) {
                    stringBuffer.append(this.a((IScript)object));
                }
            }
            if (object instanceof j) {
                j j2 = (j)object;
                return j2.getValue().getReferenceTypeName();
            }
            if (object instanceof ITerminate) {
                if (((ITerminate)object).isTerminated()) {
                    stringBuffer.insert(0, Messages.terminated);
                } else if (object instanceof IDisconnect && ((IDisconnect)object).isDisconnected()) {
                    stringBuffer.insert(0, Messages.disconnected);
                }
            } else if (object instanceof IDisconnect) {
                if (((IDisconnect)object).isDisconnected()) {
                    stringBuffer.insert(0, Messages.disconnected);
                }
            } else if (object instanceof IJavaScriptFunctionBreakpoint) {
                stringBuffer.append(this.a((IJavaScriptFunctionBreakpoint)object));
            } else if (object instanceof IJavaScriptLoadBreakpoint) {
                stringBuffer.append(this.a((IJavaScriptLoadBreakpoint)object));
            } else if (object instanceof IJavaScriptLineBreakpoint) {
                stringBuffer.append(this.a((IJavaScriptLineBreakpoint)object));
            }
        }
        catch (CoreException coreException) {
            JavaScriptDebugUIPlugin.log(coreException);
            stringBuffer.append(Messages.unknown);
        }
        if (stringBuffer.length() < 1) {
            return Messages.unknown;
        }
        return stringBuffer.toString();
    }

    String a(IJavaScriptThread iJavaScriptThread) throws DebugException {
        String string;
        block16: {
            string = Messages.unknown_state;
            if (iJavaScriptThread.isSuspended()) {
                IBreakpoint[] iBreakpointArray = iJavaScriptThread.getBreakpoints();
                if (iBreakpointArray.length > 0) {
                    try {
                        IJavaScriptBreakpoint iJavaScriptBreakpoint = (IJavaScriptBreakpoint)iBreakpointArray[0];
                        if (iJavaScriptBreakpoint instanceof IJavaScriptLoadBreakpoint) {
                            String string2 = iJavaScriptBreakpoint.getScriptPath();
                            if ("".equals(string2)) {
                                string2 = this.b(iJavaScriptThread);
                            } else {
                                try {
                                    string2 = URLDecoder.decode(string2, "UTF-8");
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                            }
                            string = NLS.bind((String)Messages.suspend_loading_script, (Object)string2);
                            break block16;
                        }
                        if (iJavaScriptBreakpoint instanceof JavaScriptExceptionBreakpoint) {
                            string = NLS.bind((String)Messages.suspended_on_exception, (Object)iJavaScriptBreakpoint.getMarker().getAttribute("org.ccdt.debug.core.exception_message"));
                        } else if (iJavaScriptBreakpoint instanceof IJavaScriptLineBreakpoint) {
                            IJavaScriptLineBreakpoint iJavaScriptLineBreakpoint = (IJavaScriptLineBreakpoint)iJavaScriptBreakpoint;
                            string = NLS.bind((String)Messages.suspended_on_line_breakpoint, (Object[])new String[]{Integer.toString(iJavaScriptLineBreakpoint.getLineNumber()), this.b(iJavaScriptThread)});
                        } else if (iJavaScriptBreakpoint instanceof IJavaScriptFunctionBreakpoint) {
                            IJavaScriptFunctionBreakpoint iJavaScriptFunctionBreakpoint = (IJavaScriptFunctionBreakpoint)iJavaScriptBreakpoint;
                            string = NLS.bind((String)Messages.suspended_on_func_breakpoint, (Object[])new String[]{iJavaScriptFunctionBreakpoint.getFunctionName(), this.b(iJavaScriptThread)});
                        }
                    }
                    catch (CoreException coreException) {
                        JavaScriptDebugPlugin.log((Throwable)coreException);
                    }
                } else {
                    string = Messages.suspended_state;
                }
            } else {
                string = iJavaScriptThread.isTerminated() ? Messages.terminated_state : Messages.running_state;
            }
        }
        return NLS.bind((String)Messages.thread_name, (Object[])new String[]{iJavaScriptThread.getName(), string});
    }

    String b(IJavaScriptThread iJavaScriptThread) throws DebugException {
        IJavaScriptStackFrame iJavaScriptStackFrame = (IJavaScriptStackFrame)iJavaScriptThread.getTopStackFrame();
        if (iJavaScriptStackFrame != null) {
            try {
                String string = URLDecoder.decode(iJavaScriptStackFrame.getSourceName(), "UTF-8");
                return TextUtils.shortenText((String)string, (int)100);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return Messages.evald_script;
    }

    String a(IJavaScriptStackFrame iJavaScriptStackFrame) throws DebugException {
        String string = iJavaScriptStackFrame.getName();
        if (string == null || string.trim().length() < 1) {
            return NLS.bind((String)Messages.stackframe_name, (Object[])new String[]{iJavaScriptStackFrame.getSourceName(), Integer.toString(iJavaScriptStackFrame.getLineNumber())});
        }
        return NLS.bind((String)Messages.JavaScriptModelPresentation_stackframe_name_with_fname, (Object[])new String[]{iJavaScriptStackFrame.getSourceName(), string, Integer.toString(iJavaScriptStackFrame.getLineNumber())});
    }

    String a(IScript iScript) {
        try {
            String string = URLDecoder.decode(iScript.sourceURI().toString(), "UTF-8");
            return TextUtils.shortenText((String)string, (int)100);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return Messages.unknown;
        }
    }

    String a(IJavaScriptLineBreakpoint iJavaScriptLineBreakpoint) throws CoreException {
        String string = this.a(iJavaScriptLineBreakpoint.getScriptPath());
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(NLS.bind((String)Messages.bp_line_number, (Object[])new String[]{Integer.toString(iJavaScriptLineBreakpoint.getLineNumber())}));
        int n2 = iJavaScriptLineBreakpoint.getHitCount();
        if (n2 > 0) {
            stringBuffer.append(NLS.bind((String)Messages.bp_hit_count, (Object[])new String[]{Integer.toString(n2)}));
        }
        if (iJavaScriptLineBreakpoint.isConditionEnabled()) {
            stringBuffer.append(Messages.bp_conditonal);
        }
        if (iJavaScriptLineBreakpoint.getSuspendPolicy() == 2) {
            stringBuffer.append(Messages.bp_suspend_vm);
        }
        return stringBuffer.toString();
    }

    String a(IJavaScriptFunctionBreakpoint iJavaScriptFunctionBreakpoint) throws CoreException {
        String string = this.a(iJavaScriptFunctionBreakpoint.getScriptPath());
        StringBuffer stringBuffer = new StringBuffer(string);
        if (iJavaScriptFunctionBreakpoint.isEntry()) {
            if (iJavaScriptFunctionBreakpoint.isExit()) {
                stringBuffer.append(Messages.bp_entry_and_exit);
            } else {
                stringBuffer.append(Messages.bp_entry_only);
            }
        } else if (iJavaScriptFunctionBreakpoint.isExit()) {
            stringBuffer.append(Messages.bp_exit_only);
        }
        int n2 = iJavaScriptFunctionBreakpoint.getHitCount();
        if (n2 > 0) {
            stringBuffer.append(NLS.bind((String)Messages.bp_hit_count, (Object[])new String[]{Integer.toString(n2)}));
        }
        if (iJavaScriptFunctionBreakpoint.isConditionEnabled()) {
            stringBuffer.append(Messages.bp_conditional);
        }
        if (iJavaScriptFunctionBreakpoint.getSuspendPolicy() == 2) {
            stringBuffer.append(Messages.bp_suspend_vm);
        }
        String string2 = Signature.toString((String)iJavaScriptFunctionBreakpoint.getSignature(), (String)iJavaScriptFunctionBreakpoint.getFunctionName(), null, (boolean)false, (boolean)false);
        stringBuffer.append(" - ").append(string2);
        return stringBuffer.toString();
    }

    String a(IJavaScriptLoadBreakpoint iJavaScriptLoadBreakpoint) throws CoreException {
        String string = this.a(iJavaScriptLoadBreakpoint.getScriptPath());
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = iJavaScriptLoadBreakpoint.getHitCount();
        if (n2 > 0) {
            stringBuffer.append(NLS.bind((String)Messages.bp_hit_count, (Object[])new String[]{Integer.toString(n2)}));
        }
        if (iJavaScriptLoadBreakpoint.getSuspendPolicy() == 2) {
            stringBuffer.append(Messages.bp_suspend_vm);
        }
        return stringBuffer.toString();
    }

    String a(String string) {
        if (!this.a()) {
            try {
                return URIUtil.lastSegment((URI)URIUtil.fromString((String)string));
            }
            catch (URISyntaxException uRISyntaxException) {
                JavaScriptDebugUIPlugin.log(uRISyntaxException);
            }
        }
        return string;
    }

    public Image getImage(Object object) {
        try {
            if (object instanceof IVariable) {
                IVariable iVariable = (IVariable)object;
                return this.a(iVariable);
            }
            if (object instanceof IJavaScriptLineBreakpoint || object instanceof IJavaScriptFunctionBreakpoint) {
                IJavaScriptBreakpoint iJavaScriptBreakpoint = (IJavaScriptBreakpoint)object;
                int n2 = this.a(iJavaScriptBreakpoint);
                if (iJavaScriptBreakpoint.isEnabled()) {
                    return f.a((ImageDescriptor)new e(f.a("IMG_BRKP"), n2));
                }
                return f.a((ImageDescriptor)new e(f.a("IMG_BRKP_DISABLED"), n2));
            }
            if (object instanceof IScript) {
                return f.a((ImageDescriptor)new e(f.a("IMG_SCRIPT"), 0));
            }
            if (object instanceof IScriptGroup) {
                return f.a((ImageDescriptor)new e(f.a("IMG_SCRIPT_GRP"), 0));
            }
        }
        catch (DebugException debugException) {
            JavaScriptDebugUIPlugin.log(debugException);
        }
        catch (CoreException coreException) {
            JavaScriptDebugUIPlugin.log(coreException);
        }
        return null;
    }

    int a(IJavaScriptBreakpoint iJavaScriptBreakpoint) {
        int n2 = 0;
        try {
            if (iJavaScriptBreakpoint.isEnabled()) {
                n2 |= 8;
            }
            if (iJavaScriptBreakpoint.isInstalled()) {
                n2 |= 1;
            }
            if (iJavaScriptBreakpoint instanceof IJavaScriptLineBreakpoint && ((IJavaScriptLineBreakpoint)iJavaScriptBreakpoint).isConditionEnabled()) {
                n2 |= 0x10;
            }
            if (iJavaScriptBreakpoint instanceof IJavaScriptFunctionBreakpoint) {
                IJavaScriptFunctionBreakpoint iJavaScriptFunctionBreakpoint = (IJavaScriptFunctionBreakpoint)iJavaScriptBreakpoint;
                if (iJavaScriptFunctionBreakpoint.isEntry()) {
                    n2 |= 2;
                }
                if (iJavaScriptFunctionBreakpoint.isExit()) {
                    n2 |= 4;
                }
            }
        }
        catch (CoreException coreException) {}
        return n2;
    }

    Image a(IVariable iVariable) throws DebugException {
        String string = iVariable.getName();
        if ("this".equals(string)) {
            return f.a((ImageDescriptor)new e(f.a("IMG_THIS_VAR"), 0));
        }
        if ("[proto]".equals(string)) {
            return f.a((ImageDescriptor)new e(f.a("IMG_PROTO_VAR"), 0));
        }
        return f.a("IMG_LOCAL_VAR");
    }

    public String getEditorId(IEditorInput iEditorInput, Object object) {
        try {
            IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor((String)iEditorInput.getName());
            return iEditorDescriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public IEditorInput getEditorInput(Object object) {
        IJavaScriptLoadBreakpoint iJavaScriptLoadBreakpoint;
        if (object instanceof LocalFileStorage) {
            return this.getEditorInput(((LocalFileStorage)object).getFile());
        }
        if (object instanceof File) {
            return new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile((File)object));
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (object instanceof IJavaScriptLoadBreakpoint) {
            try {
                iJavaScriptLoadBreakpoint = (IJavaScriptLoadBreakpoint)object;
                Path path = new Path(iJavaScriptLoadBreakpoint.getScriptPath());
                IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                if (iResource != null && iResource.getType() == 1) {
                    return new FileEditorInput((IFile)iResource);
                }
            }
            catch (CoreException coreException) {
                JavaScriptDebugUIPlugin.log(coreException);
            }
        }
        if (object instanceof IJavaScriptBreakpoint && (iJavaScriptLoadBreakpoint = ((IJavaScriptBreakpoint)object).getMarker().getResource()).getType() == 1) {
            return new FileEditorInput((IFile)iJavaScriptLoadBreakpoint);
        }
        return null;
    }
}

