/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.ui;

import java.util.ArrayList;
import java.util.Vector;
import org.ccdt.jsdt.core.IClassFile;
import org.ccdt.jsdt.core.IJarEntryResource;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptElementDelta;
import org.ccdt.jsdt.core.IJavaScriptModel;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.IJavaScriptUnit;
import org.ccdt.jsdt.core.IPackageFragment;
import org.ccdt.jsdt.core.IPackageFragmentRoot;
import org.ccdt.jsdt.core.IParent;
import org.ccdt.jsdt.core.ISourceReference;
import org.ccdt.jsdt.core.IType;
import org.ccdt.jsdt.core.ITypeRoot;
import org.ccdt.jsdt.core.JavaScriptCore;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.ui.packageview.NamespaceGroup;
import org.ccdt.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.ccdt.jsdt.ui.IWorkingCopyProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class StandardJavaScriptElementContentProvider
implements IWorkingCopyProvider,
ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardJavaScriptElementContentProvider() {
        this(false);
    }

    public StandardJavaScriptElementContentProvider(boolean bl2) {
        this.fProvideMembers = bl2;
        this.fProvideWorkingCopy = bl2;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean bl2) {
        this.fProvideMembers = bl2;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    @Override
    public boolean providesWorkingCopies() {
        return this.getProvideWorkingCopy();
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object object) {
        if (!this.exists(object)) {
            return NO_CHILDREN;
        }
        try {
            if (object instanceof IJavaScriptModel) {
                return this.getJavaProjects((IJavaScriptModel)object);
            }
            if (object instanceof IJavaScriptProject) {
                return this.getPackageFragmentRoots((IJavaScriptProject)object);
            }
            if (object instanceof IPackageFragmentRoot) {
                return this.getPackageFragmentRootContent((IPackageFragmentRoot)object);
            }
            if (object instanceof IPackageFragment) {
                return this.getPackageContent((IPackageFragment)object);
            }
            if (object instanceof IFolder) {
                return this.getFolderContent((IFolder)object);
            }
            if (object instanceof IJarEntryResource) {
                return ((IJarEntryResource)object).getChildren();
            }
            if (this.getProvideMembers() && object instanceof ISourceReference && object instanceof IParent) {
                if (object instanceof ITypeRoot) {
                    return this.filter(((IParent)object).getChildren());
                }
                return ((IParent)object).getChildren();
            }
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    protected boolean matches(IJavaScriptElement iJavaScriptElement) {
        if (iJavaScriptElement.getElementType() == 7 && (iJavaScriptElement.getParent().getElementType() == 5 || iJavaScriptElement.getParent().getElementType() == 6)) {
            IType iType = (IType)iJavaScriptElement;
            try {
                return iType.isAnonymous();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                javaScriptModelException.printStackTrace();
            }
        }
        return false;
    }

    protected IJavaScriptElement[] filter(IJavaScriptElement[] iJavaScriptElementArray) {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < iJavaScriptElementArray.length) {
            if (this.matches(iJavaScriptElementArray[n2])) {
                bl2 = true;
                break;
            }
            ++n2;
        }
        if (!bl2) {
            return iJavaScriptElementArray;
        }
        Vector<IJavaScriptElement> vector = new Vector<IJavaScriptElement>();
        int n3 = 0;
        while (n3 < iJavaScriptElementArray.length) {
            if (!this.matches(iJavaScriptElementArray[n3])) {
                vector.addElement(iJavaScriptElementArray[n3]);
            }
            ++n3;
        }
        Object[] objectArray = new IJavaScriptElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasChildren(Object object) {
        Object[] objectArray;
        if (this.getProvideMembers()) {
            if (object instanceof IJavaScriptUnit || object instanceof IClassFile) {
                try {
                    if (object instanceof IJavaScriptUnit) {
                        IJavaScriptUnit iJavaScriptUnit = (IJavaScriptUnit)object;
                        return iJavaScriptUnit.hasChildren();
                    }
                    if (object instanceof IClassFile) {
                        IClassFile iClassFile = (IClassFile)object;
                        return iClassFile.hasChildren();
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return false;
                }
                return true;
            }
        } else if (object instanceof IJavaScriptUnit || object instanceof IClassFile || object instanceof IFile) {
            return false;
        }
        if (object instanceof IJavaScriptProject && !(objectArray = (Object[])object).getProject().isOpen()) {
            return false;
        }
        if (object instanceof IParent) {
            try {
                if (((IParent)object).hasChildren()) {
                    return true;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return true;
            }
        }
        if (object instanceof NamespaceGroup || object instanceof PackageFragmentRootContainer) {
            return true;
        }
        objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public Object getParent(Object object) {
        if (!this.exists(object)) {
            return null;
        }
        return this.internalGetParent(object);
    }

    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot iPackageFragmentRoot) throws JavaScriptModelException {
        Object[] objectArray = iPackageFragmentRoot.getChildren();
        if (this.isProjectPackageFragmentRoot(iPackageFragmentRoot)) {
            return objectArray;
        }
        Object[] objectArray2 = iPackageFragmentRoot.getNonJavaScriptResources();
        if (objectArray2 == null) {
            return objectArray;
        }
        return StandardJavaScriptElementContentProvider.concatenate(objectArray, objectArray2);
    }

    protected Object[] getPackageFragmentRoots(IJavaScriptProject iJavaScriptProject) throws JavaScriptModelException {
        if (!iJavaScriptProject.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaScriptProject.getPackageFragmentRoots();
        ArrayList<Object> arrayList = new ArrayList<Object>(iPackageFragmentRootArray.length);
        int n2 = 0;
        while (n2 < iPackageFragmentRootArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
            if (this.isProjectPackageFragmentRoot(iPackageFragmentRoot)) {
                Object[] objectArray = this.getPackageFragmentRootContent(iPackageFragmentRoot);
                int n3 = 0;
                while (n3 < objectArray.length) {
                    arrayList.add(objectArray[n3]);
                    ++n3;
                }
            } else {
                arrayList.add(iPackageFragmentRoot);
            }
            ++n2;
        }
        Object[] objectArray = iJavaScriptProject.getNonJavaScriptResources();
        int n4 = 0;
        while (n4 < objectArray.length) {
            arrayList.add(objectArray[n4]);
            ++n4;
        }
        return arrayList.toArray();
    }

    protected Object[] getJavaProjects(IJavaScriptModel iJavaScriptModel) throws JavaScriptModelException {
        return iJavaScriptModel.getJavaScriptProjects();
    }

    protected Object[] getPackageContent(IPackageFragment iPackageFragment) throws JavaScriptModelException {
        if (iPackageFragment.getKind() == 1) {
            return StandardJavaScriptElementContentProvider.concatenate(iPackageFragment.getJavaScriptUnits(), iPackageFragment.getNonJavaScriptResources());
        }
        return StandardJavaScriptElementContentProvider.concatenate(iPackageFragment.getClassFiles(), iPackageFragment.getNonJavaScriptResources());
    }

    protected Object[] getFolderContent(IFolder iFolder) throws CoreException {
        Object[] objectArray = iFolder.members();
        IJavaScriptProject iJavaScriptProject = JavaScriptCore.create((IProject)iFolder.getProject());
        if (iJavaScriptProject == null || !iJavaScriptProject.exists()) {
            return objectArray;
        }
        boolean bl2 = iJavaScriptProject.isOnIncludepath((IResource)iFolder);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (bl2) {
                if (iJavaScriptProject.findPackageFragmentRoot(object.getFullPath()) == null) {
                    arrayList.add(object);
                }
            } else if (!iJavaScriptProject.isOnIncludepath((IResource)object)) {
                arrayList.add(object);
            }
            ++n2;
        }
        return arrayList.toArray();
    }

    protected boolean isClassPathChange(IJavaScriptElementDelta iJavaScriptElementDelta) {
        if (iJavaScriptElementDelta.getElement().getElementType() != 3) {
            return false;
        }
        int n2 = iJavaScriptElementDelta.getFlags();
        return iJavaScriptElementDelta.getKind() == 4 && (n2 & 0x40) != 0 || (n2 & 0x80) != 0 || (n2 & 0x100) != 0;
    }

    protected Object skipProjectPackageFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot) {
        if (this.isProjectPackageFragmentRoot(iPackageFragmentRoot)) {
            return iPackageFragmentRoot.getParent();
        }
        return iPackageFragmentRoot;
    }

    protected boolean isPackageFragmentEmpty(IJavaScriptElement iJavaScriptElement) throws JavaScriptModelException {
        IPackageFragment iPackageFragment;
        return iJavaScriptElement instanceof IPackageFragment && (iPackageFragment = (IPackageFragment)iJavaScriptElement).exists() && !iPackageFragment.hasChildren() && iPackageFragment.getNonJavaScriptResources().length <= 0 && iPackageFragment.hasSubpackages();
    }

    protected boolean isProjectPackageFragmentRoot(IPackageFragmentRoot iPackageFragmentRoot) {
        IJavaScriptProject iJavaScriptProject = iPackageFragmentRoot.getJavaScriptProject();
        return iJavaScriptProject != null && iJavaScriptProject.getPath().equals((Object)iPackageFragmentRoot.getPath());
    }

    protected boolean exists(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IResource) {
            return ((IResource)object).exists();
        }
        if (object instanceof IJavaScriptElement) {
            return ((IJavaScriptElement)object).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object object) {
        if (object instanceof IResource) {
            IContainer iContainer = ((IResource)object).getParent();
            IJavaScriptElement iJavaScriptElement = JavaScriptCore.create((IResource)iContainer);
            if (iJavaScriptElement != null && iJavaScriptElement.exists()) {
                return iJavaScriptElement;
            }
            return iContainer;
        }
        if (object instanceof IJavaScriptElement) {
            IJavaScriptElement iJavaScriptElement = ((IJavaScriptElement)object).getParent();
            if (object instanceof IPackageFragment) {
                return this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)iJavaScriptElement);
            }
            return iJavaScriptElement;
        }
        if (object instanceof IJarEntryResource) {
            return ((IJarEntryResource)object).getParent();
        }
        return null;
    }

    protected static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        int n2 = objectArray.length;
        int n3 = objectArray2.length;
        if (n2 == 0) {
            return objectArray2;
        }
        if (n3 == 0) {
            return objectArray;
        }
        Object[] objectArray3 = new Object[n2 + n3];
        System.arraycopy(objectArray, 0, objectArray3, 0, n2);
        System.arraycopy(objectArray2, 0, objectArray3, n2, n3);
        return objectArray3;
    }
}

