/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.ui.text.java;

import org.ccdt.jsdt.internal.ui.text.ISourceVersionDependent;
import org.ccdt.jsdt.internal.ui.text.JavaPairMatcher;
import org.ccdt.jsdt.internal.ui.text.java.JavaDoubleClickSelector$AtJavaIdentifierDetector;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class JavaDoubleClickSelector
implements ISourceVersionDependent,
ITextDoubleClickStrategy {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected JavaPairMatcher fPairMatcher = new JavaPairMatcher(BRACKETS);
    protected final JavaDoubleClickSelector$AtJavaIdentifierDetector fWordDetector = new JavaDoubleClickSelector$AtJavaIdentifierDetector(null);

    public void doubleClicked(ITextViewer iTextViewer) {
        int n2 = iTextViewer.getSelectedRange().x;
        if (n2 < 0) {
            return;
        }
        IDocument iDocument = iTextViewer.getDocument();
        IRegion iRegion = this.fPairMatcher.match(iDocument, n2);
        if (iRegion != null && iRegion.getLength() >= 2) {
            iTextViewer.setSelectedRange(iRegion.getOffset() + 1, iRegion.getLength() - 2);
        } else {
            iRegion = this.selectWord(iDocument, n2);
            iTextViewer.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
        }
    }

    protected IRegion selectWord(IDocument iDocument, int n2) {
        return this.fWordDetector.getWordSelection(iDocument, n2);
    }

    @Override
    public void setSourceVersion(String string) {
        this.fPairMatcher.setSourceVersion(string);
        this.fWordDetector.setSourceVersion(string);
    }
}

