/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.ui.javaeditor;

import java.util.ResourceBundle;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.IJavaScriptUnit;
import org.ccdt.jsdt.internal.ui.JavaScriptPlugin;
import org.ccdt.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.ccdt.jsdt.internal.ui.javaeditor.IndentUtil;
import org.ccdt.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.ccdt.jsdt.internal.ui.javaeditor.JavaMoveLinesAction$SharedState;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class JavaMoveLinesAction
extends TextEditorAction {
    private final boolean a;
    private final boolean b;
    private final JavaMoveLinesAction$SharedState c;

    public static JavaMoveLinesAction[] createMoveCopyActionSet(ResourceBundle resourceBundle, CompilationUnitEditor compilationUnitEditor) {
        JavaMoveLinesAction$SharedState javaMoveLinesAction$SharedState = new JavaMoveLinesAction$SharedState(compilationUnitEditor);
        JavaMoveLinesAction[] javaMoveLinesActionArray = new JavaMoveLinesAction[]{new JavaMoveLinesAction(resourceBundle, "Editor.MoveLinesUp.", true, false, javaMoveLinesAction$SharedState), new JavaMoveLinesAction(resourceBundle, "Editor.MoveLinesDown.", false, false, javaMoveLinesAction$SharedState), new JavaMoveLinesAction(resourceBundle, "Editor.CopyLineUp.", true, true, javaMoveLinesAction$SharedState), new JavaMoveLinesAction(resourceBundle, "Editor.CopyLineDown.", false, true, javaMoveLinesAction$SharedState)};
        return javaMoveLinesActionArray;
    }

    public void setEditor(ITextEditor iTextEditor) {
        Assert.isTrue((boolean)(iTextEditor instanceof CompilationUnitEditor));
        super.setEditor(iTextEditor);
        if (this.c != null) {
            this.c.fEditor = (CompilationUnitEditor)iTextEditor;
        }
    }

    private JavaMoveLinesAction(ResourceBundle resourceBundle, String string, boolean bl2, boolean bl3, JavaMoveLinesAction$SharedState javaMoveLinesAction$SharedState) {
        super(resourceBundle, string, (ITextEditor)javaMoveLinesAction$SharedState.fEditor);
        this.a = bl2;
        this.b = bl3;
        this.c = javaMoveLinesAction$SharedState;
        this.update();
    }

    private boolean a(ITextSelection iTextSelection, ISourceViewer iSourceViewer) {
        block7: {
            int n2;
            IDocument iDocument;
            int n3;
            block8: {
                int n4;
                IRegion iRegion;
                block5: {
                    int n5;
                    block6: {
                        n5 = iTextSelection.getOffset();
                        n3 = n5 + iTextSelection.getLength();
                        iDocument = iSourceViewer.getDocument();
                        iRegion = iSourceViewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)iSourceViewer).getModelCoverage() : iSourceViewer.getVisibleRegion();
                        n4 = iRegion.getOffset();
                        try {
                            if (n4 <= n5) break block5;
                            if (iDocument.getLineOfOffset(n4) == iTextSelection.getStartLine()) break block6;
                            return false;
                        }
                        catch (BadLocationException badLocationException) {
                            return false;
                        }
                    }
                    if (this.a(iDocument.get(n5, n4 - n5))) break block5;
                    this.b();
                    return false;
                }
                n2 = n4 + iRegion.getLength();
                if (n2 >= n3) break block7;
                if (iDocument.getLineOfOffset(n2) == iTextSelection.getEndLine()) break block8;
                return false;
            }
            if (this.a(iDocument.get(n2, n3 - n2))) break block7;
            this.b();
            return false;
        }
        return true;
    }

    private ITextSelection a(IDocument iDocument, ITextSelection iTextSelection, ISourceViewer iSourceViewer) throws BadLocationException {
        int n2 = iDocument.getLineOffset(iTextSelection.getStartLine());
        int n3 = iTextSelection.getEndLine();
        int n4 = iDocument.getLineOffset(n3) + iDocument.getLineLength(n3);
        String string = iDocument.getLineDelimiter(n3);
        if (string != null) {
            n4 -= string.length();
        }
        return new TextSelection(iDocument, n2, n4 - n2);
    }

    private ITextSelection a(IDocument iDocument, ITextSelection iTextSelection) {
        int n2;
        int n3 = n2 = this.a ? iTextSelection.getStartLine() - 1 : iTextSelection.getEndLine() + 1;
        if (n2 > iDocument.getNumberOfLines() || !this.b && (n2 < 0 || n2 == iDocument.getNumberOfLines())) {
            return null;
        }
        try {
            if (this.b && n2 == -1) {
                n2 = 0;
            }
            IRegion iRegion = iDocument.getLineInformation(n2);
            return new TextSelection(iDocument, iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean a(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    public void runWithEvent(Event event) {
        if (this.c.fEditor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        ISourceViewer iSourceViewer = this.c.fEditor.getViewer();
        if (iSourceViewer == null) {
            return;
        }
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        ITextSelection iTextSelection = (ITextSelection)iSourceViewer.getSelectionProvider().getSelection();
        if (iTextSelection.isEmpty()) {
            return;
        }
        ITextSelection iTextSelection2 = this.a(iDocument, iTextSelection);
        if (iTextSelection2 == null) {
            return;
        }
        try {
            ITextSelection iTextSelection3 = this.a(iDocument, iTextSelection, iSourceViewer);
            if (!this.a(iTextSelection3, iSourceViewer) || !this.a(iTextSelection2, iSourceViewer)) {
                return;
            }
            String string = iTextSelection3.getText();
            String string2 = iTextSelection2.getText();
            if (string == null || string2 == null || iDocument.getLength() == 0) {
                return;
            }
            try {
                int n2;
                String string3;
                if (this.a) {
                    String string4 = iDocument.getLineDelimiter(iTextSelection2.getEndLine());
                    if (this.b) {
                        string4 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
                        string3 = String.valueOf(string) + string4;
                        n2 = iTextSelection3.getOffset();
                    } else {
                        Assert.isNotNull((Object)string4);
                        string3 = String.valueOf(string) + string4 + string2;
                        n2 = iTextSelection2.getOffset();
                    }
                } else {
                    String string5 = iDocument.getLineDelimiter(iTextSelection3.getEndLine());
                    if (this.b) {
                        if (string5 == null) {
                            string5 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
                            string3 = String.valueOf(string5) + string;
                        } else {
                            string3 = String.valueOf(string) + string5;
                        }
                        n2 = iTextSelection2.getOffset();
                    } else {
                        Assert.isNotNull((Object)string5);
                        string3 = String.valueOf(string2) + string5 + string;
                        n2 = iTextSelection3.getOffset();
                    }
                }
                int n3 = this.b ? 0 : string3.length();
                ILineRange iLineRange = this.b(iDocument, iTextSelection3);
                if (this.b) {
                    this.c.endCompoundEdit();
                }
                this.c.beginCompoundEdit();
                this.c.a = true;
                iDocument.replace(n2, n3, string3);
                Object object = this.a && this.b ? iLineRange : (this.a ? new LineRange(iLineRange.getStartLine() - 1, iLineRange.getNumberOfLines()) : (this.b ? new LineRange(iLineRange.getStartLine() + iLineRange.getNumberOfLines(), iLineRange.getNumberOfLines()) : new LineRange(iLineRange.getStartLine() + 1, iLineRange.getNumberOfLines())));
                this.c.fResult = IndentUtil.indentLines(iDocument, object, this.a(), this.c.fResult);
                IRegion iRegion = this.a(iDocument, (ILineRange)object);
                this.a((ITextViewer)iSourceViewer, iRegion.getOffset(), iRegion.getLength());
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
        finally {
            this.c.a = false;
            if (this.b) {
                this.c.endCompoundEdit();
            }
        }
    }

    private IJavaScriptProject a() {
        IEditorInput iEditorInput = this.c.fEditor.getEditorInput();
        IJavaScriptUnit iJavaScriptUnit = JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput);
        if (iJavaScriptUnit != null) {
            return iJavaScriptUnit.getJavaScriptProject();
        }
        return null;
    }

    private ILineRange b(IDocument iDocument, ITextSelection iTextSelection) throws BadLocationException {
        int n2 = iTextSelection.getOffset();
        int n3 = iDocument.getLineOfOffset(n2);
        int n4 = n2 + iTextSelection.getLength();
        int n5 = iDocument.getLineOfOffset(n4);
        int n6 = n5 - n3 + 1;
        return new LineRange(n3, n6);
    }

    private IRegion a(IDocument iDocument, ILineRange iLineRange) throws BadLocationException {
        int n2;
        int n3 = iLineRange.getStartLine();
        int n4 = iDocument.getLineOffset(n3);
        int n5 = iLineRange.getNumberOfLines();
        if (n5 < 1) {
            return new Region(n4, 0);
        }
        int n6 = n3 + n5 - 1;
        if (this.c.fEditor.isBlockSelectionModeEnabled()) {
            IRegion iRegion = iDocument.getLineInformation(n6);
            n2 = iRegion.getOffset() + iRegion.getLength();
        } else {
            n2 = iDocument.getLineOffset(n6) + iDocument.getLineLength(n6);
        }
        return new Region(n4, n2 - n4);
    }

    private void a(ITextViewer iTextViewer, int n2, int n3) {
        iTextViewer.setSelectedRange(n2 + n3, -n3);
        StyledText styledText = iTextViewer.getTextWidget();
        if (styledText != null) {
            styledText.showSelection();
        }
    }

    private void b() {
        IEditorStatusLine iEditorStatusLine = (IEditorStatusLine)this.c.fEditor.getAdapter(IEditorStatusLine.class);
        if (iEditorStatusLine == null) {
            return;
        }
        iEditorStatusLine.setMessage(false, JavaEditorMessages.Editor_MoveLines_IllegalMove_status, null);
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor());
        }
    }
}

