/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import org.ccdt.jsdt.core.IClassFile;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.IJavaScriptProject;
import org.ccdt.jsdt.core.IJavaScriptUnit;
import org.ccdt.jsdt.core.ILocalVariable;
import org.ccdt.jsdt.core.IMember;
import org.ccdt.jsdt.core.ISourceRange;
import org.ccdt.jsdt.core.ISourceReference;
import org.ccdt.jsdt.core.JavaScriptCore;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.core.util.Util;
import org.ccdt.jsdt.internal.corext.d.o;
import org.ccdt.jsdt.internal.corext.d.r;
import org.ccdt.jsdt.internal.ui.JavaScriptPlugin;
import org.ccdt.jsdt.internal.ui.javaeditor.EditorUtility$1;
import org.ccdt.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.ccdt.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.ccdt.jsdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.ccdt.jsdt.internal.ui.javaeditor.JavaEditor;
import org.ccdt.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.ccdt.jsdt.ui.JavaScriptUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorUtility {
    public static IEditorPart isOpenInEditor(Object object) {
        IWorkbenchPage iWorkbenchPage;
        IEditorInput iEditorInput = null;
        try {
            iEditorInput = EditorUtility.getEditorInput(object);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            JavaScriptPlugin.log(javaScriptModelException.getStatus());
        }
        if (iEditorInput != null && (iWorkbenchPage = JavaScriptPlugin.getActivePage()) != null) {
            return iWorkbenchPage.findEditor(iEditorInput);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object object) throws JavaScriptModelException, PartInitException {
        return EditorUtility.openInEditor(object, true);
    }

    public static IEditorPart openInEditor(Object object, boolean bl2) throws JavaScriptModelException, PartInitException {
        IJavaScriptElement iJavaScriptElement;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage;
        Object object2;
        if (object instanceof IFile) {
            return EditorUtility.a((IFile)object, bl2);
        }
        if (object instanceof IJavaScriptElement && ((IJavaScriptElement)object).isVirtual() && (object2 = ((IJavaScriptElement)object).getHostPath()) != null) {
            IFile iFile = ((IJavaScriptElement)object).getJavaScriptProject().getProject().getWorkspace().getRoot().getFileForLocation((IPath)new Path(((URI)object2).getPath()));
            if (iFile == null || !iFile.exists()) {
                iFile = ((IJavaScriptElement)object).getJavaScriptProject().getProject().getWorkspace().getRoot().findMember(((URI)object2).getPath());
            }
            if (iFile != null) {
                return EditorUtility.a(iFile, bl2);
            }
            return EditorUtility.a((URI)object2, bl2);
        }
        if (object instanceof IJavaScriptElement && (object2 = (IJavaScriptUnit)((IJavaScriptElement)object).getAncestor(5)) != null && !o.a((IJavaScriptUnit)object2) && (iWorkbenchPage = JavaScriptPlugin.getActivePage()) != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && object2.equals(iJavaScriptElement = EditorUtility.getEditorInputJavaElement(iEditorPart, false))) {
            if (bl2 && iWorkbenchPage.getActivePart() != iEditorPart) {
                iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
            }
            return iEditorPart;
        }
        object2 = EditorUtility.getEditorInput(object);
        if (object2 == null) {
            EditorUtility.a(JavaEditorMessages.EditorUtility_no_editorInput);
        }
        return EditorUtility.a((IEditorInput)object2, EditorUtility.a((IEditorInput)object2), bl2);
    }

    public static void revealInEditor(IEditorPart iEditorPart, IJavaScriptElement iJavaScriptElement) {
        if (iJavaScriptElement == null) {
            return;
        }
        if (iEditorPart instanceof JavaEditor) {
            ((JavaEditor)iEditorPart).setSelection(iJavaScriptElement);
            return;
        }
        try {
            ISourceRange iSourceRange = null;
            if (iJavaScriptElement instanceof IJavaScriptUnit) {
                iSourceRange = null;
            } else if (iJavaScriptElement instanceof IClassFile) {
                iSourceRange = null;
            } else if (iJavaScriptElement instanceof ILocalVariable) {
                iSourceRange = ((ILocalVariable)iJavaScriptElement).getNameRange();
            } else if (iJavaScriptElement instanceof IMember) {
                iSourceRange = ((IMember)iJavaScriptElement).getNameRange();
            } else if (iJavaScriptElement instanceof ISourceReference) {
                iSourceRange = ((ISourceReference)iJavaScriptElement).getSourceRange();
            }
            if (iSourceRange != null) {
                EditorUtility.revealInEditor(iEditorPart, iSourceRange.getOffset(), iSourceRange.getLength());
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    public static void revealInEditor(IEditorPart iEditorPart, IRegion iRegion) {
        if (iEditorPart != null && iRegion != null) {
            EditorUtility.revealInEditor(iEditorPart, iRegion.getOffset(), iRegion.getLength());
        }
    }

    public static void revealInEditor(IEditorPart iEditorPart, int n2, int n3) {
        if (iEditorPart instanceof ITextEditor) {
            ((ITextEditor)iEditorPart).selectAndReveal(n2, n3);
            return;
        }
        if (iEditorPart instanceof IGotoMarker) {
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                IGotoMarker iGotoMarker = (IGotoMarker)iEditorPart;
                EditorUtility$1 editorUtility$1 = new EditorUtility$1(iEditorInput, n2, n3, iGotoMarker);
                try {
                    editorUtility$1.run(null);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    Assert.isTrue((boolean)false, (String)"this operation can not be canceled");
                }
            }
            return;
        }
        if (iEditorPart != null && iEditorPart.getEditorSite().getSelectionProvider() != null) {
            IEditorSite iEditorSite = iEditorPart.getEditorSite();
            if (iEditorSite == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = iEditorPart.getEditorSite().getSelectionProvider();
            if (iSelectionProvider == null) {
                return;
            }
            iSelectionProvider.setSelection((ISelection)new TextSelection(n2, n3));
        }
    }

    private static IEditorPart a(IFile iFile, boolean bl2) throws PartInitException {
        IWorkbenchPage iWorkbenchPage;
        if (iFile == null) {
            EditorUtility.a(JavaEditorMessages.EditorUtility_file_must_not_be_null);
        }
        if ((iWorkbenchPage = JavaScriptPlugin.getActivePage()) == null) {
            EditorUtility.a(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)bl2);
        EditorUtility.a(iEditorPart);
        return iEditorPart;
    }

    private static IEditorPart a(URI uRI, boolean bl2) throws PartInitException {
        IEditorDescriptor iEditorDescriptor;
        IWorkbenchPage iWorkbenchPage;
        if (uRI == null) {
            EditorUtility.a(JavaEditorMessages.EditorUtility_file_must_not_be_null);
        }
        if ((iWorkbenchPage = JavaScriptPlugin.getActivePage()) == null) {
            EditorUtility.a(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        if ((iEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(uRI.getPath())) == null) {
            EditorUtility.a(String.valueOf(JavaEditorMessages.EditorUtility_cantFindEditor) + uRI.toString());
        }
        IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (URI)uRI, (String)iEditorDescriptor.getId(), (boolean)bl2);
        EditorUtility.a(iEditorPart);
        return iEditorPart;
    }

    private static IEditorPart a(IEditorInput iEditorInput, String string, boolean bl2) throws PartInitException {
        Assert.isNotNull((Object)iEditorInput);
        Assert.isNotNull((Object)string);
        IWorkbenchPage iWorkbenchPage = JavaScriptPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            EditorUtility.a(JavaEditorMessages.EditorUtility_no_active_WorkbenchPage);
        }
        IEditorPart iEditorPart = iWorkbenchPage.openEditor(iEditorInput, string, bl2);
        EditorUtility.a(iEditorPart);
        return iEditorPart;
    }

    private static void a(String string) throws PartInitException {
        Status status = new Status(4, "org.ccdt.jsdt.ui", 0, string, null);
        throw new PartInitException((IStatus)status);
    }

    private static void a(IEditorPart iEditorPart) {
        if (iEditorPart instanceof ITextEditor) {
            boolean bl2;
            IAction iAction = iEditorPart.getEditorSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly");
            boolean bl3 = bl2 = iAction != null;
            if (bl2 && iEditorPart instanceof JavaEditor) {
                bl2 = JavaScriptPlugin.getDefault().getPreferenceStore().getBoolean("org.ccdt.jsdt.ui.editor.showSegments");
            } else {
                boolean bl4 = bl2 = bl2 && iAction.isEnabled() && iAction.isChecked();
            }
            if (bl2) {
                if (iAction instanceof TextEditorAction) {
                    ((TextEditorAction)iAction).setEditor(null);
                    ((TextEditorAction)iAction).setEditor((ITextEditor)iEditorPart);
                } else {
                    iAction.run();
                    iAction.run();
                }
            }
        }
    }

    private static String a(IEditorInput iEditorInput) throws PartInitException {
        IEditorDescriptor iEditorDescriptor;
        Assert.isNotNull((Object)iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            iEditorDescriptor = IDE.getEditorDescriptor((IFile)((IFileEditorInput)iEditorInput).getFile());
        } else {
            if (iEditorInput instanceof InternalClassFileEditorInput) {
                return "org.ccdt.jsdt.ui.ClassFileEditor";
            }
            String string = iEditorInput.getName();
            if (string == null) {
                EditorUtility.a(JavaEditorMessages.EditorUtility_could_not_find_editorId);
            }
            iEditorDescriptor = IDE.getEditorDescriptor((String)string);
        }
        return iEditorDescriptor.getId();
    }

    public static IJavaScriptElement getEditorInputJavaElement(IEditorPart iEditorPart, boolean bl2) {
        Assert.isNotNull((Object)iEditorPart);
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput == null) {
            return null;
        }
        IJavaScriptElement iJavaScriptElement = JavaScriptUI.getEditorInputJavaElement(iEditorInput);
        if (iJavaScriptElement != null || bl2) {
            return iJavaScriptElement;
        }
        return JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(iEditorInput, false);
    }

    private static IEditorInput a(IJavaScriptElement iJavaScriptElement) throws JavaScriptModelException {
        while (iJavaScriptElement != null) {
            Object object;
            IResource iResource;
            if (iJavaScriptElement instanceof IJavaScriptUnit && (iResource = (object = ((IJavaScriptUnit)iJavaScriptElement).getPrimary()).getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)iResource);
            }
            if (iJavaScriptElement instanceof IClassFile) {
                object = iJavaScriptElement.getElementName();
                if ((Util.isMetadataFileName((String)object) || Util.isJavaLikeFileName((String)object)) && (iResource = iJavaScriptElement.getResource()) instanceof IFile && !org.ccdt.jsdt.internal.compiler.util.Util.isArchiveFileName((String)iResource.getName())) {
                    return new FileEditorInput((IFile)iResource);
                }
                return new InternalClassFileEditorInput((IClassFile)iJavaScriptElement);
            }
            iJavaScriptElement = iJavaScriptElement.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object object) throws JavaScriptModelException {
        if (object instanceof IJavaScriptElement) {
            return EditorUtility.a((IJavaScriptElement)object);
        }
        if (object instanceof IFile) {
            return new FileEditorInput((IFile)object);
        }
        if (o.a(object)) {
            return new JarEntryEditorInput((IStorage)object);
        }
        return null;
    }

    public static IJavaScriptElement getActiveEditorJavaInput() {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = JavaScriptPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && (iEditorInput = iEditorPart.getEditorInput()) != null) {
            return JavaScriptUI.getEditorInputJavaElement(iEditorInput);
        }
        return null;
    }

    public static int findLocalizedModifier(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int n2) {
        String string = "";
        if ((n2 & 0x40000) == 262144) {
            string = EditorUtility.a(string, 262144);
        }
        if ((n2 & 0x10000) == 65536) {
            string = EditorUtility.a(string, 65536);
        }
        if ((n2 & 0x20000) == 131072) {
            string = EditorUtility.a(string, 131072);
        }
        if ((n2 & 0x400000) == 0x400000) {
            string = EditorUtility.a(string, 0x400000);
        }
        return string;
    }

    private static String a(String string, int n2) {
        if (string == null) {
            string = "";
        }
        String string2 = Action.findModifierString((int)n2);
        if (string.length() == 0) {
            return string2;
        }
        return r.a(JavaEditorMessages.EditorUtility_concatModifierStrings, new String[]{string, string2});
    }

    public static IJavaScriptProject getJavaProject(IEditorInput iEditorInput) {
        IJavaScriptProject iJavaScriptProject = null;
        if (iEditorInput instanceof IFileEditorInput) {
            IProject iProject = ((IFileEditorInput)iEditorInput).getFile().getProject();
            if (iProject != null && !(iJavaScriptProject = JavaScriptCore.create((IProject)iProject)).exists()) {
                iJavaScriptProject = null;
            }
        } else if (iEditorInput instanceof IClassFileEditorInput) {
            iJavaScriptProject = ((IClassFileEditorInput)iEditorInput).getClassFile().getJavaScriptProject();
        }
        return iJavaScriptProject;
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> hashSet = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n2 = 0;
        while (n2 < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n2].getPages();
            int n3 = 0;
            while (n3 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n3].getDirtyEditors();
                int n4 = 0;
                while (n4 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n4];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (hashSet.add(iEditorInput)) {
                        arrayList.add(iEditorPart);
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    public static IEditorPart[] getDirtyEditorsToSave(boolean bl2) {
        HashSet<IEditorInput> hashSet = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>(0);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        int n2 = 0;
        while (n2 < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n2].getPages();
            int n3 = 0;
            while (n3 < iWorkbenchPageArray.length) {
                IEditorPart[] iEditorPartArray = iWorkbenchPageArray[n3].getDirtyEditors();
                int n4 = 0;
                while (n4 < iEditorPartArray.length) {
                    IEditorPart iEditorPart = iEditorPartArray[n4];
                    IEditorInput iEditorInput = iEditorPart.getEditorInput();
                    if (EditorUtility.a(iEditorPart, iEditorInput, bl2) && hashSet.add(iEditorInput)) {
                        arrayList.add(iEditorPart);
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        return arrayList.toArray(new IEditorPart[arrayList.size()]);
    }

    private static boolean a(IEditorPart iEditorPart, IEditorInput iEditorInput, boolean bl2) {
        IJavaScriptUnit iJavaScriptUnit;
        IResource iResource = (IResource)iEditorInput.getAdapter(IResource.class);
        if (iResource == null) {
            return bl2;
        }
        IJavaScriptElement iJavaScriptElement = JavaScriptCore.create((IResource)iResource);
        if (iJavaScriptElement instanceof IJavaScriptUnit && !(iJavaScriptUnit = (IJavaScriptUnit)iJavaScriptElement).isWorkingCopy()) {
            return true;
        }
        if (!(iEditorPart instanceof ITextEditor)) {
            return bl2;
        }
        iJavaScriptUnit = (ITextEditor)iEditorPart;
        IDocumentProvider iDocumentProvider = iJavaScriptUnit.getDocumentProvider();
        if (!(iDocumentProvider instanceof TextFileDocumentProvider)) {
            return bl2;
        }
        return false;
    }
}

