/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.ui.javaeditor;

import org.ccdt.jsdt.core.IClassFile;
import org.ccdt.jsdt.core.IJavaScriptElement;
import org.ccdt.jsdt.core.JavaScriptCore;
import org.ccdt.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.ccdt.jsdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ClassFileMarkerAnnotationModel
extends AbstractMarkerAnnotationModel
implements IResourceChangeListener {
    protected IClassFile fClassFile;
    protected IWorkspace fWorkspace;
    protected IResource fMarkerResource;
    protected boolean fChangesApplied;

    public ClassFileMarkerAnnotationModel(IResource iResource) {
        this.fMarkerResource = iResource;
        this.fWorkspace = this.fMarkerResource.getWorkspace();
    }

    public void setClassFile(IClassFile iClassFile) {
        this.fClassFile = iClassFile;
    }

    protected boolean isAcceptable(IMarker iMarker) {
        try {
            return JavaScriptCore.isReferencedBy((IJavaScriptElement)this.fClassFile, (IMarker)iMarker);
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, JavaEditorMessages.ClassFileMarkerAnnotationModel_error_isAcceptable);
            return false;
        }
    }

    protected boolean isAffected(IMarkerDelta iMarkerDelta) {
        try {
            return JavaScriptCore.isReferencedBy((IJavaScriptElement)this.fClassFile, (IMarkerDelta)iMarkerDelta);
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, JavaEditorMessages.ClassFileMarkerAnnotationModel_error_isAffected);
            return false;
        }
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker iMarker) {
        return new JavaMarkerAnnotation(iMarker);
    }

    protected void listenToMarkerChanges(boolean bl2) {
        if (bl2) {
            this.fWorkspace.addResourceChangeListener((IResourceChangeListener)this);
        } else {
            this.fWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    protected void deleteMarkers(IMarker[] iMarkerArray) throws CoreException {
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        if (this.fMarkerResource != null) {
            IMarker[] iMarkerArray = this.fWorkspace.getRoot().findMarkers("org.eclipse.core.resources.marker", true, 0);
            IMarker[] iMarkerArray2 = this.fMarkerResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
            int n2 = iMarkerArray.length;
            if (n2 == 0) {
                return iMarkerArray2;
            }
            int n3 = iMarkerArray2.length;
            if (n3 == 0) {
                return iMarkerArray;
            }
            IMarker[] iMarkerArray3 = new IMarker[n3 + n2];
            System.arraycopy(iMarkerArray2, 0, iMarkerArray3, 0, n3);
            System.arraycopy(iMarkerArray, 0, iMarkerArray3, n3, n2);
            return iMarkerArray3;
        }
        return null;
    }

    private void a(IMarkerDelta[] iMarkerDeltaArray) throws CoreException {
        int n2 = 0;
        while (n2 < iMarkerDeltaArray.length) {
            if (this.isAffected(iMarkerDeltaArray[n2])) {
                IMarker iMarker = iMarkerDeltaArray[n2].getMarker();
                switch (iMarkerDeltaArray[n2].getKind()) {
                    case 1: {
                        this.addMarkerAnnotation(iMarker);
                        this.fChangesApplied = true;
                        break;
                    }
                    case 2: {
                        this.removeMarkerAnnotation(iMarker);
                        this.fChangesApplied = true;
                        break;
                    }
                    case 4: {
                        this.modifyMarkerAnnotation(iMarker);
                        this.fChangesApplied = true;
                    }
                }
            }
            ++n2;
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        try {
            IMarkerDelta[] iMarkerDeltaArray = iResourceChangeEvent.findMarkerDeltas(null, true);
            if (iMarkerDeltaArray != null) {
                this.fChangesApplied = false;
                this.a(iMarkerDeltaArray);
                if (this.fChangesApplied) {
                    this.fireModelChanged();
                }
            }
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, JavaEditorMessages.ClassFileMarkerAnnotationModel_error_resourceChanged);
        }
    }
}

