/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ccdt.jsdt.core.IClassFile;
import org.ccdt.jsdt.core.JavaScriptModelException;
import org.ccdt.jsdt.internal.ui.IResourceLocator;
import org.ccdt.jsdt.internal.ui.JavaScriptPlugin;
import org.ccdt.jsdt.internal.ui.javaeditor.ClassFileDocumentProvider$ClassFileInfo;
import org.ccdt.jsdt.internal.ui.javaeditor.ClassFileDocumentProvider$ClassFileSynchronizer;
import org.ccdt.jsdt.internal.ui.javaeditor.ClassFileDocumentProvider$InputChangeListener;
import org.ccdt.jsdt.internal.ui.javaeditor.ClassFileMarkerAnnotationModel;
import org.ccdt.jsdt.internal.ui.javaeditor.ExternalClassFileEditorInput;
import org.ccdt.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.ccdt.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.ccdt.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.ccdt.jsdt.ui.text.JavaScriptTextTools;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class ClassFileDocumentProvider
extends FileDocumentProvider {
    private List a = new ArrayList();

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof IClassFileEditorInput) {
            IClassFile iClassFile = ((IClassFileEditorInput)iEditorInput).getClassFile();
            String string2 = iClassFile.getSource();
            if (string2 == null) {
                string2 = "";
            }
            iClassFile.makeConsistent(this.getProgressMonitor());
            iDocument.set(string2);
            return true;
        }
        return super.setDocumentContent(iDocument, iEditorInput, string);
    }

    protected IAnnotationModel createClassFileAnnotationModel(IClassFileEditorInput iClassFileEditorInput) throws CoreException {
        IResource iResource = null;
        IClassFile iClassFile = iClassFileEditorInput.getClassFile();
        IResourceLocator iResourceLocator = (IResourceLocator)iClassFile.getAdapter(IResourceLocator.class);
        if (iResourceLocator != null) {
            iResource = iResourceLocator.getContainingResource(iClassFile);
        }
        if (iResource != null) {
            ClassFileMarkerAnnotationModel classFileMarkerAnnotationModel = new ClassFileMarkerAnnotationModel(iResource);
            classFileMarkerAnnotationModel.setClassFile(iClassFile);
            return classFileMarkerAnnotationModel;
        }
        return null;
    }

    protected IDocument createEmptyDocument() {
        IDocument iDocument = FileBuffers.getTextFileBufferManager().createEmptyDocument(null, LocationKind.IFILE);
        if (iDocument instanceof ISynchronizable) {
            ((ISynchronizable)iDocument).setLockObject(new Object());
        }
        return iDocument;
    }

    protected IDocument createDocument(Object object) throws CoreException {
        IDocument iDocument = super.createDocument(object);
        if (iDocument != null) {
            JavaScriptTextTools javaScriptTextTools = JavaScriptPlugin.getDefault().getJavaTextTools();
            javaScriptTextTools.setupJavaDocumentPartitioner(iDocument, "___java_partitioning");
        }
        return iDocument;
    }

    public String getEncoding(Object object) {
        InternalClassFileEditorInput internalClassFileEditorInput;
        IClassFile iClassFile;
        if (object instanceof IStorageEditorInput) {
            StorageDocumentProvider.StorageInfo storageInfo = (StorageDocumentProvider.StorageInfo)this.getElementInfo(object);
            if (storageInfo != null) {
                return storageInfo.fEncoding;
            }
            return this.getPersistedEncoding(object);
        }
        if (object instanceof InternalClassFileEditorInput && (iClassFile = (internalClassFileEditorInput = (InternalClassFileEditorInput)object).getClassFile()) != null) {
            String string = null;
            try {
                IResource iResource = iClassFile.getResource();
                string = iResource == null || !(iResource instanceof IFile) ? null : ((IFile)iResource).getCharset();
            }
            catch (CoreException coreException) {}
            return string;
        }
        return null;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (object instanceof IClassFileEditorInput) {
            IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)object;
            ExternalClassFileEditorInput externalClassFileEditorInput = null;
            if (iClassFileEditorInput instanceof ExternalClassFileEditorInput) {
                externalClassFileEditorInput = (ExternalClassFileEditorInput)iClassFileEditorInput;
            }
            if (externalClassFileEditorInput != null) {
                try {
                    this.refreshFile(externalClassFileEditorInput.getFile());
                }
                catch (CoreException coreException) {
                    this.handleCoreException(coreException, JavaEditorMessages.ClassFileDocumentProvider_error_createElementInfo);
                }
            }
            IDocument iDocument = this.createDocument(iClassFileEditorInput);
            IAnnotationModel iAnnotationModel = this.createClassFileAnnotationModel(iClassFileEditorInput);
            if (externalClassFileEditorInput != null) {
                ClassFileDocumentProvider$ClassFileInfo classFileDocumentProvider$ClassFileInfo = new ClassFileDocumentProvider$ClassFileInfo(this, iDocument, iAnnotationModel, null);
                classFileDocumentProvider$ClassFileInfo.fModificationStamp = this.computeModificationStamp((IResource)externalClassFileEditorInput.getFile());
                classFileDocumentProvider$ClassFileInfo.fEncoding = this.getPersistedEncoding(object);
                return classFileDocumentProvider$ClassFileInfo;
            }
            if (iClassFileEditorInput instanceof InternalClassFileEditorInput) {
                ClassFileDocumentProvider$ClassFileSynchronizer classFileDocumentProvider$ClassFileSynchronizer = new ClassFileDocumentProvider$ClassFileSynchronizer(this, iClassFileEditorInput);
                classFileDocumentProvider$ClassFileSynchronizer.install();
                ClassFileDocumentProvider$ClassFileInfo classFileDocumentProvider$ClassFileInfo = new ClassFileDocumentProvider$ClassFileInfo(this, iDocument, iAnnotationModel, classFileDocumentProvider$ClassFileSynchronizer);
                classFileDocumentProvider$ClassFileInfo.fEncoding = this.getPersistedEncoding(object);
                return classFileDocumentProvider$ClassFileInfo;
            }
        }
        return null;
    }

    protected void disposeElementInfo(Object object, AbstractDocumentProvider.ElementInfo elementInfo) {
        ClassFileDocumentProvider$ClassFileInfo classFileDocumentProvider$ClassFileInfo = (ClassFileDocumentProvider$ClassFileInfo)elementInfo;
        if (classFileDocumentProvider$ClassFileInfo.a != null) {
            classFileDocumentProvider$ClassFileInfo.a.uninstall();
            classFileDocumentProvider$ClassFileInfo.a = null;
        }
        super.disposeElementInfo(object, elementInfo);
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument) throws CoreException {
    }

    public boolean isSynchronized(Object object) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(object);
        if (elementInfo instanceof ClassFileDocumentProvider$ClassFileInfo) {
            IResource iResource;
            IClassFileEditorInput iClassFileEditorInput = (IClassFileEditorInput)object;
            try {
                iResource = iClassFileEditorInput.getClassFile().getUnderlyingResource();
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return true;
            }
            return iResource == null || iResource.isSynchronized(0);
        }
        return false;
    }

    protected void handleDeleted(IClassFileEditorInput iClassFileEditorInput) {
        this.fireElementDeleted(iClassFileEditorInput);
    }

    protected void fireInputChanged(IClassFileEditorInput iClassFileEditorInput) {
        ArrayList arrayList = new ArrayList(this.a);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((ClassFileDocumentProvider$InputChangeListener)iterator.next()).inputChanged(iClassFileEditorInput);
        }
    }

    public void addInputChangeListener(ClassFileDocumentProvider$InputChangeListener classFileDocumentProvider$InputChangeListener) {
        this.a.add(classFileDocumentProvider$InputChangeListener);
    }

    public void removeInputChangeListener(ClassFileDocumentProvider$InputChangeListener classFileDocumentProvider$InputChangeListener) {
        this.a.remove(classFileDocumentProvider$InputChangeListener);
    }
}

