/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.completion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.search.source.LuaEngineVaildator;
import org.ccdt.common.search.source.LuaFileVaildator;
import org.ccdt.common.search.source.LuaProjectVaildator;
import org.ccdt.common.search.source.LuaSearchPath;
import org.ccdt.common.search.source.SourceSearchUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Block;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Call;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Invoke;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaInternalContent;

public class LuaStringCompletionProposalComputer
implements IScriptCompletionProposalComputer {
    private static final String REQUIRE = "require";
    private static final String ADD_SEARCH_PATH = "addSearchPath";
    private boolean isRequire;
    private boolean isAddSearchPath;

    public void sessionStarted() {
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IDocument document = context.getDocument();
        ITypedRegion stringRegion = null;
        try {
            ITypedRegion[] partitions;
            ITypedRegion[] iTypedRegionArray = partitions = TextUtilities.computePartitioning((IDocument)document, (String)"__lua_partitioning", (int)0, (int)document.getLength(), (boolean)false);
            int n = partitions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion region = iTypedRegionArray[n2];
                if (context.getInvocationOffset() >= region.getOffset() && context.getInvocationOffset() < region.getOffset() + region.getLength()) {
                    if ("__lua_string".equals(region.getType())) {
                        stringRegion = region;
                        break;
                    }
                    if ("__lua_single_quote_string".equals(region.getType())) {
                        stringRegion = region;
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {}
        this.isRequire = false;
        this.isAddSearchPath = true;
        IProject project = null;
        if (context instanceof ScriptContentAssistInvocationContext) {
            ScriptContentAssistInvocationContext scriptContentAssistInvocationContext = (ScriptContentAssistInvocationContext)context;
            project = scriptContentAssistInvocationContext.getProject().getProject();
            ISourceModule sourceModule = scriptContentAssistInvocationContext.getSourceModule();
            LuaSourceRoot root = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)sourceModule);
            LuaInternalContent luaInternalContent = root.getInternalContent();
            Block block = luaInternalContent.getContent();
            if (stringRegion != null) {
                int regionStart = stringRegion.getOffset();
                int regionEnd = regionStart + stringRegion.getLength();
                this.findPropertyInBlock(block, regionStart, regionEnd);
            }
        }
        int position = context.getInvocationOffset();
        int start = stringRegion.getOffset();
        int end = stringRegion.getOffset() + stringRegion.getLength();
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Set searchPaths = LuaSearchPath.getSearchPathWithProject((IProject)project);
        ArrayList<Object> vaildators = new ArrayList<Object>();
        if (this.isRequire) {
            vaildators.add(new LuaFileVaildator());
            proposals.addAll(SourceSearchUtils.createRequireSearchSourcesProposals((IProject)project, (Set)searchPaths, vaildators, (IDocument)document, (int)start, (int)end, (int)position));
            String luaEnginePath = PathManager.instance.getLUAEnginePath();
            if (luaEnginePath != null) {
                File file = new File(String.valueOf(luaEnginePath) + LuaEngineVaildator.COCOS2DX_PATH);
                vaildators.add(new LuaEngineVaildator());
                proposals.addAll(SourceSearchUtils.createRequireSearchSourcesProposals((File)file, (Set)searchPaths, vaildators, (IDocument)document, (int)start, (int)end, (int)position));
            }
        } else {
            vaildators.add(new LuaProjectVaildator());
            proposals.addAll(SourceSearchUtils.createSearchSourcesProposals((IProject)project, (Set)searchPaths, vaildators, (IDocument)document, (int)start, (int)end, (int)position, (boolean)this.isAddSearchPath));
        }
        return proposals;
    }

    private void findPropertyInBlock(Block block, int start, int end) {
        List list = block.getContent();
        int i = 0;
        while (i < list.size()) {
            LuaASTNode luaASTNode = (LuaASTNode)list.get(i);
            int nodeStart = luaASTNode.sourceStart();
            int nodeEnd = luaASTNode.sourceEnd();
            if (nodeStart <= start && end <= nodeEnd) {
                if (luaASTNode instanceof Call) {
                    String itemName;
                    Identifier identifier;
                    Item item;
                    Call call = (Call)luaASTNode;
                    LuaExpression functionExpression = call.getFunction();
                    if (functionExpression instanceof Identifier && (item = (identifier = (Identifier)functionExpression).getDefinition()) != null && REQUIRE.equals(itemName = item.getName())) {
                        this.isRequire = true;
                        break;
                    }
                } else if (luaASTNode instanceof Invoke) {
                    Invoke invoke = (Invoke)luaASTNode;
                    String functionName = invoke.getFunctionName();
                    if (ADD_SEARCH_PATH.equals(functionName)) {
                        this.isAddSearchPath = false;
                        break;
                    }
                } else if (luaASTNode instanceof Block) {
                    this.findPropertyInBlock((Block)luaASTNode, start, end);
                }
            }
            ++i;
        }
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

