/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.completion;

import java.util.HashSet;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IProposalInvoker;

public class LuaProposalInvokerImpl
implements IProposalInvoker {
    public ICompletionProposal getProposal(ICompletionProposal curr, ICompletionProposal[] fFilteredProposals) {
        if (curr instanceof AbstractScriptCompletionProposal) {
            AbstractScriptCompletionProposal proposal = (AbstractScriptCompletionProposal)curr;
            String commonPrefix = this.getCommonPrefix(fFilteredProposals);
            return new CompletionProposal(commonPrefix, proposal.getReplacementOffset(), proposal.getReplacementLength(), commonPrefix.length());
        }
        return null;
    }

    private String getCommonPrefix(ICompletionProposal[] fFilteredProposals) {
        HashSet<String> displayStrings = new HashSet<String>();
        String firstStr = null;
        String currStr = null;
        if (fFilteredProposals != null) {
            int i = 0;
            while (i < fFilteredProposals.length) {
                ICompletionProposal completionProposal = fFilteredProposals[i];
                if (completionProposal instanceof AbstractScriptCompletionProposal && !(currStr = ((AbstractScriptCompletionProposal)completionProposal).getReplacementString()).contains(".")) {
                    if (displayStrings.isEmpty()) {
                        firstStr = currStr;
                    }
                    displayStrings.add(currStr);
                }
                ++i;
            }
        }
        if (displayStrings.size() == 1) {
            return firstStr;
        }
        String compare = null;
        StringBuilder commonPrefix = new StringBuilder();
        int i = 1;
        while (i <= firstStr.length()) {
            commonPrefix.append(firstStr.charAt(i - 1));
            for (String displayString : displayStrings) {
                if (displayString.length() < i) {
                    return commonPrefix.deleteCharAt(i - 1).toString();
                }
                compare = displayString.substring(0, i);
                if (compare.toLowerCase().startsWith(commonPrefix.toString().toLowerCase())) continue;
                return commonPrefix.deleteCharAt(i - 1).toString();
            }
            ++i;
        }
        return commonPrefix.toString();
    }
}

